/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.projectinfo;

import com.tssap.util.projectinfo.ComplexInfo;
import com.tssap.util.projectinfo.IPropertyInfo;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.ui.IMemento;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class PropertyInfo
extends ComplexInfo
implements IPropertyInfo {
    public static final String MAIN_PROP_TAG = "Properties";
    protected static final String INNER_PROP_TAG = "Property";
    private Properties myProps;

    PropertyInfo(Properties p) {
        this.myProps = p;
    }

    public String getProperty(String key) {
        return this.myProps.getProperty(key);
    }

    public Enumeration propertyNames() {
        return this.myProps.propertyNames();
    }

    public void setProperty(String key, String value) {
        this.myProps.setProperty(key, value);
    }

    public void removeProperty(String key) {
        ((Hashtable)this.myProps).remove(key);
    }

    private String getAttrib(String string, Node node) {
        String ret = null;
        NamedNodeMap nnm = node.getAttributes();
        Node attrNode = nnm.getNamedItem(string);
        if (attrNode != null && attrNode.getNodeType() == 2) {
            ret = attrNode.getNodeValue();
        }
        return ret;
    }

    public static Element[] getElementsFromNodeList(NodeList rootChildren) {
        ArrayList<Node> elementList = new ArrayList<Node>();
        int i = 0;
        while (i < rootChildren.getLength()) {
            if (rootChildren.item(i).getNodeType() == 1) {
                elementList.add(rootChildren.item(i));
            }
            ++i;
        }
        return elementList.toArray(new Element[elementList.size()]);
    }

    public Object createInfoObject(IMemento memento) {
        PropertyInfo ret = null;
        Properties p = new Properties();
        if (memento != null) {
            IMemento[] propMems = memento.getChildren(INNER_PROP_TAG);
            int i = 0;
            while (i < propMems.length) {
                String key = propMems[i].getString("key");
                String value = propMems[i].getString("value");
                ((Hashtable)p).put(key, value);
                ++i;
            }
        }
        ret = new PropertyInfo(p);
        return ret;
    }

    public void saveState(IMemento memento) {
        if (this.myProps != null) {
            Enumeration enumeration = ((Hashtable)this.myProps).keys();
            while (enumeration.hasMoreElements()) {
                IMemento propMem = memento.createChild(INNER_PROP_TAG);
                String key = (String)enumeration.nextElement();
                String value = this.myProps.getProperty(key);
                propMem.putString("key", key);
                propMem.putString("value", value);
            }
        }
    }
}

