/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.projectinfo;

import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.engine.lib.xml.util.DOMSerializer;
import com.tssap.util.projectinfo.ComplexInfo;
import com.tssap.util.projectinfo.IProjectInfoPropertyListener;
import com.tssap.util.projectinfo.PropertyInfo;
import com.tssap.util.projectinfo.internal.DOMMemento;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ProjectInfo {
    private static final TracerI tracer = TracingManager.getTracer(class$com$tssap$util$projectinfo$ProjectInfo == null ? (class$com$tssap$util$projectinfo$ProjectInfo = ProjectInfo.class$("com.tssap.util.projectinfo.ProjectInfo")) : class$com$tssap$util$projectinfo$ProjectInfo);
    public static final String INFO_FILENAME = ".tssapinfo";
    private static final String INFO_MAINTAG = "TSSAP-INFO";
    private static DocumentBuilderFactory dbf;
    private static DocumentBuilder myBuilder;
    private static DOMSerializer mySerializer;
    private static MyResourceChangedHandler myResourceChangedHandler;
    private static HashMap domMap;
    private static HashMap propMap;
    private static HashMap complexInfoImplMap;
    private static Map myPropertyListeners;
    private static SaveFailedReason lastSaveFailedReason;
    static /* synthetic */ Class class$com$tssap$util$projectinfo$ProjectInfo;

    public static void addComplexInfoHandler(String complexInfoKey, ComplexInfo ci) {
        complexInfoImplMap.put(complexInfoKey, ci);
    }

    private static PropertyInfo getInfoProperty(IProject project) {
        PropertyInfo ret = null;
        if (propMap.containsKey(project)) {
            ret = (PropertyInfo)propMap.get(project);
        } else {
            ret = (PropertyInfo)ProjectInfo.getComplexInfo(project, "Properties");
            propMap.put(project, ret);
        }
        return ret;
    }

    private static boolean setInfoProperty(IProject project, PropertyInfo propInfo) {
        propMap.put(project, propInfo);
        return ProjectInfo.setComplexInfo(project, propInfo, "Properties");
    }

    public static boolean setComplexInfo(IProject project, ComplexInfo complexInfo, String infoId) {
        Document doc = ProjectInfo.getInfoDocument(project);
        ProjectInfo.removeElement(doc, infoId);
        Element newElement = ProjectInfo.addElement(doc, infoId);
        DOMMemento memento = new DOMMemento(doc, newElement);
        complexInfo.saveState(memento);
        return ProjectInfo.saveDocumentInfo(project, doc);
    }

    public static Object getComplexInfo(IProject project, String infoId) {
        Object ret = null;
        Document doc = ProjectInfo.getInfoDocument(project);
        Element el = ProjectInfo.getElement(doc, infoId);
        ComplexInfo ci = (ComplexInfo)complexInfoImplMap.get(infoId);
        if (ci != null) {
            ret = el != null ? ci.createInfoObject(new DOMMemento(doc, el)) : ci.createInfoObject(null);
        }
        return ret;
    }

    private static Document getInfoDocument(IProject prj) {
        Document ret = null;
        if (domMap.containsKey(prj)) {
            ret = (Document)domMap.get(prj);
        } else {
            IFile infoFile = ProjectInfo.getInfoFile(prj);
            if (infoFile.exists()) {
                try {
                    ret = ProjectInfo.parse(infoFile.getContents(true));
                }
                catch (Exception e) {
                    tracer.error("Error parsing info file .tssapinfo from project " + prj.getName(), e);
                }
            }
            if (ret == null) {
                ret = ProjectInfo.createEmptyInfoDocument();
            }
            domMap.put(prj, ret);
        }
        return ret;
    }

    private static boolean saveDocumentInfo(IProject project, Document doc) {
        lastSaveFailedReason = null;
        try {
            myResourceChangedHandler.setActive(false);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            mySerializer.write(doc, (OutputStream)bOut);
            IFile infoFile = ProjectInfo.getInfoFile(project);
            if (!infoFile.exists()) {
                infoFile.create((InputStream)new ByteArrayInputStream(bOut.toByteArray()), false, (IProgressMonitor)new NullProgressMonitor());
            } else if (ProjectInfo.isEditable(infoFile)) {
                infoFile.setContents((InputStream)new ByteArrayInputStream(bOut.toByteArray()), true, false, (IProgressMonitor)new NullProgressMonitor());
            } else {
                doc = null;
                lastSaveFailedReason = new SaveFailedReason(true, null);
            }
        }
        catch (Throwable e) {
            tracer.error("Error saving Project Info", e);
            lastSaveFailedReason = new SaveFailedReason(false, e);
            doc = null;
        }
        if (doc != null) {
            domMap.put(project, doc);
        } else {
            ProjectInfo.clearCache(project);
        }
        myResourceChangedHandler.setActive(true);
        return lastSaveFailedReason == null;
    }

    private static void clearCache(IProject project) {
        domMap.remove(project);
        propMap.remove(project);
    }

    private static boolean isEditable(IFile f) {
        if (f.isReadOnly()) {
            boolean shellCreated = false;
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (shell == null) {
                shell = new Shell();
                shellCreated = true;
            }
            ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{f}, (Object)shell);
            if (shellCreated) {
                shell.dispose();
            }
        }
        return !f.isReadOnly();
    }

    public static String getProperty(IProject project, String key) {
        return ProjectInfo.getInfoProperty(project).getProperty(key);
    }

    public static Enumeration propertyNames(IProject project) {
        return ProjectInfo.getInfoProperty(project).propertyNames();
    }

    public static boolean removeProperty(IProject project, String key) {
        if (project == null || key == null) {
            throw new IllegalArgumentException("All arguments must not be null");
        }
        PropertyInfo pi = ProjectInfo.getInfoProperty(project);
        String oldValue = pi.getProperty(key);
        if (oldValue == null) {
            return true;
        }
        pi.removeProperty(key);
        boolean ret = ProjectInfo.setInfoProperty(project, pi);
        if (ret) {
            ProjectInfo.firePropertyChanged(project, key, oldValue, null);
        }
        return ret;
    }

    public static boolean setProperty(IProject project, String key, String value) {
        if (project == null || key == null || value == null) {
            throw new IllegalArgumentException("All arguments must not be null");
        }
        PropertyInfo pi = ProjectInfo.getInfoProperty(project);
        String oldValue = pi.getProperty(key);
        if (value.equals(oldValue)) {
            return true;
        }
        pi.setProperty(key, value);
        boolean ret = ProjectInfo.setInfoProperty(project, pi);
        if (ret) {
            ProjectInfo.firePropertyChanged(project, key, oldValue, value);
        }
        return ret;
    }

    public static SaveFailedReason getLastSaveFailedReason() {
        return lastSaveFailedReason;
    }

    public static void addPropertyListener(IProjectInfoPropertyListener listener) {
        ProjectInfo.internalAddPropertyListener(listener, "");
    }

    public static void addPropertyListener(IProjectInfoPropertyListener listener, String key) {
        if (key == null || key.trim().length() == 0) {
            throw new IllegalArgumentException("key must be a String with length >0");
        }
        ProjectInfo.internalAddPropertyListener(listener, key);
    }

    private static void internalAddPropertyListener(IProjectInfoPropertyListener listener, String key) {
        if (listener == null) {
            throw new IllegalArgumentException("listener == null");
        }
        Map map = myPropertyListeners;
        synchronized (map) {
            ArrayList<IProjectInfoPropertyListener> keyListener = (ArrayList<IProjectInfoPropertyListener>)myPropertyListeners.get(key);
            if (keyListener == null) {
                keyListener = new ArrayList<IProjectInfoPropertyListener>();
                myPropertyListeners.put(key, keyListener);
            }
            if (keyListener.contains(listener)) {
                return;
            }
            keyListener.add(listener);
        }
    }

    public static void removePropertyListener(IProjectInfoPropertyListener listener) {
        if (listener == null) {
            return;
        }
        Map map = myPropertyListeners;
        synchronized (map) {
            Iterator iter = myPropertyListeners.keySet().iterator();
            while (iter.hasNext()) {
                List listeners = (List)myPropertyListeners.get(iter.next());
                if (!listeners.contains(listener)) continue;
                listeners.remove(listener);
            }
        }
    }

    private static void firePropertyChanged(IProject project, String key, String oldValue, String newValue) {
        List listenerList;
        Map map = myPropertyListeners;
        synchronized (map) {
            listenerList = ProjectInfo.getPropertyListeners(key);
        }
        Iterator iter = listenerList.iterator();
        while (iter.hasNext()) {
            ((IProjectInfoPropertyListener)iter.next()).propertyChanged(project, key, oldValue, newValue);
        }
    }

    private static List getPropertyListeners(String key) {
        ArrayList ret = new ArrayList();
        List listenerList = (List)myPropertyListeners.get("");
        if (listenerList != null) {
            ret.addAll(listenerList);
        }
        if ((listenerList = (List)myPropertyListeners.get(key)) != null) {
            ret.addAll(listenerList);
        }
        return ret;
    }

    private static Document parse(InputStream ins) throws SAXException, IOException {
        Document doc = null;
        doc = myBuilder.parse(ins);
        return doc;
    }

    private static Document newDocument() {
        Document doc = myBuilder.newDocument();
        return doc;
    }

    private static Element getElement(Document document, String infoId) {
        Element ret = null;
        NodeList nodelist = document.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < nodelist.getLength() && ret == null) {
            Node node = nodelist.item(i);
            if (node.getNodeType() == 1 && node.getNodeName().equals(infoId)) {
                ret = (Element)node;
            }
            ++i;
        }
        return ret;
    }

    private static void removeElement(Document doc, String infoId) {
        Element toRemove = ProjectInfo.getElement(doc, infoId);
        if (toRemove != null) {
            doc.getDocumentElement().removeChild(toRemove);
        }
    }

    private static Element addElement(Document doc, String infoId) {
        Element element = doc.createElement(infoId);
        doc.getDocumentElement().appendChild(element);
        return element;
    }

    private static IFile getInfoFile(IProject prj) {
        IFile ret = prj.getFile(INFO_FILENAME);
        return ret;
    }

    private static Document createEmptyInfoDocument() {
        Document ret = ProjectInfo.newDocument();
        Element mainTag = ret.createElement(INFO_MAINTAG);
        ret.appendChild(mainTag);
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        domMap = new HashMap();
        propMap = new HashMap();
        complexInfoImplMap = new HashMap();
        myPropertyListeners = new HashMap();
        try {
            try {
                dbf = new DocumentBuilderFactoryImpl();
            }
            catch (Throwable th) {
                tracer.warning("com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl is not availible", th);
            }
            mySerializer = new DOMSerializer();
            if (dbf == null) {
                dbf = DocumentBuilderFactory.newInstance();
            }
            complexInfoImplMap.put("Properties", new PropertyInfo(null));
            myBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            tracer.error("Failed to create DocumentBuilder", e);
        }
        myResourceChangedHandler = new MyResourceChangedHandler();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)myResourceChangedHandler);
    }

    public static class SaveFailedReason {
        private boolean isReadOnly;
        private Throwable exception;

        SaveFailedReason(boolean isReadOnly, Throwable exception) {
            this.isReadOnly = isReadOnly;
            this.exception = exception;
        }

        public boolean isReadOnly() {
            return this.isReadOnly;
        }

        public Throwable getException() {
            return this.exception;
        }

        public String getProjectRelativeSavePath() {
            return ProjectInfo.INFO_FILENAME;
        }
    }

    static class MyResourceChangedHandler
    implements IResourceDeltaVisitor,
    IResourceChangeListener {
        private boolean active = true;

        MyResourceChangedHandler() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (!this.isActive()) {
                return;
            }
            try {
                IResourceDelta delta = null;
                if (event.getType() == 1 && (delta = event.getDelta()) != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException e) {
                tracer.log(4, "Error in ResourceChangeListener", e);
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource res = delta.getResource();
            if (ProjectInfo.INFO_FILENAME.equals(res.getProjectRelativePath().toString())) {
                IProject affPrj = res.getProject();
                domMap.remove(affPrj);
                propMap.remove(affPrj);
            }
            return true;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }
}

