/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.performance;

import java.util.Vector;

public class PerformanceObject {
    private static final long DEFAULT_MINIMUM_MILLIS = 10L;
    private Vector timeStampsVector = new Vector();

    public PerformanceObject(String description) {
        this.addTimeStamp(description);
    }

    public void addTimeStamp(String description) {
        this.timeStampsVector.addElement(new TimeStamp(description));
    }

    public void summaryToStdOut(long minimumMillis) {
        if (this.moreThanMinimum(minimumMillis)) {
            String text = this.summaryAsString();
            System.out.println(text);
        }
    }

    public void summaryToStdOut() {
        this.summaryToStdOut(10L);
    }

    private boolean moreThanMinimum(long minimumMillis) {
        TimeStamp firstStamp = (TimeStamp)this.timeStampsVector.firstElement();
        TimeStamp lastStamp = (TimeStamp)this.timeStampsVector.lastElement();
        long startTimeMillis = firstStamp.getTime();
        long completeTimeMillis = lastStamp.getTime() - startTimeMillis;
        return completeTimeMillis > minimumMillis;
    }

    public String summaryAsString(long minimumMillis) {
        String ret = "";
        if (this.moreThanMinimum(minimumMillis)) {
            TimeStamp firstStamp = (TimeStamp)this.timeStampsVector.firstElement();
            TimeStamp lastStamp = (TimeStamp)this.timeStampsVector.lastElement();
            long startTimeMillis = firstStamp.getTime();
            long completeTimeMillis = lastStamp.getTime() - startTimeMillis;
            ret = "\n100% " + completeTimeMillis + "ms " + firstStamp.getDescription();
            TimeStamp[] stamps = this.timeStampsVector.toArray(new TimeStamp[0]);
            long previousTimeMillis = startTimeMillis;
            int i = 1;
            while (i < stamps.length) {
                TimeStamp stamp = stamps[i];
                long timeMillis = stamp.getTime();
                long diffToPreviousMillis = timeMillis - previousTimeMillis;
                long percentLong = completeTimeMillis == 0L ? 1L : 100L * diffToPreviousMillis / completeTimeMillis;
                int percent = (int)percentLong;
                ret = ret + "\n  " + percent + "% " + diffToPreviousMillis + "ms " + stamp.getDescription();
                previousTimeMillis = timeMillis;
                ++i;
            }
        }
        return ret;
    }

    public String summaryAsString() {
        return this.summaryAsString(10L);
    }

    private class TimeStamp {
        private String description = "";
        private long time;

        public TimeStamp(String description) {
            this.setDescription(description);
            this.setTime(System.currentTimeMillis());
        }

        private void setTime(long time) {
            this.time = time;
        }

        protected long getTime() {
            return this.time;
        }

        private void setDescription(String description) {
            this.description = description;
        }

        protected String getDescription() {
            return this.description;
        }
    }
}

