/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.jdt;

import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Shell;

public class JDTUtils {
    public static final String ALL_APIS = "All_APIs";
    private static final TracerI tracer = TracingManager.getTracer(class$com$tssap$util$jdt$JDTUtils == null ? (class$com$tssap$util$jdt$JDTUtils = JDTUtils.class$("com.tssap.util.jdt.JDTUtils")) : class$com$tssap$util$jdt$JDTUtils);
    static /* synthetic */ Class class$com$tssap$util$jdt$JDTUtils;

    public static IType chooseEnclosingType(IPackageFragmentRoot root, String[] jdkTypes, Shell shell, IRunnableContext container, int type, IJavaElement currentSelection) {
        return JDTUtils.chooseEnclosingType(new IPackageFragmentRoot[]{root}, jdkTypes, shell, container, type, currentSelection);
    }

    public static IType chooseEnclosingType(IPackageFragmentRoot[] root, String[] jdkTypes, Shell shell, IRunnableContext container, int type, IJavaElement currentSelection) {
        IType currSelection = null;
        IJavaSearchScope scope = JDTUtils.buildJavaSearchScope(root, jdkTypes);
        if (currentSelection instanceof IType) {
            currSelection = (IType)currentSelection;
        }
        TypeSelectionDialog dialog = new TypeSelectionDialog(shell, container, type, scope);
        dialog.setTitle("TypeSelectionDialog");
        dialog.setMessage("select type");
        if (currSelection != null) {
            dialog.setInitialSelections(new Object[]{currSelection});
            dialog.setFilter(currSelection.getElementName().substring(0, 1));
        }
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    private static IJavaSearchScope buildJavaSearchScope(IPackageFragmentRoot[] root, String[] jdkTypes) {
        IJavaProject project = null;
        ArrayList<IPackageFragmentRoot> pkgRoots = new ArrayList<IPackageFragmentRoot>();
        if (root != null) {
            if (root.length == 1 && root[0] != null) {
                project = root[0].getJavaProject();
                pkgRoots.add(root[0]);
            } else {
                pkgRoots.addAll(Arrays.asList(root));
            }
        }
        if (jdkTypes != null) {
            IJavaProject[] prjs = new IJavaProject[]{project};
            if (project == null) {
                prjs = JDTUtils.getAllJavaProjects();
            }
            try {
                int i = 0;
                while (prjs != null && i < prjs.length) {
                    pkgRoots.addAll(Arrays.asList(prjs[i].getAllPackageFragmentRoots()));
                    ++i;
                }
            }
            catch (JavaModelException e) {
                tracer.error("buildJavaSearchScope", "Not able to build SearchScope", e);
            }
        }
        IPackageFragmentRoot[] roots = new IPackageFragmentRoot[pkgRoots.size()];
        try {
            pkgRoots.toArray(roots);
        }
        catch (ArrayStoreException e) {
            tracer.error("buildJavaSearchScope", "Not able to build SearchScope", e);
        }
        return SearchEngine.createJavaSearchScope((IJavaElement[])roots);
    }

    public static IJavaProject[] getAllJavaProjects() {
        ArrayList<IJavaProject> javaPrjs = new ArrayList<IJavaProject>();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return null;
        }
        IProject[] prjs = workspace.getRoot().getProjects();
        int i = 0;
        while (i < prjs.length) {
            try {
                if (prjs[i].getNature("org.eclipse.jdt.core.javanature") != null) {
                    IJavaProject jPrj = JavaCore.create((IProject)prjs[i]);
                    javaPrjs.add(jPrj);
                }
            }
            catch (CoreException e) {
                tracer.log(4, "Unable to create IJavaProject", e);
            }
            ++i;
        }
        return javaPrjs.toArray(new IJavaProject[javaPrjs.size()]);
    }

    public static IPackageFragmentRoot[] getSrcPackageFragmentRoots(IJavaProject project) {
        IClasspathEntry[] entry;
        IPackageFragmentRoot[] srcRoots = null;
        ArrayList<IPackageFragmentRoot> allRoots = new ArrayList<IPackageFragmentRoot>();
        try {
            entry = project.getRawClasspath();
        }
        catch (JavaModelException e) {
            return null;
        }
        int i = 0;
        while (i < entry.length) {
            if (entry[i].getEntryKind() == 3) {
                allRoots.addAll(Arrays.asList(project.getPackageFragmentRoots(entry[i])));
            }
            ++i;
        }
        srcRoots = new IPackageFragmentRoot[allRoots.size()];
        allRoots.toArray(srcRoots);
        return srcRoots;
    }

    public static boolean isJDKPackageFragmentRoot(IPackageFragmentRoot root) {
        return root.getElementName().indexOf("jdk") > -1 || root.getElementName().endsWith("rt.jar");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

