/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.file;

import java.io.File;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter {
    private Vector extensionVector = new Vector();
    private String description = "";

    public ExtensionFileFilter() {
    }

    public ExtensionFileFilter(String description) {
        this.setDescription(description);
    }

    public ExtensionFileFilter(String description, String extension) {
        this(description);
        this.addExtension(extension);
    }

    public ExtensionFileFilter(String description, String[] extensions) {
        this(description);
        if (extensions != null) {
            int i = 0;
            while (i < extensions.length) {
                this.addExtension(extensions[i]);
                ++i;
            }
        }
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String name = f.getName();
        boolean ret = false;
        int i = 0;
        while (i < this.extensionVector.size() && !ret) {
            String ext = (String)this.extensionVector.get(i);
            if (name.endsWith("." + ext)) {
                ret = true;
            }
            ++i;
        }
        return ret;
    }

    public void addExtension(String extension) {
        if (!this.extensionVector.contains(extension)) {
            this.extensionVector.add(extension);
        }
    }

    public void removeExtension(String extension) {
        if (this.extensionVector.contains(extension)) {
            this.extensionVector.remove(extension);
        }
    }

    public boolean containsExtension(String extension) {
        return this.extensionVector.contains(extension);
    }

    public String[] getExtensions() {
        String[] ret = new String[this.extensionVector.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (String)this.extensionVector.get(i);
            ++i;
        }
        return ret;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }
}

