/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.core;

import java.io.PrintStream;
import java.io.PrintWriter;

public class NestedException
extends Exception {
    Throwable innerException;
    private static final String NEX_SEPARATOR = "   ------------- Nested exception ------------------- ";

    public NestedException() {
    }

    public NestedException(String msg) {
        super(msg);
    }

    public NestedException(Throwable cause) {
        super(cause.getMessage());
        this.innerException = cause;
    }

    public NestedException(String msg, Throwable cause) {
        super(msg);
        this.innerException = cause;
    }

    public String getMessage() {
        if (this.innerException != null) {
            return this.innerException.getMessage();
        }
        return super.getMessage();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream ps) {
        super.printStackTrace(ps);
        PrintStream printStream = ps;
        synchronized (printStream) {
            if (this.innerException != null) {
                ps.println(NEX_SEPARATOR);
                this.innerException.printStackTrace(ps);
            }
        }
    }

    public void printStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            if (this.innerException != null) {
                pw.println(NEX_SEPARATOR);
                this.innerException.printStackTrace(pw);
            }
        }
    }

    public Throwable getInnerException() {
        return this.innerException;
    }
}

