/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.action.predefined;

import com.tssap.util.UtilPlugin;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.action.ISingleAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class OpenInEditorAction
implements ISingleAction {
    static /* synthetic */ Class class$com$tssap$util$action$predefined$OpenInEditorAction;

    public abstract boolean isAvailable(Object var1);

    public abstract boolean isEnabled(Object var1);

    public abstract IFile getFile(Object var1);

    public abstract SelectionPosition getSelectionPosition(Object var1);

    public void run(Object object) {
        this.openInEditor(this.getFile(object));
    }

    public ICategory getCategory() {
        return Category.OPEN;
    }

    private void openInEditor(IFile iFile) {
        IEditorPart editorPart = OpenInEditorAction.openInEditor(iFile, true);
        if (this.getSelectionPosition(iFile) != null) {
            this.revealInEditor(editorPart, this.getSelectionPosition(iFile));
        }
    }

    public static IEditorPart openInEditor(IFile file, boolean forceOpening) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (file == null) {
            return null;
        }
        if (page != null) {
            try {
                if (forceOpening || OpenInEditorAction.isEditorOpened(page, file)) {
                    IEditorPart existsPart = page.findEditor((IEditorInput)new FileEditorInput(file));
                    if (existsPart != null) {
                        page.bringToTop((IWorkbenchPart)existsPart);
                        return existsPart;
                    }
                    return page.openEditor(file);
                }
            }
            catch (Exception e) {
                UtilPlugin.getTracer().error(class$com$tssap$util$action$predefined$OpenInEditorAction == null ? (class$com$tssap$util$action$predefined$OpenInEditorAction = OpenInEditorAction.class$("com.tssap.util.action.predefined.OpenInEditorAction")) : class$com$tssap$util$action$predefined$OpenInEditorAction, "openInEditor(IFile file, boolean forceOpening)", "Error openeing file", (Throwable)e);
            }
        }
        return null;
    }

    public static boolean isEditorOpened(IWorkbenchPage page, IFile file) {
        return page.isEditorAreaVisible() && page.findEditor((IEditorInput)new FileEditorInput(file)) != null;
    }

    private void revealInEditor(IEditorPart editorPart, SelectionPosition position) {
        if (!(editorPart instanceof ITextEditor)) {
            return;
        }
        int length = position.getEndPos() - position.getStartPos() + 1;
        ((ITextEditor)editorPart).selectAndReveal(position.getStartPos(), length);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class SelectionPosition {
        int startPos;
        int endPos;

        public SelectionPosition(int startPos, int endPos) {
            this.startPos = startPos;
            this.endPos = endPos;
        }

        public int getEndPos() {
            return this.endPos;
        }

        public int getStartPos() {
            return this.startPos;
        }
    }
}

