/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.action.path;

import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.action.path.DefaultPath;
import com.tssap.util.action.path.DefaultPathElement;
import com.tssap.util.action.path.IPath;
import com.tssap.util.action.path.IPathElement;
import com.tssap.util.action.path.IPathProvider;
import com.tssap.util.ui.IContext;
import com.tssap.util.ui.action.IDisplayableCategory;
import com.tssap.util.ui.action.IExtendedDisplayableCategory;
import com.tssap.util.ui.action.path.DefaultDisplayablePathElement;
import com.tssap.util.ui.action.path.IDisplayablePathElement;
import java.util.Arrays;
import java.util.Vector;

public class DefaultPathProvider
implements IPathProvider {
    private static final ICategory[] ECLIPSE_CATEGORIES = new ICategory[]{Category.NEW, Category.OPEN, Category.NAVIGATE, Category.EDIT, Category.CUT, Category.COPY, Category.PASTE, Category.DELETE, Category.OTHERS, Category.PROPERTIES};

    private IPath getPath(ICategory category) {
        DefaultPath ret;
        Vector pathElementVector = new Vector();
        IPathElement[] pathElementArray = new IPathElement[]{};
        DefaultPathProvider.addPathElementFromCategory(category, pathElementVector);
        ICategory cat = category;
        while (cat.getParent() != null) {
            cat = cat.getParent();
            DefaultPathProvider.addPathElementFromCategory(cat, pathElementVector);
        }
        if (pathElementVector.size() > 0) {
            pathElementArray = pathElementVector.toArray(pathElementArray);
            ret = new DefaultPath(pathElementArray);
        } else {
            ret = new DefaultPath(new IPathElement[0]);
        }
        return ret;
    }

    public IPath getPath(ICategory category, IContext context) {
        IPath ret = this.getPath(category);
        return ret;
    }

    protected static void addPathElementFromCategory(ICategory category, Vector pathElementVector) {
        if (category instanceof IDisplayableCategory) {
            IDisplayableCategory iDisplayableCategory = (IDisplayableCategory)category;
            IDisplayablePathElement pathElem = DefaultPathProvider.createDisplayablePathElement(iDisplayableCategory);
            pathElementVector.add(0, pathElem);
        } else {
            pathElementVector.add(0, new DefaultPathElement(category.getDescription()));
        }
    }

    protected static IDisplayablePathElement createDisplayablePathElement(IDisplayableCategory displayableCategory) {
        DefaultDisplayablePathElement pathElem = displayableCategory instanceof IExtendedDisplayableCategory ? new DefaultDisplayablePathElement(displayableCategory.getDescription(), ((IExtendedDisplayableCategory)displayableCategory).isSubCategory(), displayableCategory.getName(), displayableCategory.getInfo(), displayableCategory.getImage(), DefaultPathProvider.getOrderInPredefinedEclipseCategories(displayableCategory)) : new DefaultDisplayablePathElement(displayableCategory.getDescription(), displayableCategory.getName(), displayableCategory.getInfo(), displayableCategory.getImage(), DefaultPathProvider.getOrderInPredefinedEclipseCategories(displayableCategory));
        return pathElem;
    }

    protected static int getOrderInPredefinedEclipseCategories(ICategory category) {
        int ret = -1;
        ret = Arrays.asList(ECLIPSE_CATEGORIES).indexOf(category);
        return ret;
    }
}

