/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.action.path;

import com.tssap.util.action.path.IMutablePathElement;
import com.tssap.util.action.path.IPathElement;

public class DefaultPathElement
implements IMutablePathElement {
    private int order = 0;
    private String text;
    private boolean subElement = true;

    public DefaultPathElement(String text) {
        this.setText(text);
    }

    public DefaultPathElement(String text, boolean subElement) {
        this(text);
        this.setSubElement(subElement);
    }

    public DefaultPathElement(String text, int order) {
        this(text);
        this.setOrder(order);
    }

    public DefaultPathElement(String text, int order, boolean subElement) {
        this(text);
        this.setOrder(order);
        this.setSubElement(subElement);
    }

    public boolean isSubElement() {
        return this.subElement;
    }

    public String getText() {
        return this.text;
    }

    public void setSubElement(boolean subElement) {
        this.subElement = subElement;
    }

    private void setText(String text) {
        this.text = text;
    }

    public int hashCode() {
        int ret = 0;
        if (this.text != null) {
            ret = this.text.hashCode();
        }
        ret += this.order;
        return ret += 31 * (this.subElement ? 1 : 0);
    }

    public boolean equals(Object obj) {
        boolean ret = false;
        if (obj instanceof IPathElement) {
            IPathElement otherPathElement = (IPathElement)obj;
            if (this.isSubElement() == otherPathElement.isSubElement() && this.getOrder() == otherPathElement.getOrder()) {
                if (this.getText() == null && otherPathElement == null) {
                    ret = true;
                } else if (this.getText() != null && otherPathElement.getText() != null && this.getText().equals(otherPathElement.getText())) {
                    ret = true;
                }
            }
        }
        return ret;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

