/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.action.path;

import com.tssap.util.action.ICategory;
import com.tssap.util.action.path.DefaultPath;
import com.tssap.util.action.path.DefaultPathElement;
import com.tssap.util.action.path.DefaultPathProvider;
import com.tssap.util.action.path.IPath;
import com.tssap.util.action.path.IPathElement;
import com.tssap.util.ui.IContext;
import com.tssap.util.ui.action.IDisplayableCategory;
import com.tssap.util.ui.action.IExtendedDisplayableCategory;
import com.tssap.util.ui.action.path.DefaultDisplayablePathElement;
import com.tssap.util.ui.action.path.IDisplayablePathElement;
import java.util.Vector;

public class ContextDependentPathProvider
extends DefaultPathProvider {
    private boolean additionalInfoInPath = false;

    public ContextDependentPathProvider() {
    }

    public ContextDependentPathProvider(boolean additionalInfoInPath) {
        this();
        this.setAdditionalInfoInPath(additionalInfoInPath);
    }

    public IPath getPath(ICategory category, IContext context) {
        DefaultPath ret;
        Vector pathElementVector = new Vector();
        IPathElement[] pathElementArray = new IPathElement[]{};
        this.addPathElementFromCategory(category, context, pathElementVector, this.isAdditionalInfoInPath());
        ICategory cat = category;
        while (cat.getParent() != null) {
            cat = cat.getParent();
            this.addPathElementFromCategory(cat, context, pathElementVector, this.isAdditionalInfoInPath());
        }
        if (pathElementVector.size() > 0) {
            pathElementArray = pathElementVector.toArray(pathElementArray);
            ret = new DefaultPath(pathElementArray);
        } else {
            ret = new DefaultPath(new IPathElement[0]);
        }
        return ret;
    }

    protected void addPathElementFromCategory(ICategory category, IContext context, Vector pathElementVector, boolean additionalInfoInPath) {
        String nameAddition = "";
        if (additionalInfoInPath) {
            Object[] contextObjects = context.getContextObjects();
            int contextObjectCount = contextObjects.length;
            nameAddition = " " + contextObjectCount + " element" + (contextObjectCount != 1 ? "s" : "");
        }
        if (category instanceof IDisplayableCategory) {
            IDisplayableCategory iDisplayableCategory = (IDisplayableCategory)category;
            IDisplayablePathElement pathElem = ContextDependentPathProvider.createDisplayablePathElement(iDisplayableCategory, nameAddition);
            pathElementVector.add(0, pathElem);
        } else {
            pathElementVector.add(0, new DefaultPathElement(category.getDescription()));
        }
    }

    protected static IDisplayablePathElement createDisplayablePathElement(IDisplayableCategory displayableCategory, String nameAddition) {
        DefaultDisplayablePathElement pathElem = displayableCategory instanceof IExtendedDisplayableCategory ? new DefaultDisplayablePathElement(displayableCategory.getDescription(), ((IExtendedDisplayableCategory)displayableCategory).isSubCategory(), displayableCategory.getName() + nameAddition, displayableCategory.getInfo(), displayableCategory.getImage(), DefaultPathProvider.getOrderInPredefinedEclipseCategories(displayableCategory)) : new DefaultDisplayablePathElement(displayableCategory.getDescription(), displayableCategory.getName() + nameAddition, displayableCategory.getInfo(), displayableCategory.getImage(), DefaultPathProvider.getOrderInPredefinedEclipseCategories(displayableCategory));
        return pathElem;
    }

    public boolean isAdditionalInfoInPath() {
        return this.additionalInfoInPath;
    }

    public void setAdditionalInfoInPath(boolean additionalInfoInPath) {
        this.additionalInfoInPath = additionalInfoInPath;
    }
}

