/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.action.eclipse;

import com.tssap.util.action.ActionProviderManager;
import com.tssap.util.action.ICategory;
import com.tssap.util.action.IFallbackAction;
import com.tssap.util.ui.IContext;
import com.tssap.util.ui.IContextProvider;
import com.tssap.util.ui.menu.MenuFactory;
import com.tssap.util.ui.menu.context.DynamicContextMenu;
import org.eclipse.jface.action.Action;

public abstract class DynamicAction
extends Action
implements IFallbackAction {
    private DynamicContextMenu contextMenu;
    private IContextProvider contextProvider;

    public DynamicAction(DynamicContextMenu cm, IContextProvider contextProvider) {
        this.setContextMenu(cm);
        this.setContextProvider(contextProvider);
    }

    public boolean isEnabled() {
        boolean ret = super.isEnabled();
        if (ret) {
            ret = this.getContextMenu() != null && this.getContext() != null ? ActionProviderManager.checkIfActionsEnabledForContext(this.getCategory(), this.getContext(), this.getContextMenu().getActionFilter()) : false;
        }
        return ret;
    }

    public void run() {
        super.run();
        if (this.isEnabled() && this.getContextMenu() != null && this.getContext() != null) {
            MenuFactory.performActionsForContext(this.getCategory(), this.getContext(), this.getContextMenu().getActionFilter());
        }
    }

    public DynamicContextMenu getContextMenu() {
        return this.contextMenu;
    }

    protected void setContextMenu(DynamicContextMenu contextMenu) {
        this.contextMenu = contextMenu;
    }

    protected IContext getContext() {
        IContext ret = null;
        if (this.getContextProvider() != null) {
            ret = this.getContextProvider().getContext();
        }
        return ret;
    }

    public IContextProvider getContextProvider() {
        return this.contextProvider;
    }

    protected void setContextProvider(IContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    abstract ICategory getCategory();
}

