/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.action;

import com.tssap.util.action.IActionContext;
import com.tssap.util.action.IActionProvider;
import com.tssap.util.action.ICategory;
import com.tssap.util.action.IFallbackAction;
import com.tssap.util.action.IGenericAction;
import com.tssap.util.action.IGenericActionContainer;
import com.tssap.util.action.IMultiAction;
import com.tssap.util.action.ISingleAction;
import com.tssap.util.ui.action.ConvenientActionContainer;

public abstract class ObjectActionProvider
implements IActionProvider {
    public abstract ISingleAction[] getSingleActions(Object var1, Object[] var2);

    public abstract IMultiAction[] getMultiActions(Object[] var1);

    public IGenericActionContainer getSingleActions(IActionContext actionContext) {
        return this.getActions(actionContext, 0);
    }

    public IGenericActionContainer getMultiActions(IActionContext actionContext) {
        return this.getActions(actionContext, 1);
    }

    private IGenericActionContainer getActions(IActionContext actionContext, int actionType) {
        ConvenientActionContainer ret;
        block3: {
            block2: {
                ret = new ConvenientActionContainer();
                if (actionType != 0) break block2;
                ISingleAction[] singleActions = this.getSingleActions(actionContext.getActionObject(), actionContext.getContextObjects());
                int i = 0;
                while (i < singleActions.length) {
                    ret.addAction(new GenericObjectActionWrapper(singleActions[i]));
                    ++i;
                }
                break block3;
            }
            if (actionType != 1) break block3;
            IMultiAction[] multiActions = this.getMultiActions(actionContext.getContextObjects());
            int i = 0;
            while (i < multiActions.length) {
                ret.addAction(new GenericObjectActionWrapper(multiActions[i]));
                ++i;
            }
        }
        return ret;
    }

    public class GenericObjectActionWrapper
    implements IGenericAction {
        public static final int SINGLE_ACTION = 0;
        public static final int MULTI_ACTION = 1;
        private int type;
        private ISingleAction mySingleAction = null;
        private IMultiAction myMultiAction = null;

        public GenericObjectActionWrapper(ISingleAction singleAction) {
            this.type = 0;
            this.mySingleAction = singleAction;
        }

        public GenericObjectActionWrapper(IMultiAction multiAction) {
            this.type = 1;
            this.myMultiAction = multiAction;
        }

        public boolean isAvailable(IActionContext actionContext) {
            return this.isAvailable(actionContext.getActionObject(), actionContext.getContextObjects());
        }

        private boolean isAvailable(Object element, Object[] context) {
            boolean ret = false;
            switch (this.type) {
                case 0: {
                    ret = this.mySingleAction.isAvailable(element);
                    break;
                }
                case 1: {
                    ret = this.myMultiAction.isAvailable(context);
                }
            }
            return ret;
        }

        public boolean isEnabled(IActionContext actionContext) {
            return this.isEnabled(actionContext.getActionObject(), actionContext.getContextObjects());
        }

        private boolean isEnabled(Object element, Object[] context) {
            boolean ret = false;
            switch (this.type) {
                case 0: {
                    ret = this.mySingleAction.isEnabled(element);
                    break;
                }
                case 1: {
                    ret = this.myMultiAction.isEnabled(context);
                }
            }
            return ret;
        }

        public void run(IActionContext actionContext) {
            switch (this.type) {
                case 0: {
                    this.mySingleAction.run(actionContext.getActionObject());
                    break;
                }
                case 1: {
                    this.myMultiAction.run(actionContext.getContextObjects());
                }
            }
        }

        public ICategory getCategory() {
            ICategory ret = null;
            switch (this.type) {
                case 0: {
                    ret = this.mySingleAction.getCategory();
                    break;
                }
                case 1: {
                    ret = this.myMultiAction.getCategory();
                }
            }
            return ret;
        }

        public boolean isFallbackAction() {
            boolean ret = false;
            if (this.mySingleAction != null && this.mySingleAction instanceof IFallbackAction) {
                ret = true;
            } else if (this.myMultiAction != null && this.myMultiAction instanceof IFallbackAction) {
                ret = true;
            }
            return ret;
        }
    }
}

