/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.action;

import com.tssap.util.UtilPlugin;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.action.IDisplayableCategory;
import com.tssap.util.ui.action.IExtendedDisplayableCategory;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.image.SapImage;
import org.eclipse.swt.graphics.Image;

public class Category
implements ICategory {
    public static final ICategory DEFAULT = new DisplayableCategory(null, "Default", "Default", "Root Category", null);
    public static final ICategory NEW = Category.createDisplayableCategory(DEFAULT, "New", "New", "New", null);
    public static final ICategory OPEN = Category.createDisplayableCategory(DEFAULT, "Open", "Open", "Open", null);
    public static final ICategory NAVIGATE = Category.createDisplayableCategory(DEFAULT, "Navigate", "Navigate", "Do Navigation", null);
    public static final ICategory EDIT = Category.createDisplayableCategory(DEFAULT, "Edit", "Edit", "Edit", SapIdeUtilImages.getSapImage(SapImage.ICON_TOOLS), false);
    public static final ICategory DELETE = Category.createDisplayableCategory(EDIT, "Delete", "Delete", "Delete", null);
    public static final ICategory OTHERS = Category.createDisplayableCategory(DEFAULT, "Others", "Others", "Others", null, false);
    public static final ICategory PROPERTIES = Category.createDisplayableCategory(DEFAULT, "Properties", "Properties", "Show Properties", SapIdeUtilImages.getSapImage(SapImage.ICON_TERMINOLOGY));
    public static final ICategory CUT = Category.createDisplayableCategory(EDIT, "Cut", "Cut", "Cut Selection", SapIdeUtilImages.getSapImage(SapImage.ICON_SYSTEM_CUT));
    public static final ICategory COPY = Category.createDisplayableCategory(EDIT, "Copy", "Copy", "Copy Selection", SapIdeUtilImages.getSapImage(SapImage.ICON_SYSTEM_COPY));
    public static final ICategory PASTE = Category.createDisplayableCategory(EDIT, "Paste", "Paste", "Paste", SapIdeUtilImages.getSapImage(SapImage.ICON_SYSTEM_PASTE));
    public static final ICategory REFRESH = Category.createDisplayableCategory(DEFAULT, "Refresh", "Refresh", "Refresh", SapIdeUtilImages.getImageDescriptorFromIconsDirectory(UtilPlugin.getPluginId(), "refresh.gif").createImage());
    private String description;
    private ICategory parent = null;

    private Category(ICategory parent, String description) {
        this(description);
        this.parent = parent;
    }

    private Category(String description) {
        this.description = description;
    }

    public static ICategory createCategory(ICategory parent, String description) {
        if (parent == null) {
            parent = OTHERS;
        }
        return new Category(parent, description);
    }

    public static IDisplayableCategory createDisplayableCategory(ICategory parent, String description, String displayName, String displayInfo, Image displayImage) {
        if (parent == null) {
            parent = OTHERS;
        }
        DisplayableCategory ret = new DisplayableCategory(parent, description, displayName, displayInfo, displayImage);
        return ret;
    }

    public static IDisplayableCategory createDisplayableCategory(ICategory parent, String description, String displayName, String displayInfo, Image displayImage, boolean isSubCategory) {
        IDisplayableCategory ret = Category.createDisplayableCategory(parent, description, displayName, displayInfo, displayImage);
        if (ret instanceof IExtendedDisplayableCategory) {
            IExtendedDisplayableCategory extRet = (IExtendedDisplayableCategory)ret;
            extRet.setSubCategory(isSubCategory);
        }
        return ret;
    }

    public static IDisplayableCategory createDisplayableCategory(ICategory parent, String description, String displayName, String displayInfo, Image displayImage, boolean isSubCategory, int preferredPosition) {
        IDisplayableCategory ret = Category.createDisplayableCategory(parent, description, displayName, displayInfo, displayImage);
        if (ret instanceof IExtendedDisplayableCategory) {
            IExtendedDisplayableCategory extRet = (IExtendedDisplayableCategory)ret;
            extRet.setSubCategory(isSubCategory);
            extRet.setPreferredPosition(preferredPosition);
        }
        return ret;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = "";
        }
        return this.description;
    }

    public ICategory getParent() {
        return this.parent;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    private void setParent(ICategory parent) {
        this.parent = parent;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        boolean ret = false;
        if (obj instanceof Category) {
            Category other = (Category)obj;
            String description = this.getDescription();
            if ((description == null || description != null && description.equals(other.getDescription())) && (this.getParent() == null || this.getParent() != null && this.getParent().equals(other.getParent()))) {
                ret = true;
            }
        }
        return ret;
    }

    public int hashCode() {
        int ret = this.getDescription().hashCode();
        if (this.getParent() != null) {
            ret += this.getParent().hashCode();
        }
        return ret;
    }

    public String toString() {
        String ret = this.getDescription();
        if (this.getParent() != null) {
            ret = this.getParent() + "." + ret;
        }
        if (this.equals(DEFAULT)) {
            ret = this.getClass().getName() + ": " + ret;
        }
        return ret;
    }

    static class DisplayableCategory
    extends Category
    implements IExtendedDisplayableCategory {
        private String name;
        private String info;
        private Image image;
        private boolean subCategory = true;
        private int preferredPosition = -1;

        private DisplayableCategory(ICategory parent, String description, String diplayName, String displayInfo, Image displayImage) {
            super(parent, description);
            this.name = diplayName;
            this.info = displayInfo;
            this.image = displayImage;
        }

        public Image getImage() {
            return this.image;
        }

        public String getInfo() {
            return this.info;
        }

        public String getName() {
            return this.name;
        }

        public boolean isSubCategory() {
            return this.subCategory;
        }

        public void setSubCategory(boolean subCategory) {
            this.subCategory = subCategory;
        }

        public int getPreferredPosition() {
            return this.preferredPosition;
        }

        public void setPreferredPosition(int preferredPosition) {
            this.preferredPosition = preferredPosition;
        }
    }
}

