/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util.action;

import com.tssap.util.UtilPlugin;
import com.tssap.util.action.ActionContext;
import com.tssap.util.action.IActionContext;
import com.tssap.util.action.IActionFilter;
import com.tssap.util.action.IActionProvider;
import com.tssap.util.action.IActionProviderManager;
import com.tssap.util.action.ICategory;
import com.tssap.util.action.IFallbackAction;
import com.tssap.util.action.IGenericAction;
import com.tssap.util.action.IGenericActionContainer;
import com.tssap.util.action.ObjectActionProvider;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.IContext;
import com.tssap.util.ui.action.ConvenientActionContainer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;

public class ActionProviderManager
implements IActionProviderManager {
    private static final TracerI T = TracingManager.getTracer(class$com$tssap$util$action$ActionProviderManager == null ? (class$com$tssap$util$action$ActionProviderManager = ActionProviderManager.class$("com.tssap.util.action.ActionProviderManager")) : class$com$tssap$util$action$ActionProviderManager);
    private static final String ACTION_PROVIDER_EXTENSION_POINT = "ActionProvider";
    private static final String EXTENSION_CLASS_NAME = "class";
    private static IActionProviderManager singleton = null;
    private Vector actionProviderVector;
    static /* synthetic */ Class class$com$tssap$util$action$ActionProviderManager;
    static /* synthetic */ Class class$com$tssap$util$action$IActionProvider;

    private ActionProviderManager() {
        this.addExtensionpointProviders();
    }

    public IGenericActionContainer getSingleActions(IActionContext actionContext) {
        long enter = 0L;
        if (T.path()) {
            T.path("IGenericActionContainer getSingleActions(IActionContext actionContext)", "enter");
            enter = System.currentTimeMillis();
        }
        if (T.debug()) {
            T.debug("IGenericActionContainer getSingleActions(IActionContext actionContext)", "actionContext = " + this.dumpActionContext(actionContext) + ")");
        }
        ConvenientActionContainer ret = new ConvenientActionContainer();
        Iterator iter = ((AbstractList)this.getActionProviderVector()).iterator();
        while (iter.hasNext()) {
            IActionProvider actionProvider = (IActionProvider)iter.next();
            IGenericActionContainer singleActions = actionProvider.getSingleActions(actionContext);
            if (singleActions == null) continue;
            IGenericAction[] array = singleActions.getActions();
            int i = 0;
            while (i < array.length) {
                ret.addAction(array[i]);
                ++i;
            }
        }
        if (T.debug()) {
            String msg = this.buildMessage(ret);
            T.debug("IGenericActionContainer getSingleActions(IActionContext actionContext)", msg);
        }
        if (T.path()) {
            T.path("IGenericActionContainer getSingleActions(IActionContext actionContext)", "leave(whole method took " + (System.currentTimeMillis() - enter) + " ms)");
        }
        return ret;
    }

    private String dumpActionContext(IActionContext actionContext) {
        String ret = actionContext.toString();
        ret = ret + " (actionObject = " + actionContext.getActionObject() + ", contextObjects = Object[" + actionContext.getContextObjectCount() + "])";
        return ret;
    }

    private String buildMessage(IGenericActionContainer actionContainer) {
        String msg = actionContainer.toString();
        IGenericAction[] actions = actionContainer.getActions();
        int i = 0;
        while (i < actions.length) {
            msg = msg + "\n  " + actions[i].toString();
            ++i;
        }
        return msg;
    }

    public IGenericActionContainer getMultiActions(IActionContext actionContext) {
        ConvenientActionContainer ret = new ConvenientActionContainer();
        Iterator iter = ((AbstractList)this.getActionProviderVector()).iterator();
        while (iter.hasNext()) {
            IActionProvider actionProvider = (IActionProvider)iter.next();
            IGenericActionContainer multiActions = actionProvider.getMultiActions(actionContext);
            if (multiActions == null) continue;
            IGenericAction[] array = multiActions.getActions();
            int i = 0;
            while (i < array.length) {
                ret.addAction(array[i]);
                ++i;
            }
        }
        if (T.debug()) {
            String msg = this.buildMessage(ret);
            T.debug("IGenericActionContainer getMultiActions(IActionContext actionContext)", msg);
        }
        return ret;
    }

    public static final IActionProviderManager getInstance() {
        if (singleton == null) {
            singleton = new ActionProviderManager();
        }
        return singleton;
    }

    private void addExtensionpointProviders() {
        ArrayList<IActionProvider> extensions = new ArrayList<IActionProvider>();
        Collection ext = this.getExtensions();
        Iterator iterator = ext.iterator();
        while (iterator.hasNext()) {
            Object nextEl = iterator.next();
            if (!(nextEl instanceof IConfigurationElement)) continue;
            IConfigurationElement confEl = (IConfigurationElement)nextEl;
            String className = confEl.getAttribute(EXTENSION_CLASS_NAME);
            try {
                IExtension declExt = confEl.getDeclaringExtension();
                ClassLoader loader = declExt.getDeclaringPluginDescriptor().getPluginClassLoader();
                Object classInst = loader.loadClass(className).newInstance();
                if (classInst instanceof IActionProvider) {
                    if (classInst instanceof ObjectActionProvider) {
                        extensions.add((ObjectActionProvider)classInst);
                        if (!T.info()) continue;
                        T.info("addExtensionpointProviders()", "found ObjectActionProvider: " + classInst.getClass().getName());
                        continue;
                    }
                    extensions.add((IActionProvider)classInst);
                    if (!T.info()) continue;
                    T.info("addExtensionpointProviders()", "found IActionProvider: " + classInst.getClass().getName());
                    continue;
                }
                if (!T.error()) continue;
                T.error("void addExtensionpointProviders()", "ActionProvider Extensionpoint user must implement " + (class$com$tssap$util$action$IActionProvider == null ? ActionProviderManager.class$("com.tssap.util.action.IActionProvider") : class$com$tssap$util$action$IActionProvider).getName() + ". Found class " + classInst.getClass().getName());
            }
            catch (Exception e) {
                T.error("void addExtensionpointProviders()", "Could not create dynamic Action Provider.", e);
            }
        }
        int i = 0;
        while (i < extensions.size()) {
            this.addActionProvider((IActionProvider)extensions.get(i));
            ++i;
        }
    }

    private Collection getExtensions() {
        ArrayList<IConfigurationElement> ext = new ArrayList<IConfigurationElement>();
        IExtensionPoint extensionPoint = UtilPlugin.getInstance().getDescriptor().getExtensionPoint(ACTION_PROVIDER_EXTENSION_POINT);
        if (extensionPoint == null) {
            return ext;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configurationElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configurationElements.length) {
                if (configurationElements[j].getAttribute(EXTENSION_CLASS_NAME) != null) {
                    ext.add(configurationElements[j]);
                }
                ++j;
            }
            ++i;
        }
        return ext;
    }

    public Vector getActionProviderVector() {
        if (this.actionProviderVector == null) {
            this.actionProviderVector = new Vector();
        }
        return this.actionProviderVector;
    }

    public void addActionProvider(IActionProvider actionProvider) {
        this.getActionProviderVector().add(actionProvider);
    }

    public void removeActionProvider(IActionProvider actionProvider) {
        this.getActionProviderVector().remove(actionProvider);
    }

    public IGenericActionContainer getAvailableActions(IActionContext actionContext, ICategory category) {
        IGenericAction[] actions = this.getActions(actionContext, category).getActions();
        ConvenientActionContainer ret = new ConvenientActionContainer();
        int i = 0;
        while (i < actions.length) {
            IGenericAction iGenericAction = actions[i];
            if (iGenericAction.isAvailable(actionContext)) {
                ret.addAction(iGenericAction);
            }
            ++i;
        }
        return ret;
    }

    public IGenericActionContainer getActions(IActionContext actionContext, ICategory category) {
        IGenericAction[] actions = ActionProviderManager.getInstance().getActions(actionContext).getActions(category);
        ConvenientActionContainer ret = new ConvenientActionContainer();
        int i = 0;
        while (i < actions.length) {
            IGenericAction iGenericAction = actions[i];
            ret.addAction(iGenericAction);
            ++i;
        }
        return ret;
    }

    public IGenericActionContainer getActions(IActionContext actionContext) {
        ConvenientActionContainer ret = new ConvenientActionContainer();
        ret.addActions(this.getSingleActions(actionContext));
        ret.addActions(this.getMultiActions(actionContext));
        return ret;
    }

    private static IGenericAction[] sortActions(IGenericAction[] actions) {
        IGenericAction[] ret = actions;
        Vector<IGenericAction> fallbackActions = new Vector<IGenericAction>();
        Vector<IGenericAction> otherActions = new Vector<IGenericAction>();
        int i = 0;
        while (i < actions.length) {
            IGenericAction action = actions[i];
            if (ActionProviderManager.checkIfFallbackAction(action)) {
                fallbackActions.add(action);
            } else {
                otherActions.add(action);
            }
            ++i;
        }
        otherActions.addAll(fallbackActions);
        ret = otherActions.toArray(ret);
        return ret;
    }

    public static boolean checkIfActionsEnabledForContext(ICategory category, IContext context, IActionFilter filter) {
        boolean ret = true;
        IActionContext[] actionContexts = ActionContext.createActionContexts(context);
        int i = 0;
        while (ret && i < actionContexts.length) {
            IActionContext actionContext = actionContexts[i];
            ret = ActionProviderManager.checkIfActionsEnabledForActionContext(category, actionContext, filter);
            ++i;
        }
        return ret;
    }

    public static boolean checkIfActionsEnabledForActionContext(ICategory category, IActionContext actionContext, IActionFilter filter) {
        boolean ret = true;
        IGenericAction[] actions = ActionProviderManager.getInstance().getAvailableActions(actionContext, category).getActions();
        int i = 0;
        while (ret && i < actions.length) {
            IGenericAction iGenericAction = actions[i];
            if (!iGenericAction.isAvailable(actionContext) || !iGenericAction.isEnabled(actionContext)) {
                ret = false;
            } else if (filter != null && !filter.isAvailable(iGenericAction, actionContext)) {
                ret = false;
            }
            ++i;
        }
        return ret;
    }

    public static boolean checkIfFallbackAction(IGenericAction genericAction) {
        boolean ret = false;
        if (genericAction.isFallbackAction()) {
            ret = true;
        } else if (genericAction instanceof IFallbackAction) {
            ret = true;
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

