/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util;

import com.sap.tc.logging.PropertiesConfigurator;
import com.tssap.util.InstallationInfo;
import com.tssap.util.Util;
import com.tssap.util.help.ContextHelp;
import com.tssap.util.startup.IStartupRun;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.trace.internal.BendedStream;
import com.tssap.util.trace.internal.PlatformLogListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class UtilPlugin
extends AbstractUIPlugin
implements IStartup {
    private static final String DEFAULT_CONFIG_RESOURCE = "com/tssap/util/trace/internal/defaultTraceConfig.properties";
    private static final String STARTUP_RUN_EXTENSION_POINT = "Startup";
    private static final String STARTUP_EXTENSION_CLASS_NAME = "class";
    private static final String STARTUP_IMPL_INTERFACE = "com.tssap.util.startup.IStartupRun";
    private static final String CONTEXT_HELP_EXTENSION = "ContextHelpMapping";
    public static final String TRACE_CONFIG_DEFINITION_FILENAME = "traceconfig.dat";
    private static TracerI tracer;
    private static IStartupRun[] runExtensions;
    private static UtilPlugin instance;
    static /* synthetic */ Class class$com$tssap$util$UtilPlugin;

    public UtilPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        instance = this;
    }

    public static UtilPlugin getInstance() {
        return instance;
    }

    public static TracerI getTracer() {
        if (tracer == null) {
            tracer = TracingManager.getTracer(class$com$tssap$util$UtilPlugin == null ? (class$com$tssap$util$UtilPlugin = UtilPlugin.class$("com.tssap.util.UtilPlugin")) : class$com$tssap$util$UtilPlugin);
        }
        return tracer;
    }

    public static String getPluginId() {
        return UtilPlugin.getInstance().getDescriptor().getUniqueIdentifier();
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        UtilPlugin.log((IStatus)new Status(4, UtilPlugin.getPluginId(), 4, message, null));
    }

    public static void logException(Throwable e, final String title, String message) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            if (message == null) {
                message = e.getMessage();
            }
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, UtilPlugin.getPluginId(), 0, message, e);
        }
        ResourcesPlugin.getPlugin().getLog().log(status);
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        final IStatus fstatus = status;
        display.asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError(null, (String)title, null, (IStatus)fstatus);
            }
        });
    }

    public static void logException(Throwable e) {
        UtilPlugin.logException(e, null, null);
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, UtilPlugin.getPluginId(), 0, e.getMessage(), e);
        UtilPlugin.log(status);
    }

    private Collection getStartupExtensions() {
        ArrayList<IConfigurationElement> ext = new ArrayList<IConfigurationElement>();
        IExtensionPoint extensionPoint = this.getDescriptor().getExtensionPoint(STARTUP_RUN_EXTENSION_POINT);
        if (extensionPoint == null) {
            return ext;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configurationElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configurationElements.length) {
                if (configurationElements[j].getAttribute(STARTUP_EXTENSION_CLASS_NAME) != null) {
                    ext.add(configurationElements[j]);
                }
                ++j;
            }
            ++i;
        }
        return ext;
    }

    public static void setRunExtensions(IStartupRun[] ext) {
        runExtensions = ext;
    }

    public static IStartupRun[] getRunExtensions() {
        return runExtensions;
    }

    private void initStartupExtensions() throws CoreException {
        super.startup();
        ArrayList<IStartupRun> extensions = new ArrayList<IStartupRun>();
        Collection ext = this.getStartupExtensions();
        Iterator iterator = ext.iterator();
        while (iterator.hasNext()) {
            Object nextEl = iterator.next();
            if (!(nextEl instanceof IConfigurationElement)) continue;
            IConfigurationElement confEl = (IConfigurationElement)nextEl;
            String className = confEl.getAttribute(STARTUP_EXTENSION_CLASS_NAME);
            try {
                IExtension declExt = confEl.getDeclaringExtension();
                ClassLoader loader = declExt.getDeclaringPluginDescriptor().getPluginClassLoader();
                Object classInst = loader.loadClass(className).newInstance();
                if (classInst instanceof IStartupRun) {
                    extensions.add((IStartupRun)classInst);
                    continue;
                }
                UtilPlugin.logErrorMessage("startup Extensionpoint user must implement com.tssap.util.startup.IStartupRun");
            }
            catch (Exception e) {
                UtilPlugin.logException(e);
            }
        }
        UtilPlugin.setRunExtensions(extensions.toArray(new IStartupRun[0]));
    }

    private void initContextHelpExtension() {
        IExtensionPoint extensionPoint = this.getDescriptor().getExtensionPoint(CONTEXT_HELP_EXTENSION);
        if (extensionPoint == null) {
            return;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configurationElements = extensions[i].getConfigurationElements();
            String id = extensions[i].getDeclaringPluginDescriptor().getUniqueIdentifier();
            int j = 0;
            while (j < configurationElements.length) {
                if (configurationElements[j].getAttribute("file") != null) {
                    String file = configurationElements[j].getAttribute("file");
                    Plugin p = Platform.getPlugin((String)id);
                    URL url = p.getDescriptor().getInstallURL();
                    try {
                        url = Platform.resolve((URL)url);
                        ContextHelp.addFile(id, url.toExternalForm() + file);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void initTraceConfig() {
        String utilPluginID = Util.getPluginID(class$com$tssap$util$UtilPlugin == null ? (class$com$tssap$util$UtilPlugin = UtilPlugin.class$("com.tssap.util.UtilPlugin")) : class$com$tssap$util$UtilPlugin);
        if (utilPluginID != null) {
            File confFile;
            Plugin utilPlugin = Platform.getPlugin((String)utilPluginID);
            IPath metaPath = Platform.getPluginStateLocation((Plugin)utilPlugin);
            String traceConfFileName = metaPath.toOSString() + "/" + TRACE_CONFIG_DEFINITION_FILENAME;
            Properties prop = new Properties();
            try {
                prop.load(new FileInputStream(traceConfFileName));
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
            String confFileName = prop.getProperty("TraceConfigFile");
            boolean confFileConfigured = false;
            if (confFileName != null && (confFile = new File(confFileName)).exists()) {
                confFileConfigured = true;
                this.configureTraceFromFile(confFile);
            }
            if (!confFileConfigured) {
                UtilPlugin.addActiveLogProperties(this.getDefaultLogProperties());
            }
        }
    }

    public Properties getDefaultLogProperties() {
        Properties p = this.loadDefaultLogProperties();
        if (p == null) {
            p = this.getFallbackDefaultLogProperties();
        }
        return p;
    }

    public Properties getFallbackDefaultLogProperties() {
        Properties p = new Properties();
        ((Hashtable)p).put("formatter[DefaultLog_Formatter]", "TraceFormatter");
        ((Hashtable)p).put("formatter[DefaultLog_Formatter].pattern", "%24d %-60-l [%t] %s: %m");
        ((Hashtable)p).put("log[Default_Eclipse_Log]", "com.tssap.util.trace.internal.EclipseLog");
        ((Hashtable)p).put("log[Default_Eclipse_Log].formatter", "formatter[DefaultLog_Formatter]");
        ((Hashtable)p).put(".localLogs", "log[Default_Eclipse_Log]");
        ((Hashtable)p).put("/.localLogs", "log[Default_Eclipse_Log]");
        ((Hashtable)p).put("log[Default_Eclipse_Log].effSeverity", "ERROR");
        ((Hashtable)p).put(".severity", "ERROR");
        ((Hashtable)p).put("/.severity", "ERROR");
        return p;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties loadDefaultLogProperties() {
        InputStream in;
        Properties p;
        block8: {
            p = null;
            in = null;
            in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(DEFAULT_CONFIG_RESOURCE);
            if (in == null) break block8;
            p = new Properties();
            p.load(in);
        }
        Object var5_3 = null;
        if (in == null) return p;
        try {
            in.close();
            return p;
        }
        catch (IOException e2) {}
        return p;
        {
            catch (IOException e) {
                UtilPlugin.log((IStatus)new Status(4, Util.getPluginID(class$com$tssap$util$UtilPlugin == null ? (class$com$tssap$util$UtilPlugin = UtilPlugin.class$("com.tssap.util.UtilPlugin")) : class$com$tssap$util$UtilPlugin), 0, "Error loading default logging properties", (Throwable)e));
                p = null;
                Object var5_4 = null;
                if (in == null) return p;
                try {
                    in.close();
                    return p;
                }
                catch (IOException e2) {}
                return p;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void configureTraceFromFile(File f) {
        PropertiesConfigurator pc = new PropertiesConfigurator(f);
        pc.setClassLoader(UtilPlugin.getInstance().getDescriptor().getPluginClassLoader());
        pc.configure();
        PlatformLogListener.activate(true);
    }

    private static void addActiveLogProperties(Properties configProps) {
        PropertiesConfigurator pc = new PropertiesConfigurator(configProps);
        pc.setClassLoader(UtilPlugin.getInstance().getDescriptor().getPluginClassLoader());
        pc.configure();
        PlatformLogListener.activate(true);
    }

    public void startup() throws CoreException {
        super.startup();
        this.initTraceConfig();
        String instType = InstallationInfo.getInstallationType() == 1 ? "Sap Internal Installation" : "";
        UtilPlugin.log((IStatus)new Status(1, STARTUP_RUN_EXTENSION_POINT, 0, "Sap NetWeaver Developer Studio - " + InstallationInfo.getBuildVersion() + " " + instType, null));
        this.bendSystemStreams();
        this.initStartupExtensions();
        this.initContextHelpExtension();
    }

    private void bendSystemStreams() {
        PrintStream orgSysOutStream = System.out;
        System.setOut(new BendedStream(orgSysOutStream, 0));
    }

    public void earlyStartup() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        runExtensions = null;
    }
}

