/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.util;

import com.tssap.util.UtilPlugin;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class InstallationInfo {
    private static final int VALIDATION_VAL = -546282239;
    private static final String INSTTYPE_KEY = "SAPInstallation";
    private static final String TYPE_FILE_PATH = "installation.type";
    private static final String CONFIG_PLUGIN_ID = "com.tssap.config";
    public static final int TYPE_SAP_INTERNAL = 1;
    public static final int TYPE_EXTERNAL = 2;
    private static final String FILENAME_BUILDVERSION = "buildnum.txt";
    private static int instType = -1;
    static /* synthetic */ Class class$com$tssap$util$InstallationInfo;

    public static String getBuildVersion() {
        String ret = InstallationInfo.getInstFolderRelativeFileContent(FILENAME_BUILDVERSION);
        return ret != null ? ret : "Unknown";
    }

    public static int getInstallationType() {
        if (instType == -1) {
            instType = InstallationInfo.checkInstType();
        }
        return instType;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int checkInstType() {
        int ret = 2;
        IPluginDescriptor confPlugin = Platform.getPluginRegistry().getPluginDescriptor(CONFIG_PLUGIN_ID);
        if (confPlugin != null) {
            InputStream typeFileInStream;
            block13: {
                String instVal;
                typeFileInStream = null;
                Properties props = new Properties();
                typeFileInStream = confPlugin.getPlugin().openStream((IPath)new Path(TYPE_FILE_PATH));
                if (typeFileInStream != null) {
                    props.load(typeFileInStream);
                }
                if ((instVal = props.getProperty(INSTTYPE_KEY)) != null && instVal.hashCode() * 17 == -546282239) {
                    ret = 1;
                    break block13;
                }
                UtilPlugin.getTracer().log(4, class$com$tssap$util$InstallationInfo == null ? (class$com$tssap$util$InstallationInfo = InstallationInfo.class$("com.tssap.util.InstallationInfo")) : class$com$tssap$util$InstallationInfo, "checkInstType()", "Invalid installation type value");
            }
            Object var6_7 = null;
            if (typeFileInStream == null) return ret;
            try {
                typeFileInStream.close();
                return ret;
            }
            catch (IOException e2) {
                UtilPlugin.getTracer().log(3, class$com$tssap$util$InstallationInfo == null ? (class$com$tssap$util$InstallationInfo = InstallationInfo.class$("com.tssap.util.InstallationInfo")) : class$com$tssap$util$InstallationInfo, "checkInstType()", "Unable to close installation file stream", (Throwable)e2);
            }
            return ret;
            {
                catch (CoreException e1) {
                    UtilPlugin.getTracer().log(6, class$com$tssap$util$InstallationInfo == null ? (class$com$tssap$util$InstallationInfo = InstallationInfo.class$("com.tssap.util.InstallationInfo")) : class$com$tssap$util$InstallationInfo, "checkInstType()", "No installation type file availible", (Throwable)e1);
                    Object var6_8 = null;
                    if (typeFileInStream == null) return ret;
                    try {
                        typeFileInStream.close();
                        return ret;
                    }
                    catch (IOException e2) {
                        UtilPlugin.getTracer().log(3, class$com$tssap$util$InstallationInfo == null ? (class$com$tssap$util$InstallationInfo = InstallationInfo.class$("com.tssap.util.InstallationInfo")) : class$com$tssap$util$InstallationInfo, "checkInstType()", "Unable to close installation file stream", (Throwable)e2);
                    }
                    return ret;
                }
                catch (IOException e) {
                    UtilPlugin.getTracer().log(4, class$com$tssap$util$InstallationInfo == null ? (class$com$tssap$util$InstallationInfo = InstallationInfo.class$("com.tssap.util.InstallationInfo")) : class$com$tssap$util$InstallationInfo, "checkInstType()", "Error reading installation type file", (Throwable)e);
                    Object var6_9 = null;
                    if (typeFileInStream == null) return ret;
                    try {
                        typeFileInStream.close();
                        return ret;
                    }
                    catch (IOException e2) {
                        UtilPlugin.getTracer().log(3, class$com$tssap$util$InstallationInfo == null ? (class$com$tssap$util$InstallationInfo = InstallationInfo.class$("com.tssap.util.InstallationInfo")) : class$com$tssap$util$InstallationInfo, "checkInstType()", "Unable to close installation file stream", (Throwable)e2);
                    }
                    return ret;
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                if (typeFileInStream == null) throw throwable;
                try {
                    typeFileInStream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    UtilPlugin.getTracer().log(3, class$com$tssap$util$InstallationInfo == null ? (class$com$tssap$util$InstallationInfo = InstallationInfo.class$("com.tssap.util.InstallationInfo")) : class$com$tssap$util$InstallationInfo, "checkInstType()", "Unable to close installation file stream", (Throwable)e2);
                }
                throw throwable;
            }
        }
        UtilPlugin.getTracer().log(4, class$com$tssap$util$InstallationInfo == null ? (class$com$tssap$util$InstallationInfo = InstallationInfo.class$("com.tssap.util.InstallationInfo")) : class$com$tssap$util$InstallationInfo, "checkInstType()", "Configuration plugin not availible");
        return ret;
    }

    private static InputStream getUrlStream(URL url) {
        BufferedInputStream ret = null;
        try {
            ret = new BufferedInputStream(url.openStream());
        }
        catch (IOException e) {
            UtilPlugin.getTracer().log(4, class$com$tssap$util$InstallationInfo == null ? (class$com$tssap$util$InstallationInfo = InstallationInfo.class$("com.tssap.util.InstallationInfo")) : class$com$tssap$util$InstallationInfo, "getInstFolderRelativeFileStream(String relFileName)", "File does not exsist", (Throwable)e);
        }
        return ret;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getInstFolderRelativeFileContent(String relFileName) {
        InputStream in;
        String ret;
        block10: {
            ret = null;
            in = null;
            URL u = new URL(BootLoader.getInstallURL(), relFileName);
            in = InstallationInfo.getUrlStream(u);
            if (in == null) break block10;
            int length = in.available();
            byte[] b = new byte[length];
            in.read(b);
            ret = new String(b);
        }
        Object var7_8 = null;
        if (in == null) return ret;
        try {
            in.close();
            return ret;
        }
        catch (IOException e2) {
            UtilPlugin.getTracer().log(4, class$com$tssap$util$InstallationInfo == null ? (class$com$tssap$util$InstallationInfo = InstallationInfo.class$("com.tssap.util.InstallationInfo")) : class$com$tssap$util$InstallationInfo, "getInstFolderRelativeFileContent(String relFileName)", "Unable to close stream", (Throwable)e2);
        }
        return ret;
        {
            catch (MalformedURLException e) {
                UtilPlugin.getTracer().error(class$com$tssap$util$InstallationInfo == null ? (class$com$tssap$util$InstallationInfo = InstallationInfo.class$("com.tssap.util.InstallationInfo")) : class$com$tssap$util$InstallationInfo, "getInstFolderRelativeFileContent(String relFileName)", "Unable to construct URL", (Throwable)e);
                Object var7_9 = null;
                if (in == null) return ret;
                try {
                    in.close();
                    return ret;
                }
                catch (IOException e2) {
                    UtilPlugin.getTracer().log(4, class$com$tssap$util$InstallationInfo == null ? (class$com$tssap$util$InstallationInfo = InstallationInfo.class$("com.tssap.util.InstallationInfo")) : class$com$tssap$util$InstallationInfo, "getInstFolderRelativeFileContent(String relFileName)", "Unable to close stream", (Throwable)e2);
                }
                return ret;
            }
            catch (IOException e) {
                UtilPlugin.getTracer().log(3, class$com$tssap$util$InstallationInfo == null ? (class$com$tssap$util$InstallationInfo = InstallationInfo.class$("com.tssap.util.InstallationInfo")) : class$com$tssap$util$InstallationInfo, "getInstFolderRelativeFileContent(String relFileName)", "Error reading file content", (Throwable)e);
                Object var7_10 = null;
                if (in == null) return ret;
                try {
                    in.close();
                    return ret;
                }
                catch (IOException e2) {
                    UtilPlugin.getTracer().log(4, class$com$tssap$util$InstallationInfo == null ? (class$com$tssap$util$InstallationInfo = InstallationInfo.class$("com.tssap.util.InstallationInfo")) : class$com$tssap$util$InstallationInfo, "getInstFolderRelativeFileContent(String relFileName)", "Unable to close stream", (Throwable)e2);
                }
                return ret;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e2) {
                UtilPlugin.getTracer().log(4, class$com$tssap$util$InstallationInfo == null ? (class$com$tssap$util$InstallationInfo = InstallationInfo.class$("com.tssap.util.InstallationInfo")) : class$com$tssap$util$InstallationInfo, "getInstFolderRelativeFileContent(String relFileName)", "Unable to close stream", (Throwable)e2);
            }
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

