/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.utils;

import com.sap.caf.rt.ui.cool.generic.ServiceFacade;
import com.sap.caf.rt.ui.cool.utils.CoolConnectionProperties;
import com.sap.caf.rt.ui.cool.utils.CoolConnectionPropertiesException;
import com.sap.caf.rt.ui.cool.utils.CoolUtilsException;
import com.sap.tc.col.cds.ConnectionData;
import com.sap.tc.col.cds.ConnectionDataCommon;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IMessage;
import com.sap.tc.col.client.generic.api.IMessageList;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.ServiceFacadeFactory;
import com.sap.tc.col.client.generic.core.GCPRuntimeException;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.webdynpro.progmodel.api.IWDMessageManager;
import com.sap.tc.webdynpro.progmodel.api.IWDNode;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeElement;
import com.sap.tc.webdynpro.progmodel.api.IWDViewController;
import com.sap.tc.webdynpro.services.sal.localization.api.WDResourceHandler;
import com.sap.tc.webdynpro.services.session.IScope;
import com.sap.tc.webdynpro.services.session.ScopeType;
import com.sap.tc.webdynpro.services.session.Utils;
import java.util.Hashtable;

public class CoolUtils {
    public static final String SERVICE_FACADE_KEY = "SERVICE_FACADE";

    public static IServiceFacade getServiceFacade(String deployableObjectName) throws CoolUtilsException {
        try {
            CoolConnectionProperties cp = CoolConnectionProperties.getCoolConnectionProperties(deployableObjectName);
            return CoolUtils.getServiceFacade(cp);
        }
        catch (CoolConnectionPropertiesException e) {
            throw new CoolUtilsException("Failed to read Cool connection parameters: \n" + e.getMessage());
        }
        catch (GCPRuntimeException e) {
            throw new CoolUtilsException("Failed to connect to Cool server: \n" + e.getMessage());
        }
    }

    public static IServiceFacade getTestServiceFacade(String url, String user, String password) throws CoolUtilsException {
        IServiceFacade sf = (IServiceFacade)Utils.getScope((ScopeType)IScope.APPLICATION_SCOPE).get((Object)SERVICE_FACADE_KEY);
        if (sf == null) {
            sf = new ServiceFacade(url, user, password);
            Utils.getScope((ScopeType)IScope.APPLICATION_SCOPE).put((Object)SERVICE_FACADE_KEY, (Object)sf);
        }
        return sf;
    }

    public static IServiceFacade getServiceFacade(CoolConnectionProperties cp) throws CoolUtilsException {
        try {
            IServiceFacade sf = (IServiceFacade)Utils.getScope((ScopeType)IScope.APPLICATION_SCOPE).get((Object)SERVICE_FACADE_KEY);
            if (sf == null) {
                if (cp.getCoolHost().equalsIgnoreCase("caf")) {
                    Hashtable ht = CoolUtils.initHashtable(cp);
                    sf = new ServiceFacade(ht, WDResourceHandler.getCurrentSessionLocale());
                } else {
                    ConnectionDataCommon cd = new ConnectionDataCommon();
                    cd.setProperty("client", cp.coolClient);
                    cd.setProperty("user", cp.coolUserName);
                    cd.setProperty("passwd", cp.coolUserPassword);
                    cd.setProperty("lang", cp.coolLocaleStr);
                    cd.setProperty("sysnr", cp.coolSysNumber);
                    cd.setProperty("r3name", cp.coolHost);
                    sf = ServiceFacadeFactory.createServiceFacade((ConnectionData)cd);
                }
                Utils.getScope((ScopeType)IScope.APPLICATION_SCOPE).put((Object)SERVICE_FACADE_KEY, (Object)sf);
            }
            return sf;
        }
        catch (GCPRuntimeException e) {
            throw new CoolUtilsException("Failed to connect to Cool server: \n" + e.getMessage());
        }
    }

    public static Hashtable initHashtable(CoolConnectionProperties cp) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("java.naming.provider.url", cp.coolURL);
        ht.put("java.naming.security.principal", cp.coolUserName);
        ht.put("java.naming.security.credentials", cp.coolUserPassword);
        ht.put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
        return ht;
    }

    public static IServiceModule getServiceModule(IServiceFacade serviceFacade, String serviceModuleName) throws CoolUtilsException {
        if (serviceFacade == null) {
            return null;
        }
        serviceModuleName = serviceModuleName != null ? serviceModuleName : "";
        try {
            IServiceModule serviceModule = serviceFacade.getServiceModule(serviceModuleName);
            serviceModule.associatedModelInfo();
            return serviceModule;
        }
        catch (Exception e) {
            throw new CoolUtilsException("Invalid or wrong backend Service Module specified: \n" + e.getMessage());
        }
    }

    public static IAspectDescriptor readAspectMetaData(IServiceModule serviceModule, String aspectName, String[] fieldAttrs, IWDNode nodeTo, String typePrefix) throws CoolUtilsException {
        int i;
        if (serviceModule == null) {
            return null;
        }
        IServiceModuleDescriptor serviceModuleDesc = serviceModule.getDescriptor();
        IAspectDescriptor aspectDesc = serviceModuleDesc.getAspectDescriptor(aspectName = aspectName != null ? aspectName : "");
        if (aspectDesc == null) {
            throw new CoolUtilsException("Invalid or wrong backend Aspect specified: \"" + aspectName + "\"");
        }
        IStructureDescriptor strDesc = aspectDesc.getStructure();
        int structSize = strDesc.size();
        for (i = 0; i < nodeTo.size(); ++i) {
            nodeTo.removeElement(nodeTo.getElementAt(i));
        }
        for (i = 0; i < structSize; ++i) {
            IFieldDescriptor fieldDesc = strDesc.getFieldDescriptor(i);
            IWDNodeElement newEl = nodeTo.createElement();
            try {
                newEl.setAttributeValue(fieldAttrs[0], (Object)fieldDesc.getName());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                newEl.setAttributeValue(fieldAttrs[1], (Object)fieldDesc.getText());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                String type = typePrefix + fieldDesc.getType();
                newEl.setAttributeValue(fieldAttrs[2], (Object)type);
            }
            catch (Exception e) {
                // empty catch block
            }
            nodeTo.addElement(newEl);
        }
        return aspectDesc;
    }

    public static void removeCurrentAspectRow(IAspect aspect, IWDNode node) throws CoolUtilsException {
        try {
            IWDNodeElement el = node.getCurrentElement();
            aspect.remove(node.getLeadSelection());
            aspect.sendChanges();
            node.removeElement(el);
        }
        catch (Exception e) {
            throw new CoolUtilsException("Could not remove the aspect row and corresponding current element of the context node : \n" + e.getMessage());
        }
    }

    public static String getKeyAsString(IKey key) throws CoolUtilsException {
        try {
            String strKey = key.toString();
            return strKey.substring(1, strKey.length() - 1);
        }
        catch (Exception ex) {
            throw new CoolUtilsException("Could not convert Key to string : \n" + ex.getMessage());
        }
    }

    public static boolean reportCoolMessages(IServiceFacade sf, IWDViewController viewController, boolean stopOnFirstFail, boolean cancelNavigation) {
        return CoolUtils.reportOrRaiseCoolMessages(sf.getAllMessages(), viewController.getComponent().getMessageManager(), stopOnFirstFail, cancelNavigation, false);
    }

    public static boolean reportCoolMessages(IAspect aspect, IWDMessageManager manager, boolean stopOnFirstFail, boolean cancelNavigation) {
        return CoolUtils.reportOrRaiseCoolMessages(aspect.getMessages(), manager, stopOnFirstFail, cancelNavigation, false);
    }

    public static boolean reportCoolMessages(IQuery query, IWDMessageManager manager, boolean stopOnFirstFail, boolean cancelNavigation) {
        return CoolUtils.reportOrRaiseCoolMessages(CoolUtils.getQueryResultAspect(query).getMessages(), manager, stopOnFirstFail, cancelNavigation, false);
    }

    private static IAspect getQueryResultAspect(IQuery query) {
        IAspect aspect = query.getResultAspect();
        if (aspect == null) {
            throw new RuntimeException("Cannot get list of messages from query, because result aspect is null. Query: " + query);
        }
        return aspect;
    }

    public static boolean reportCoolMessages(IServiceFacade sf, IWDMessageManager manager, boolean stopOnFirstFail, boolean cancelNavigation) {
        return CoolUtils.reportOrRaiseCoolMessages(sf.getAllMessages(), manager, stopOnFirstFail, cancelNavigation, false);
    }

    public static boolean reportCoolMessages(IMessageList list, IWDMessageManager manager, boolean stopOnFirstFail, boolean cancelNavigation) {
        return CoolUtils.reportOrRaiseCoolMessages(list, manager, stopOnFirstFail, cancelNavigation, false);
    }

    public static boolean raiseCoolMessages(IServiceFacade sf, IWDViewController viewController, boolean stopOnFirstFail, boolean cancelNavigation) {
        return CoolUtils.reportOrRaiseCoolMessages(sf.getAllMessages(), viewController.getComponent().getMessageManager(), stopOnFirstFail, cancelNavigation, true);
    }

    public static boolean reportCoolMessages(IAspect aspect, IWDViewController viewController, boolean stopOnFirstFail, boolean cancelNavigation) {
        return CoolUtils.reportOrRaiseCoolMessages(aspect.getMessages(), viewController.getComponent().getMessageManager(), stopOnFirstFail, cancelNavigation, false);
    }

    public static boolean reportCoolMessages(IQuery query, IWDViewController viewController, boolean stopOnFirstFail, boolean cancelNavigation) {
        return CoolUtils.reportOrRaiseCoolMessages(CoolUtils.getQueryResultAspect(query).getMessages(), viewController.getComponent().getMessageManager(), stopOnFirstFail, cancelNavigation, false);
    }

    public static boolean raiseCoolMessages(IAspect aspect, IWDMessageManager manager, boolean stopOnFirstFail, boolean cancelNavigation) {
        return CoolUtils.reportOrRaiseCoolMessages(aspect.getMessages(), manager, stopOnFirstFail, cancelNavigation, true);
    }

    public static boolean raiseCoolMessages(IQuery query, IWDMessageManager manager, boolean stopOnFirstFail, boolean cancelNavigation) {
        return CoolUtils.reportOrRaiseCoolMessages(CoolUtils.getQueryResultAspect(query).getMessages(), manager, stopOnFirstFail, cancelNavigation, true);
    }

    public static boolean raiseCoolMessages(IServiceFacade sf, IWDMessageManager manager, boolean stopOnFirstFail, boolean cancelNavigation) {
        return CoolUtils.reportOrRaiseCoolMessages(sf.getAllMessages(), manager, stopOnFirstFail, cancelNavigation, true);
    }

    public static boolean raiseCoolMessages(IMessageList list, IWDMessageManager manager, boolean stopOnFirstFail, boolean cancelNavigation) {
        return CoolUtils.reportOrRaiseCoolMessages(list, manager, stopOnFirstFail, cancelNavigation, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reportOrRaiseCoolMessages(IMessageList list, IWDMessageManager manager, boolean stopOnFirstFail, boolean cancelNavigation, boolean raise) {
        boolean result = false;
        int size = list.size();
        try {
            for (int i = 0; i < size; ++i) {
                IMessage message = list.getMessage(i);
                switch (message.getType()) {
                    case 2: {
                        if (raise) {
                            manager.raiseException(message.getText(), cancelNavigation);
                            break;
                        }
                        manager.reportException(message.getText(), cancelNavigation);
                        break;
                    }
                    case 1: {
                        manager.reportWarning(message.getText());
                        break;
                    }
                    case 0: {
                        manager.reportSuccess(message.getText());
                        break;
                    }
                    default: {
                        if (raise) {
                            manager.raiseException("Unknown type of message has been recieved from <cool>. Message type: " + message.getType() + ", message text: " + message.getText(), true);
                            break;
                        }
                        manager.reportException("Unknown type of message has been recieved from <cool>. Message type: " + message.getType() + ", message text: " + message.getText(), true);
                    }
                }
                if (!message.isFailed()) continue;
                result = true;
                if (!stopOnFirstFail) continue;
                break;
            }
        }
        finally {
            list.clear();
        }
        return result;
    }

    public static boolean isFatal(IAspect aspect) {
        return CoolUtils.isFatal(aspect.getMessages());
    }

    public static boolean isFatal(IQuery query) {
        return CoolUtils.isFatal(CoolUtils.getQueryResultAspect(query).getMessages());
    }

    public static boolean isFatal(IServiceFacade sf) {
        return CoolUtils.isFatal(sf.getAllMessages());
    }

    public static boolean isFatal(IMessageList list) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            IMessage msg = list.getMessage(i);
            if (!msg.isFailed()) continue;
            return true;
        }
        return false;
    }
}

