/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.generic;

import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.caf.rt.ui.cool.generic.Action;
import com.sap.caf.rt.ui.cool.generic.Aspect;
import com.sap.caf.rt.ui.cool.generic.AspectCache;
import com.sap.caf.rt.ui.cool.generic.AspectRow;
import com.sap.caf.rt.ui.cool.generic.AspectServiceAccess;
import com.sap.caf.rt.ui.cool.generic.CAFServiceManager;
import com.sap.caf.rt.ui.cool.generic.ColModelInfo;
import com.sap.caf.rt.ui.cool.generic.ICacheRootObject;
import com.sap.caf.rt.ui.cool.generic.Key;
import com.sap.caf.rt.ui.cool.generic.KeyList;
import com.sap.caf.rt.ui.cool.generic.MessageFactory;
import com.sap.caf.rt.ui.cool.generic.MessageList;
import com.sap.caf.rt.ui.cool.generic.Query;
import com.sap.caf.rt.ui.cool.generic.ServiceFacade;
import com.sap.caf.rt.ui.cool.generic.Structure;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.cmi.metadata.ICMIModelInfo;
import com.sap.tc.cmi.model.ICMIModelClass;
import com.sap.tc.col.client.generic.api.IAction;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.api.LockStrategy;
import com.sap.tc.col.client.metadata.api.IAspectActionDescriptor;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IKeyAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IQueryDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ServiceModule
implements IServiceModule {
    private static final String APPLICATION = (class$com$sap$caf$rt$ui$cool$generic$ServiceModule == null ? (class$com$sap$caf$rt$ui$cool$generic$ServiceModule = ServiceModule.class$("com.sap.caf.rt.ui.cool.generic.ServiceModule")) : class$com$sap$caf$rt$ui$cool$generic$ServiceModule).getName();
    private static final String jARMRequest = "XAP:COOL:" + APPLICATION;
    private static final Location logger = Location.getLocation((String)APPLICATION);
    private final ServiceFacade serviceFacade;
    private CAFServiceManager serviceManager;
    private IServiceModuleDescriptor serviceModuleDescriptor;
    private AspectServiceAccess proxy;
    private String shortName;
    private ColModelInfo modelInfo;
    private ArrayList cacheRootObjects = new ArrayList();
    static /* synthetic */ Class class$com$sap$caf$rt$ui$cool$generic$ServiceModule;

    protected ServiceModule(IServiceFacade serviceFacade, CAFServiceManager serviceManager, AspectServiceAccess proxy) {
        if (proxy == null || proxy.getServiceModuleDescriptor() == null) {
            throw new NullPointerException("Service Module Description cannot be null.");
        }
        this.serviceFacade = (ServiceFacade)serviceFacade;
        this.serviceModuleDescriptor = proxy.getServiceModuleDescriptor();
        this.serviceManager = serviceManager;
        this.proxy = proxy;
        String name = this.serviceModuleDescriptor.getName();
        this.shortName = name.indexOf(".") != -1 ? name.substring(name.lastIndexOf(".") + 1) : name;
    }

    protected ServiceModule(IServiceFacade serviceFacade, CAFServiceManager serviceManager, IServiceModuleDescriptor desc) {
        if (this.serviceModuleDescriptor == null) {
            throw new NullPointerException("Service Module Description cannot be null.");
        }
        this.serviceFacade = (ServiceFacade)serviceFacade;
        this.serviceModuleDescriptor = desc;
        this.serviceManager = serviceManager;
        this.proxy = serviceManager.getAspectServiceAccess(desc.getName());
        String name = this.serviceModuleDescriptor.getName();
        this.shortName = name.indexOf(".") != -1 ? name.substring(name.lastIndexOf(".") + 1) : name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public AspectServiceAccess getAspectServiceAccess() {
        return this.proxy;
    }

    public ISrvMgrServiceManager getServiceManager() {
        return this.serviceManager;
    }

    MessageList getAllMessagesInternal() {
        return this.serviceFacade.getAllMessagesInternal();
    }

    protected ServiceFacade getServiceFacade() {
        return this.serviceFacade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IQuery createQuery(String queryName) {
        String method = jARMRequest + ":createQuery(String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        logger.debugT("queryName={0}", new Object[]{queryName});
        try {
            IQueryDescriptor queryDescriptor = this.getDescriptor().getQueryDescriptor(queryName);
            if (queryDescriptor == null) {
                logger.fatalT("Query with name {0} doesn't exist!", new Object[]{queryName});
                throw new IllegalArgumentException("Query with name " + queryName + " doesn't exist!");
            }
            Query newQuery = (Query)this.createQueryInternal(queryDescriptor);
            AspectCache aspectCache = new AspectCache(newQuery);
            this.cacheRootObjects.add(newQuery);
            newQuery.bindAspectCache(aspectCache);
            Query query = newQuery;
            return query;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Aspect createAspectInCache(AspectCache cache, String aspectName) {
        String method = jARMRequest + ":createAspectInCache(AspectCache, String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        try {
            IAspectDescriptor aspectDescriptor = this.getDescriptor().getAspectDescriptor(aspectName);
            if (aspectDescriptor == null && (aspectDescriptor = this.getDescriptor().getKeyAspectDescriptor(aspectName)) == null) {
                logger.fatalT("Aspect with name {0} doesn't exist!", new Object[]{aspectName});
                throw new IllegalArgumentException("Aspect with name " + aspectName + " doesn't exist!");
            }
            Aspect aspect = (Aspect)this.createAspectInternal(aspectDescriptor);
            if (cache != null) {
                cache.add(aspect);
            }
            Aspect aspect2 = aspect;
            return aspect2;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAspect createAspect(String aspectName) {
        String method = jARMRequest + ":createAspect(String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        logger.debugT("aspectName={0}", new Object[]{aspectName});
        try {
            Aspect aspect = this.createAspectInCache(null, aspectName);
            this.createCacheForAspect(aspect);
            this.registerAspect(aspect);
            Aspect aspect2 = aspect;
            return aspect2;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    public IServiceModuleDescriptor getDescriptor() {
        return this.serviceModuleDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendChanges() {
        String method = jARMRequest + ":sendChanges()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        try {
            ArrayList objs = new ArrayList(this.cacheRootObjects);
            Iterator it = objs.iterator();
            while (it.hasNext()) {
                AspectCache aspectCache = ((ICacheRootObject)it.next()).getAspectCache();
                Iterator aspectIt = aspectCache.iterator();
                while (aspectIt.hasNext()) {
                    Aspect aspect = (Aspect)aspectIt.next();
                    aspect.sendChanges();
                }
            }
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        String method = jARMRequest + ":flush()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        try {
            this.serviceManager.flush();
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceQueueWillBeFlushed() {
        String method = jARMRequest + ":onServiceQueueWillBeFlushed()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        try {
            Iterator it = this.cacheRootObjects.iterator();
            while (it.hasNext()) {
                ICacheRootObject rootObject = (ICacheRootObject)it.next();
                AspectCache aspectCache = rootObject.getAspectCache();
                Iterator aspectIt = aspectCache.iterator();
                while (aspectIt.hasNext()) {
                    Aspect aspect = (Aspect)aspectIt.next();
                    aspect.onServiceQueueWillBeFlushed();
                }
            }
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceQueueFlushed() {
        String method = jARMRequest + ":onServiceQueueFlushed()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        try {
            Iterator it = this.cacheRootObjects.iterator();
            while (it.hasNext()) {
                ICacheRootObject rootObject = (ICacheRootObject)it.next();
                if (!rootObject.getAspectCache().isDirty()) continue;
                logger.infoT("onServiceQueueFlushed", "Cache of Root Object is invalidated");
                rootObject.invalidate();
                if (rootObject instanceof Aspect) {
                    it.remove();
                    continue;
                }
                rootObject.getAspectCache().setDirty(false);
            }
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    public ICMIModelInfo associatedModelInfo() {
        if (this.modelInfo == null) {
            this.modelInfo = (ColModelInfo)this.serviceManager.getRepositoryManager().getCMIModel(this.getDescriptor().getName());
        }
        return this.modelInfo;
    }

    public ICMIModelClass createModelObject(String modelClassName) {
        throw new UnsupportedOperationException();
    }

    public ICMIModelClass createModelObject(Class modelClassClazz) {
        throw new UnsupportedOperationException();
    }

    public String getModelName() {
        return this.associatedModelInfo().getName();
    }

    public String getModelInstanceId() {
        return null;
    }

    public IKeyList createKeyList(String keyName) {
        IKeyAspectDescriptor keyDescriptor = this.getDescriptor().getKeyAspectDescriptor(keyName);
        if (keyDescriptor == null) {
            logger.fatalT(" Key with name " + keyName + " doesn't exist");
            throw new IllegalArgumentException(" Key with name " + keyName + " doesn't exist");
        }
        return new KeyList(keyDescriptor);
    }

    public IKey createKey(String keyName, String[] keyFields) {
        IKeyAspectDescriptor keyDescriptor = this.getDescriptor().getKeyAspectDescriptor(keyName);
        if (keyDescriptor == null) {
            logger.fatalT(" Key with name {0} doesn't exist", new Object[]{keyName});
            throw new IllegalArgumentException(" Key with name " + keyName + " doesn't exist");
        }
        if (keyFields == null) {
            logger.fatalT(" Array with key fields must not be null!");
            throw new IllegalArgumentException(" Array with key fields must not be null!");
        }
        return new Key(keyDescriptor, keyFields);
    }

    public IAspect getAspect(String aspectName, IKeyList keyList) {
        return this.getAspect(null, aspectName, keyList, LockStrategy.SHARED_READ_ONLY);
    }

    public IAspect getAspect(String aspectName, IKeyList keyList, LockStrategy lockMode) {
        return this.getAspect(null, aspectName, keyList, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IAspect getAspect(Aspect sourceAspect, String aspectName, IKeyList keyList, LockStrategy lockMode) {
        String method = jARMRequest + ":getAspect(Aspect, String, IKeyList, LockStrategy)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        try {
            Aspect targetAspect;
            AspectCache cache;
            AspectCache aspectCache = cache = sourceAspect == null ? null : sourceAspect.getAspectCache();
            if (keyList.getDescriptor().getName().equals(aspectName)) {
                targetAspect = (Aspect)this.createKeysAspectInternal(keyList.getDescriptor(), keyList);
                if (cache != null) {
                    cache.add(targetAspect);
                }
            } else {
                targetAspect = (Aspect)this.createAspect(aspectName);
                try {
                    Collection rawResult = this.proxy.readAspectObjects(targetAspect.getName(), (Collection)keyList);
                    targetAspect.setState(5);
                    if (rawResult instanceof List) {
                        Iterator it = ((List)rawResult).iterator();
                        while (it.hasNext()) {
                            this.createRow(targetAspect, (IDataContainerBean)it.next());
                        }
                    } else {
                        this.createRow(targetAspect, (IDataContainerBean)rawResult);
                    }
                    targetAspect.setState(0);
                }
                catch (Exception e) {
                    MessageFactory.createAndRegisterMessageFromException((Throwable)e, this.getServiceFacade());
                }
            }
            if (cache == null) {
                this.createCacheForAspect(targetAspect);
            } else {
                cache.add(targetAspect);
            }
            Aspect aspect = targetAspect;
            return aspect;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRow(IAspect result, IDataContainerBean bean) {
        String method = jARMRequest + ":createRow(IAspect, IDataContainerBean)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        try {
            AspectRow row = (AspectRow)((Aspect)result).createAspectRow();
            row.supplyRowWithData(bean);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    private void createCacheForAspect(Aspect targetAspect) {
        AspectCache aspectCache = new AspectCache(targetAspect);
        this.cacheRootObjects.add(targetAspect);
        targetAspect.setCacheRootObject(true);
        aspectCache.add(targetAspect);
        targetAspect.bindAspectCache(aspectCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IAspect createAspectInternal(IAspectDescriptor aspectDescriptor) {
        String method = jARMRequest + ":createAspectInternal(IAspectDescriptor)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        try {
            IAspect iAspect = Aspect.createEmptyInstance(this, aspectDescriptor);
            return iAspect;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IAspect createKeysAspectInternal(IKeyAspectDescriptor keyDescriptor, IKeyList keyList) {
        String method = jARMRequest + ":createKeysAspectInternal(IKeyDescriptor, IKeyList)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        try {
            IAspect iAspect = Aspect.createPopulatedInstance(this, keyDescriptor, keyList);
            return iAspect;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IQuery createQueryInternal(IQueryDescriptor queryDescriptor) {
        String method = jARMRequest + ":createQueryInternal(IQueryDescriptor)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        try {
            Query query = new Query(queryDescriptor, this);
            return query;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IAction createActionInternal(IAspectActionDescriptor actionDescriptor, Aspect owner) {
        String method = jARMRequest + ":createActionInternal(IAspectActionDescriptor, Aspect)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        try {
            Action action = new Action(actionDescriptor, owner);
            return action;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStructure createStructureInternal(IStructureDescriptor structureDescriptor, IEdoStructure edoStructure) {
        String method = jARMRequest + ":createStructureInternal(IStructureDescriptor,IEdoStructure)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        try {
            Structure structure = new Structure(this, edoStructure);
            return structure;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    public void setDebug(boolean enabled, String guiHost) {
        this.serviceManager.setDebug(enabled, this.serviceModuleDescriptor.getName(), guiHost);
    }

    protected void registerAspect(Aspect aspect) {
    }

    void unregisterAspect(Aspect aspect) {
    }

    void unregisterAspectRowKey(Aspect aspect, Key key) {
    }

    public IAspect getAspect(String arg0, String[] arg1) {
        return null;
    }

    public IAspect getAspect(String arg0, String[] arg1, LockStrategy arg2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        String method = jARMRequest + ":isDirty()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        try {
            Iterator it = this.cacheRootObjects.iterator();
            while (it.hasNext()) {
                AspectCache aspectCache = ((ICacheRootObject)it.next()).getAspectCache();
                Iterator aspectIt = aspectCache.iterator();
                while (aspectIt.hasNext()) {
                    Aspect aspect = (Aspect)aspectIt.next();
                    if (!aspect.isDirty()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

