/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.generic;

import com.sap.caf.rt.ui.cool.generic.CAFServiceManager;
import com.sap.caf.rt.ui.cool.generic.GCPRuntimeException;
import com.sap.caf.rt.ui.cool.generic.Message;
import com.sap.caf.rt.ui.cool.generic.MessageList;
import com.sap.caf.rt.ui.cool.generic.ServiceModule;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.col.cds.ConnectionData;
import com.sap.tc.col.client.generic.api.IMessageList;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.col.servicemanager.api.ISrvMgrCallbackOnFlush;
import com.sap.tc.col.servicemanager.api.ISrvMgrMessage;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrCall;
import com.sap.tc.logging.Location;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class ServiceFacade
implements IServiceFacade,
ISrvMgrCallbackOnFlush {
    private static final String APPLICATION = (class$com$sap$caf$rt$ui$cool$generic$ServiceFacade == null ? (class$com$sap$caf$rt$ui$cool$generic$ServiceFacade = ServiceFacade.class$("com.sap.caf.rt.ui.cool.generic.ServiceFacade")) : class$com$sap$caf$rt$ui$cool$generic$ServiceFacade).getName();
    private static final String jARMRequest = "XAP:COOL:" + APPLICATION;
    private static final Location logger = Location.getLocation((String)APPLICATION);
    private CAFServiceManager serviceManager;
    private HashMap serviceModules = new HashMap();
    private final MessageList allMessages = new MessageList();
    private final MessageList outOfBandMessages = new MessageList(this.allMessages);
    private Map serviceModuleImplementations = new HashMap();
    private static Class[] SERVICE_MODULE_CTOR_SIGNATURE = new Class[]{class$com$sap$tc$col$client$generic$api$IServiceFacade == null ? (class$com$sap$tc$col$client$generic$api$IServiceFacade = ServiceFacade.class$("com.sap.tc.col.client.generic.api.IServiceFacade")) : class$com$sap$tc$col$client$generic$api$IServiceFacade, class$com$sap$caf$rt$ui$cool$generic$CAFServiceManager == null ? (class$com$sap$caf$rt$ui$cool$generic$CAFServiceManager = ServiceFacade.class$("com.sap.caf.rt.ui.cool.generic.CAFServiceManager")) : class$com$sap$caf$rt$ui$cool$generic$CAFServiceManager, class$com$sap$tc$col$client$metadata$api$IServiceModuleDescriptor == null ? (class$com$sap$tc$col$client$metadata$api$IServiceModuleDescriptor = ServiceFacade.class$("com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor")) : class$com$sap$tc$col$client$metadata$api$IServiceModuleDescriptor};
    static /* synthetic */ Class class$com$sap$caf$rt$ui$cool$generic$ServiceFacade;
    static /* synthetic */ Class class$com$sap$caf$rt$ui$cool$generic$ServiceModule;
    static /* synthetic */ Class class$com$sap$tc$col$client$generic$api$IServiceFacade;
    static /* synthetic */ Class class$com$sap$caf$rt$ui$cool$generic$CAFServiceManager;
    static /* synthetic */ Class class$com$sap$tc$col$client$metadata$api$IServiceModuleDescriptor;

    public ServiceFacade(Locale locale) {
        this.defineServiceModuleDefaultImpl(class$com$sap$caf$rt$ui$cool$generic$ServiceModule == null ? (class$com$sap$caf$rt$ui$cool$generic$ServiceModule = ServiceFacade.class$("com.sap.caf.rt.ui.cool.generic.ServiceModule")) : class$com$sap$caf$rt$ui$cool$generic$ServiceModule);
        this.init(null, locale);
    }

    public ServiceFacade(String url, String user, String password) {
        this.defineServiceModuleDefaultImpl(class$com$sap$caf$rt$ui$cool$generic$ServiceModule == null ? (class$com$sap$caf$rt$ui$cool$generic$ServiceModule = ServiceFacade.class$("com.sap.caf.rt.ui.cool.generic.ServiceModule")) : class$com$sap$caf$rt$ui$cool$generic$ServiceModule);
        Hashtable<String, String> prop = new Hashtable<String, String>();
        prop.put("java.naming.provider.url", url);
        prop.put("java.naming.security.principal", user);
        prop.put("java.naming.security.credentials", password);
        prop.put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
        this.init(prop, Locale.getDefault());
    }

    public ServiceFacade(Hashtable connection_properties, Locale locale) {
        this.defineServiceModuleDefaultImpl(class$com$sap$caf$rt$ui$cool$generic$ServiceModule == null ? (class$com$sap$caf$rt$ui$cool$generic$ServiceModule = ServiceFacade.class$("com.sap.caf.rt.ui.cool.generic.ServiceModule")) : class$com$sap$caf$rt$ui$cool$generic$ServiceModule);
        this.init(connection_properties, locale);
    }

    public ServiceFacade(ConnectionData connectionData, Locale locale) {
        this.defineServiceModuleDefaultImpl(class$com$sap$caf$rt$ui$cool$generic$ServiceModule == null ? (class$com$sap$caf$rt$ui$cool$generic$ServiceModule = ServiceFacade.class$("com.sap.caf.rt.ui.cool.generic.ServiceModule")) : class$com$sap$caf$rt$ui$cool$generic$ServiceModule);
        this.init(null, locale);
    }

    protected ISrvMgrServiceManager getServiceManager() {
        if (this.serviceManager == null) {
            throw new IllegalStateException("ServiceManager is not initialized");
        }
        return this.serviceManager;
    }

    protected void init(Hashtable connection_properties, Locale locale) {
        String method = jARMRequest + ":init(Hashtable, Locale)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        try {
            this.serviceManager = new CAFServiceManager(connection_properties, locale);
            this.serviceManager.registerCallbackOnFlush(this);
        }
        catch (Exception e) {
            logger.catching("service manager initialization failed", (Throwable)e);
            throw new GCPRuntimeException("service manager initialization failed", e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    public String[] getServiceModuleNames() {
        return this.getServiceManager().getServiceModuleNames();
    }

    public IServiceModule getServiceModule(String serviceModuleName) {
        return this.getServiceModule(serviceModuleName, "");
    }

    public IServiceModuleDescriptor getServiceModuleDescriptor(String serviceModuleName) {
        return ((CAFServiceManager)this.getServiceManager()).getServiceModuleDescriptor(serviceModuleName);
    }

    public void flush() {
        this.getServiceManager().flush("", "");
    }

    public boolean isDirty() {
        Iterator it = this.serviceModules.values().iterator();
        while (it.hasNext()) {
            if (!((ServiceModule)it.next()).isDirty()) continue;
            return true;
        }
        return false;
    }

    public IMessageList getAllMessages() {
        this.allMessages.copyMessagesFrom((MessageList)this.getAndClearSystemMessages());
        return this.allMessages;
    }

    MessageList getAllMessagesInternal() {
        return this.allMessages;
    }

    public IMessageList getMessages() {
        return this.outOfBandMessages;
    }

    private void addMessages() {
        ISrvMgrMessage[] srvMgrMessages = this.getServiceManager().getMessages();
        if (srvMgrMessages != null) {
            for (int i = 0; i < srvMgrMessages.length; ++i) {
                Message message = new Message(srvMgrMessages[i]);
                this.outOfBandMessages.addMessage(message);
            }
        }
    }

    public void cleanup() {
        this.getServiceManager().cleanup();
    }

    public boolean save() {
        return this.getServiceManager().save();
    }

    public void initLocalLogging() {
    }

    public void setDebug(boolean enabled, String serviceModuleName, String guiHost) {
        this.getServiceManager().setDebug(enabled, serviceModuleName, guiHost);
    }

    public void defineServiceModuleDefaultImpl(Class clazz) {
        if (clazz == null) {
            throw new GCPRuntimeException("default implementation class must not be null");
        }
        this.defineServiceModuleImpl0(null, clazz);
    }

    public void defineServiceModuleImpl(String serviceModuleName, Class clazz) {
        if (serviceModuleName == null || serviceModuleName.length() == 0) {
            throw new IllegalArgumentException("service modul name must not be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("implementation class must not be null");
        }
        this.defineServiceModuleImpl0(serviceModuleName, clazz);
    }

    private void defineServiceModuleImpl0(String serviceModuleName, Class clazz) {
        String method = jARMRequest + ":defineServiceModuleImpl0(String, Class)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        try {
            if (!(class$com$sap$caf$rt$ui$cool$generic$ServiceModule == null ? (class$com$sap$caf$rt$ui$cool$generic$ServiceModule = ServiceFacade.class$("com.sap.caf.rt.ui.cool.generic.ServiceModule")) : class$com$sap$caf$rt$ui$cool$generic$ServiceModule).isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("class " + clazz.getName() + " doesn't fulfill the contract for ServiceModule implementations");
            }
            Constructor ctor = clazz.getDeclaredConstructor(SERVICE_MODULE_CTOR_SIGNATURE);
            this.serviceModuleImplementations.put(serviceModuleName, ctor);
            logger.infoT("service module implementation " + serviceModuleName + " registered");
        }
        catch (NoSuchMethodException e) {
            logger.catching((Throwable)e);
            throw new IllegalArgumentException("class " + clazz.getName() + " doesn't fulfill the contract for ServiceModule implementations");
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    public void afterFlush(ISrvMgrCall[] callList) {
        this.addMessages();
        Iterator it = this.serviceModules.values().iterator();
        while (it.hasNext()) {
            ServiceModule serviceModule = (ServiceModule)it.next();
            serviceModule.onServiceQueueFlushed();
        }
    }

    public void closeConnection() {
        if (this.serviceManager != null) {
            this.serviceManager.closeConnection();
            this.serviceManager = null;
        }
    }

    public IServiceModule getServiceModule(String serviceModuleName, String configuration) {
        ServiceModule serviceModule = (ServiceModule)this.serviceModules.get(serviceModuleName + configuration);
        if (serviceModule == null) {
            serviceModule = new ServiceModule((IServiceFacade)this, this.serviceManager, this.serviceManager.getAspectServiceAccess(serviceModuleName));
            this.serviceModules.put(serviceModuleName + configuration, serviceModule);
        }
        return serviceModule;
    }

    public String[] getServiceModuleConfigurationNames(String serviceModuleName) {
        return this.getServiceManager().getServiceModuleConfigurationNames(serviceModuleName);
    }

    public IServiceModuleDescriptor getServiceModuleDescriptor(String serviceModuleName, String configuration) {
        return ((CAFServiceManager)this.getServiceManager()).getServiceModuleDescriptor(serviceModuleName, configuration);
    }

    public boolean beforeFlush() {
        this.beforeFlush(null, null);
        return true;
    }

    public boolean beforeFlush(String arg0, String arg1) {
        Iterator it = this.serviceModules.values().iterator();
        while (it.hasNext()) {
            ServiceModule serviceModule = (ServiceModule)it.next();
            serviceModule.onServiceQueueWillBeFlushed();
        }
        return true;
    }

    public void resetLockCache() {
    }

    public boolean check() {
        return false;
    }

    public IMessageList getAndClearSystemMessages() {
        ISrvMgrMessage[] sysMsgs = this.getServiceManager().getAndClearSystemMessages();
        MessageList ml = new MessageList();
        for (int i = 0; i < sysMsgs.length; ++i) {
            Message m = new Message(sysMsgs[i]);
            ml.addMessage(m);
        }
        return ml;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

