/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.generic;

import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.caf.rt.ui.cool.generic.AbstractModelClass;
import com.sap.caf.rt.ui.cool.generic.Aspect;
import com.sap.caf.rt.ui.cool.generic.AspectCache;
import com.sap.caf.rt.ui.cool.generic.AspectRow;
import com.sap.caf.rt.ui.cool.generic.ColModelInfo;
import com.sap.caf.rt.ui.cool.generic.EdoStructure;
import com.sap.caf.rt.ui.cool.generic.ICacheRootObject;
import com.sap.caf.rt.ui.cool.generic.MessageFactory;
import com.sap.caf.rt.ui.cool.generic.ServiceFacadeFactory;
import com.sap.caf.rt.ui.cool.generic.ServiceModule;
import com.sap.caf.rt.ui.cool.generic.Structure;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.cmi.metadata.ICMIModelClassInfo;
import com.sap.tc.cmi.metadata.ICMIModelObjectCollectionInfo;
import com.sap.tc.cmi.model.ICMIModel;
import com.sap.tc.cmi.model.ICMIModelClass;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.api.IStructureList;
import com.sap.tc.col.client.generic.api.SortingCriteria;
import com.sap.tc.col.client.metadata.api.IQueryDescriptor;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrCall;
import com.sap.tc.logging.Location;
import java.util.Collection;
import java.util.Iterator;

public class Query
extends AbstractModelClass
implements IQuery,
ICacheRootObject {
    private static final String APPLICATION = (class$com$sap$caf$rt$ui$cool$generic$Query == null ? (class$com$sap$caf$rt$ui$cool$generic$Query = Query.class$("com.sap.caf.rt.ui.cool.generic.Query")) : class$com$sap$caf$rt$ui$cool$generic$Query).getName();
    private static final String jARMRequest = "XAP:COOL:" + APPLICATION;
    private static final Location logger = Location.getLocation((String)APPLICATION);
    private IQueryDescriptor descriptor;
    private Structure inputParameter;
    private IAspect result;
    private IKeyList inputKeyList;
    private ICMIModelClassInfo modelClassInfo;
    private ServiceModule serviceModule;
    private IServiceModule resultAspectServiceModule;
    private AspectCache aspectCache;
    private SortingCriteria sortingCriteria;
    static /* synthetic */ Class class$com$sap$caf$rt$ui$cool$generic$Query;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Query(IQueryDescriptor descriptor, ServiceModule serviceModule) {
        String method = jARMRequest + ":Query(IQueryDescriptor, ServiceModule)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        try {
            if (serviceModule == null) {
                throw new IllegalArgumentException("ServiceModule must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("QueryDescriptor must not be null");
            }
            this.descriptor = descriptor;
            this.serviceModule = serviceModule;
            this.inputKeyList = this.getResultAspectServiceModule().createKeyList(descriptor.getInputKeysDescriptor().getName());
            if (descriptor.hasInputParameters()) {
                this.inputParameter = new Structure(serviceModule, new EdoStructure(descriptor.getInputParameters()));
            }
            this.modelClassInfo = ((ColModelInfo)serviceModule.associatedModelInfo()).getOrCreateModelClassInfo(descriptor);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    public ICMIModel associatedModel() {
        return this.serviceModule;
    }

    public ICMIModelClassInfo associatedModelClassInfo() {
        return this.modelClassInfo;
    }

    private IAspect createResultAspect() {
        if (this.result == null) {
            this.result = this.getResultAspectServiceModule().createAspect(this.descriptor.getResultAspectDescriptor().getName());
        }
        return this.result;
    }

    private IServiceModule getResultAspectServiceModule() {
        if (this.resultAspectServiceModule == null) {
            String smraName = this.descriptor.getResultAspectDescriptor().getServiceModuleDescriptor().getName();
            this.resultAspectServiceModule = ServiceFacadeFactory.getFacadeInstance(null).getServiceModule(smraName);
        }
        return this.resultAspectServiceModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        String method = jARMRequest + ":execute()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        if (this.sortingCriteria != null) {
            throw new RuntimeException("Sorting is not supported in this GCP version");
        }
        this.invalidate();
        try {
            IAspect resultAspect = this.createResultAspect();
            if (this.inputKeyList != null && !this.inputKeyList.isEmpty()) {
                throw new IllegalArgumentException("Input key lists for queries are not supported and must be empty.");
            }
            Collection rawResult = this.serviceModule.getAspectServiceAccess().findBy(resultAspect.getDescriptor().getName(), this.getName(), this.getInputParameterStructure());
            ((Aspect)resultAspect).setState(5);
            try {
                if (rawResult instanceof Collection) {
                    Iterator it = rawResult.iterator();
                    while (it.hasNext()) {
                        this.createRow((IDataContainerBean)it.next(), resultAspect);
                    }
                } else {
                    this.createRow((IDataContainerBean)rawResult, resultAspect);
                }
            }
            finally {
                ((Aspect)resultAspect).setState(0);
            }
            this.aspectCache.add(resultAspect);
            if (this.inputParameter != null) {
                this.inputParameter.makeClean();
            }
        }
        catch (Throwable ex) {
            logger.catching("Error while query execution ", ex);
            MessageFactory.createAndRegisterMessageFromException(ex, this, null, true);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRow(IDataContainerBean bean, IAspect aspect) {
        String method = jARMRequest + ":createRow(IDataContainerBean, IAspect)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        try {
            AspectRow row = (AspectRow)aspect.createAspectRow();
            row.supplyRowWithData(bean);
            row.setState(0);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    public IQueryDescriptor getDescriptor() {
        return this.descriptor;
    }

    public IAspect getResultAspect() {
        return this.result;
    }

    public Object getInputParameter() {
        return this.inputParameter;
    }

    public Collection getResult() {
        return this.getResultAspect();
    }

    public IStructure getInputParameterStructure() {
        if (this.inputParameter == null) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)new UnsupportedOperationException("Query '" + this.descriptor.getName() + "'doesn't support input parameter!"), this, "");
        }
        return this.inputParameter;
    }

    public IKeyList getInputKeyList() {
        return this.inputKeyList;
    }

    public void invalidate() {
        try {
            if (this.result != null) {
                ((Aspect)this.result).invalidateInternal();
                this.result = null;
            }
            this.aspectCache.clear();
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this, "");
        }
    }

    public ICMIModelClass getRelatedModelObject(String rolename) {
        try {
            if (rolename.equalsIgnoreCase("inputParameter") || rolename.equals("com.sap.tc.cmi:queryInputParameter")) {
                return (ICMIModelClass)this.getInputParameter();
            }
            return super.getRelatedModelObject(rolename);
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this, "");
            return null;
        }
    }

    public Collection getRelatedModelObjects(String rolename) {
        try {
            if (rolename.equalsIgnoreCase("result") || rolename.equals("com.sap.tc.cmi:queryResult")) {
                return this.getResultAspect();
            }
            return super.getRelatedModelObjects(rolename);
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this, "");
            return null;
        }
    }

    protected void bindAspectCache(AspectCache aspectCache) {
        this.aspectCache = aspectCache;
    }

    public boolean isCacheRootObject() {
        return true;
    }

    public AspectCache getAspectCache() {
        return this.aspectCache;
    }

    public void onCallsProcessed(ISrvMgrCall[] calls) {
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public ICMIModelClassInfo associatedInputParameterInfo() {
        return this.modelClassInfo.getRelatedModelClassInfo("inputParameter");
    }

    public ICMIModelObjectCollectionInfo associatedResultInfo() {
        return ((ColModelInfo)this.modelClassInfo.getModelInfo()).getOrCreateModelObjectCollectionInfo(this.descriptor.getResultAspectDescriptor());
    }

    public long countOf() {
        return -1L;
    }

    public boolean isDirty() {
        return this.result == null || this.inputParameter != null && this.inputParameter.isDirty();
    }

    public void setSortingCriteria(SortingCriteria sorting) {
        this.sortingCriteria = sorting;
    }

    public IStructure createSelectOption(String arg0, String arg1, String arg2, String arg3) {
        return null;
    }

    public IStructure createSelectOption(String arg0) {
        return null;
    }

    public IStructureList getSelectOptions() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

