/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.generic;

import com.sap.tc.col.client.generic.api.IMessage;
import com.sap.tc.col.client.generic.api.IMessageList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MessageList
implements IMessageList {
    private List messages = null;
    private final MessageList parentList;
    private Set childLists = null;
    public static final IMessageList EMPTY_LIST = new IMessageList(){

        public void clear() {
        }

        public IMessage getMessage(int index) {
            throw new IndexOutOfBoundsException();
        }

        public boolean removeMessage(IMessage message) {
            return false;
        }

        public boolean isEmpty() {
            return true;
        }

        public int size() {
            return 0;
        }
    };

    public MessageList() {
        this(null);
    }

    public MessageList(MessageList parentList) {
        this.parentList = parentList;
        if (parentList != null) {
            parentList.addChildList(this);
        }
    }

    private void addChildList(MessageList childList) {
        if (this.childLists == null) {
            this.childLists = new HashSet();
        }
        this.childLists.add(childList);
    }

    public void clear() {
        this.clearR(0);
    }

    public IMessage getMessage(int index) {
        if (this.messages == null || index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return (IMessage)this.messages.get(index);
    }

    public boolean removeMessage(IMessage message) {
        return this.removeMessagesR(Collections.singletonList(message), 0);
    }

    private void clearR(int direction) {
        if (direction <= 0 && this.childLists != null) {
            Iterator it = this.childLists.iterator();
            while (it.hasNext()) {
                MessageList child = (MessageList)it.next();
                child.clearR(-1);
            }
        }
        if (direction >= 0 && this.parentList != null) {
            this.parentList.removeMessagesR(this.messages, 1);
        }
        if (this.messages != null) {
            this.messages.clear();
        }
    }

    private boolean removeMessagesR(List messages, int direction) {
        if (messages == null || messages.isEmpty()) {
            return false;
        }
        if (direction <= 0 && this.childLists != null) {
            Iterator it = this.childLists.iterator();
            while (it.hasNext()) {
                MessageList child = (MessageList)it.next();
                child.removeMessagesR(messages, -1);
            }
        }
        if (direction >= 0 && this.parentList != null) {
            this.parentList.removeMessagesR(messages, 1);
        }
        boolean result = false;
        if (this.messages != null) {
            result = this.messages.removeAll(messages);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.messages == null || this.messages.isEmpty();
    }

    public int size() {
        return this.messages == null ? 0 : this.messages.size();
    }

    public void addMessage(IMessage message) {
        if (this.messages == null) {
            this.messages = new ArrayList();
        }
        this.messages.add(message);
        if (this.parentList != null) {
            this.parentList.addMessage(message);
        }
    }

    public void copyMessagesFrom(MessageList source) {
        if (source.messages != null) {
            if (this.parentList != null && this.parentList != source.parentList) {
                Iterator i = source.messages.iterator();
                while (i.hasNext()) {
                    this.parentList.addMessage((IMessage)i.next());
                }
            }
            if (this.messages == null) {
                this.messages = new ArrayList(source.messages);
            } else {
                this.messages.addAll(source.messages);
            }
        }
    }

    public void transferMessagesFrom(MessageList source) {
        this.copyMessagesFrom(source);
        source.clearR(-1);
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer("<MessageList>").append(nl);
        for (int i = 0; i < this.size(); ++i) {
            buf.append("  ").append(this.getMessage(i)).append(nl);
        }
        buf.append("</MessageList>");
        return buf.toString();
    }
}

