/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.generic;

import com.sap.caf.rt.exception.CAFPermissionException;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.ui.cool.generic.Message;
import com.sap.caf.rt.ui.cool.generic.MessageList;
import com.sap.caf.rt.ui.cool.generic.ServiceModule;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.exception.IBaseException;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IMessage;
import com.sap.tc.col.client.generic.api.IMessageList;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.progmodel.api.IWDMessageManager;
import com.sap.tc.webdynpro.services.sal.localization.api.WDResourceHandler;
import java.util.Locale;

public class MessageFactory {
    private static final String APPLICATION = (class$com$sap$caf$rt$ui$cool$generic$MessageFactory == null ? (class$com$sap$caf$rt$ui$cool$generic$MessageFactory = MessageFactory.class$("com.sap.caf.rt.ui.cool.generic.MessageFactory")) : class$com$sap$caf$rt$ui$cool$generic$MessageFactory).getName();
    private static final String jARMRequest = "XAP:COOL:" + APPLICATION;
    private static final Location logger = Location.getLocation((String)APPLICATION);
    static /* synthetic */ Class class$com$sap$caf$rt$ui$cool$generic$MessageFactory;

    public static IMessage createAndRegisterMessageFromException(Throwable exception, IAspectRow row, String aspectFieldName) {
        return MessageFactory.createAndRegisterMessageFromException(exception, null, row, aspectFieldName, false);
    }

    public static IMessage createAndRegisterMessageFromException(Throwable exception, IQuery query, String aspectFieldName) {
        return MessageFactory.createAndRegisterMessageFromException(exception, MessageFactory.getQueryResultAspect(query), null, aspectFieldName, false);
    }

    public static IMessage createAndRegisterMessageFromException(Throwable exception, IQuery query, String aspectFieldName, boolean isSystem) {
        return MessageFactory.createAndRegisterMessageFromException(exception, MessageFactory.getQueryResultAspect(query), null, aspectFieldName, isSystem);
    }

    public static IMessage createAndRegisterMessageFromException(Throwable exception, IAspectRow row) {
        return MessageFactory.createAndRegisterMessageFromException(exception, row, null);
    }

    public static IMessage createAndRegisterMessageFromException(Throwable exception, IServiceFacade sf, boolean isSystem) {
        IMessage message = MessageFactory.createAndRegisterMessageFromException(exception, null, null, null, isSystem);
        MessageFactory.registerMessage(exception, null, null, sf, message);
        return message;
    }

    public static IMessage createAndRegisterMessageFromException(Throwable exception, IServiceFacade sf) {
        return MessageFactory.createAndRegisterMessageFromException(exception, sf, false);
    }

    public static IMessage createAndRegisterMessageFromException(Throwable exception, IAspect aspect) {
        IMessage message = MessageFactory.createAndRegisterMessageFromException(exception, aspect, null, null, false);
        return message;
    }

    public static IMessage createAndRegisterMessageFromException(Throwable exception, IAspect aspect, boolean isSystem) {
        IMessage message = MessageFactory.createAndRegisterMessageFromException(exception, aspect, null, null, isSystem);
        return message;
    }

    private static IAspect getQueryResultAspect(IQuery query) {
        IAspect aspect = query.getResultAspect();
        return aspect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static IMessage createAndRegisterMessageFromException(Throwable exception, IAspect aspect, IAspectRow row, String aspectFieldName, boolean isSystem) {
        String method = jARMRequest + ":createAndRegisterMessageFromException(Throwable, IAspect, IAspectRow, String, boolean)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        try {
            Message result;
            Throwable cause = exception;
            Throwable se = null;
            Throwable pe = null;
            while ((cause = cause.getCause()) != null) {
                if (cause instanceof ServiceException) {
                    se = cause;
                    continue;
                }
                if (se != null || !(cause instanceof CAFPermissionException)) continue;
                pe = cause;
            }
            if (se == null) {
                se = pe == null ? exception : pe;
            }
            boolean isOutOfBond = !(se instanceof ServiceException);
            isSystem = isSystem || se.getClass().getName().startsWith("java.lang.");
            String code = String.valueOf(se.hashCode());
            Locale current_locale = MessageFactory.getCurrentSessionLocale();
            String text = null;
            text = se instanceof IBaseException ? ((IBaseException)se).getLocalizedMessage(current_locale) : se.getLocalizedMessage();
            if (!(text != null && text.length() != 0 || (text = se.getMessage()) != null && text.length() != 0)) {
                text = "The following exception occured while processing your request: " + se.toString() + ".";
            }
            if (row != null || aspect != null) {
                result = new Message(2, code, text, null, isOutOfBond, true, aspectFieldName, isSystem, false, row);
                MessageFactory.registerMessage(se, aspect, row, null, result);
            } else if (aspect != null) {
                result = new Message(2, code, text, null, isOutOfBond, true, aspectFieldName, isSystem, false, aspect);
                MessageFactory.registerMessage(se, aspect, row, null, result);
            } else {
                result = new Message(2, code, text, null, isOutOfBond, true, aspectFieldName, isSystem, false, (IAspectRow)null);
            }
            Message message = result;
            return message;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    public static void registerMessage(Throwable exception, IServiceFacade sf, IMessage result) {
        MessageFactory.registerMessage(exception, null, null, sf, result);
    }

    public static void registerMessage(Throwable exception, IAspect aspect, IMessage result) {
        MessageFactory.registerMessage(exception, aspect, null, null, result);
    }

    public static void registerMessage(Throwable exception, IAspectRow row, IMessage result) {
        MessageFactory.registerMessage(exception, null, row, null, result);
    }

    public static void registerMessage(Throwable exception, IQuery query, IMessage result) {
        MessageFactory.registerMessage(exception, query.getResultAspect(), null, null, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerMessage(Throwable exception, IAspect aspect, IAspectRow row, IServiceFacade sf, IMessage result) {
        String method = jARMRequest + ":registerMessage(Throwable, IAspect, IAspectRow, IServiceFacade, IMessage)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger);
        try {
            if (sf == null) {
                IServiceModule sm = null;
                if (row != null) {
                    aspect = row.getAspect();
                }
                if (aspect != null) {
                    sm = aspect.getServiceModule();
                }
                if (sm instanceof ServiceModule) {
                    sf = ((ServiceModule)sm).getServiceFacade();
                }
            }
            if (row != null) {
                aspect = row.getAspect();
            }
            if (aspect != null) {
                IMessageList aspectMessages = aspect.getMessages();
                ((MessageList)aspectMessages).addMessage(result);
            } else {
                if (sf == null) {
                    throw new NullPointerException("IServiceFacade, IAspect or IAspectRow must be not null.");
                }
                MessageList mList = (MessageList)sf.getAllMessages();
                mList.addMessage(result);
            }
            if (result.getType() == 2) {
                logger.catching(exception);
            }
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reportOrRaiseCoolMessages(IMessageList list, IWDMessageManager manager, boolean stopOnFirstFail, boolean cancelNavigation, boolean raise) {
        boolean result = false;
        int size = list.size();
        try {
            for (int i = 0; i < size; ++i) {
                IMessage message = list.getMessage(i);
                switch (message.getType()) {
                    case 2: {
                        if (raise) {
                            manager.raiseException(message.getText(), cancelNavigation);
                            break;
                        }
                        manager.reportException(message.getText(), cancelNavigation);
                        break;
                    }
                    case 1: {
                        manager.reportWarning(message.getText());
                        break;
                    }
                    case 0: {
                        manager.reportSuccess(message.getText());
                        break;
                    }
                    default: {
                        if (raise) {
                            manager.raiseException("Unknown type of message has been recieved from <cool>. Message type: " + message.getType() + ", message text: " + message.getText(), true);
                            break;
                        }
                        manager.reportException("Unknown type of message has been recieved from <cool>. Message type: " + message.getType() + ", message text: " + message.getText(), true);
                    }
                }
                if (!message.isFailed()) continue;
                result = true;
                if (!stopOnFirstFail) continue;
                break;
            }
        }
        finally {
            list.clear();
        }
        return result;
    }

    protected static Locale getCurrentSessionLocale() {
        Locale locale = WDResourceHandler.getCurrentSessionLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

