/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.generic;

import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IMessage;
import com.sap.tc.col.servicemanager.api.ISrvMgrMessage;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

class Message
implements IMessage {
    private Reference m_aspectRow;
    private String m_aspectName;
    private int m_type;
    private String m_code;
    private String m_text;
    private Object m_extention;
    private String m_aspectFieldName;
    private boolean m_isOutOfBound;
    private boolean m_isFailed;
    private boolean m_isSystemMessage;
    private boolean m_isSystemConfirmation;

    public Message(ISrvMgrMessage msg) {
        this(msg.getType(), msg.getCode(), msg.getText(), msg.getExtension(), msg.isOutbound(), msg.isFailed(), msg.getAspectField(), false, false, msg.getAspectName());
    }

    public Message(int type, String code, String text, Object extention, boolean isOutOfBound, boolean isFailed, String aspectFieldName, boolean isSystemMessage, boolean isSystemConfirmation, IAspectRow aspectRow) {
        this.m_aspectRow = new WeakReference<IAspectRow>(aspectRow);
        this.m_type = type;
        this.m_code = code;
        this.m_text = text;
        this.m_extention = extention;
        this.m_aspectFieldName = aspectFieldName;
        this.m_isOutOfBound = isOutOfBound;
        this.m_isFailed = isFailed;
        this.m_isSystemMessage = isSystemMessage;
        this.m_isSystemConfirmation = isSystemConfirmation;
    }

    public Message(int type, String code, String text, Object extention, boolean isOutOfBound, boolean isFailed, String aspectFieldName, boolean isSystemMessage, boolean isSystemConfirmation, IAspect aspect) {
        this(type, code, text, extention, isOutOfBound, isFailed, null, isSystemMessage, isSystemConfirmation, (IAspectRow)null);
        this.m_aspectName = aspect.getDescriptor().getName();
    }

    public Message(int type, String code, String text, Object extention, boolean isOutOfBound, boolean isFailed, String aspectFieldName, boolean isSystemMessage, boolean isSystemConfirmation, String aspectName) {
        this(type, code, text, extention, isOutOfBound, isFailed, null, isSystemMessage, isSystemConfirmation, (IAspectRow)null);
        this.m_aspectName = aspectName;
    }

    public Message(int type, String text, boolean isFailed, String aspectFieldName, IAspectRow aspectRow) {
        this(type, null, text, null, false, isFailed, aspectFieldName, false, false, aspectRow);
    }

    public Message(int type, String text, String aspectFieldName, IAspectRow aspectRow) {
        this(type, null, text, null, false, type == 2, aspectFieldName, false, false, aspectRow);
    }

    public Message(int type, String text) {
        this(type, null, text, null, false, type == 2, null, false, false, (IAspectRow)null);
    }

    public Message(int type, String code, String text, Object extention, boolean isOutOfBound, boolean isFailed, boolean isSystemMessage, boolean isSystemConfirmation) {
        this(type, code, text, extention, isOutOfBound, isFailed, null, isSystemMessage, isSystemConfirmation, (IAspectRow)null);
    }

    public int getType() {
        return this.m_type;
    }

    public boolean isInfo() {
        return this.getType() == 0;
    }

    public boolean isWarning() {
        return this.getType() == 1;
    }

    public boolean isError() {
        return this.getType() == 2;
    }

    public boolean isFailed() {
        return this.m_isFailed;
    }

    public String getCode() {
        return this.m_code;
    }

    public String getText() {
        return this.m_text;
    }

    public Object getExtension() {
        return this.m_extention;
    }

    public boolean isOutbound() {
        return this.isOutOfBand();
    }

    public boolean isOutOfBand() {
        return this.m_isOutOfBound;
    }

    public IAspectRow getAspectRow() {
        return (IAspectRow)this.m_aspectRow.get();
    }

    public String getAspectFieldName() {
        return this.m_aspectFieldName;
    }

    public IKey getAspectRowKey() {
        IAspectRow ar = (IAspectRow)this.m_aspectRow.get();
        if (ar != null) {
            return ar.getKey();
        }
        return null;
    }

    public String[] getVars() {
        return new String[]{String.valueOf(this.getType()), this.getCode(), String.valueOf(this.getExtension()), String.valueOf(this.isOutOfBand()), String.valueOf(this.isFailed()), this.getAspectFieldName(), String.valueOf(this.isSystemMessage()), String.valueOf(this.isSystemMessageConfirm())};
    }

    private String typeToString() {
        switch (this.getType()) {
            case 0: {
                return "Info";
            }
            case 1: {
                return "Warning";
            }
            case 2: {
                return "Error";
            }
        }
        return "Undefined";
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("<Message");
        buf.append(" type=\"").append(this.typeToString()).append("\"");
        buf.append(" aspectRowKey=\"");
        if (this.getAspectRowKey() != null) {
            buf.append(this.getAspectRowKey());
        }
        buf.append("\"");
        buf.append(" text=\"").append(this.getText()).append("\"");
        buf.append(" field=\"").append(this.getAspectFieldName()).append("\"");
        buf.append(" />");
        return buf.toString();
    }

    public String getAspectName() {
        IAspectRow ar = this.getAspectRow();
        if (ar != null) {
            return ar.getDescriptor().getName();
        }
        return this.m_aspectFieldName;
    }

    public boolean isAspectRowMessage() {
        return this.getAspectRow() != null;
    }

    public boolean isSystemMessage() {
        return false;
    }

    public boolean isSystemMessageConfirm() {
        return false;
    }
}

