/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.generic;

import com.sap.caf.rt.services.serviceaccess.SimpleDataContainer;
import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.caf.rt.ui.cool.generic.EdoAbstractValue;
import com.sap.caf.rt.ui.cool.generic.EdoStructure;
import com.sap.caf.rt.ui.cool.generic.IEdoTableEx;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoReadStream;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.edo.IEdoVariant;
import com.sap.tc.col.edo.IEdoWriteStream;
import com.sap.tc.col.edo.core.EdoVariant;
import com.sap.tc.col.edo.core.TypeHelper;
import com.sap.tc.logging.Location;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;

public final class EdoTable
extends EdoAbstractValue
implements IEdoTableEx {
    private static final String APPLICATION = (class$com$sap$caf$rt$ui$cool$generic$EdoTable == null ? (class$com$sap$caf$rt$ui$cool$generic$EdoTable = EdoTable.class$("com.sap.caf.rt.ui.cool.generic.EdoTable")) : class$com$sap$caf$rt$ui$cool$generic$EdoTable).getName();
    private static final Location logger = Location.getLocation((String)APPLICATION);
    static int NO_OF_EXTRA_FIELDS = 1;
    static int FIELD_OFFSET_RECORD = 0;
    protected final IStructureDescriptor m_descriptor;
    protected final ArrayList m_table;
    protected final int m_fieldCount;
    protected static final int[] empty_fieldsThatNeedDeepCopy = new int[0];
    protected int[] m_fieldsThatNeedDeepCopy;
    public static final int RESET_INDEX = -1;
    static /* synthetic */ Class class$com$sap$caf$rt$ui$cool$generic$EdoTable;

    public EdoTable(IStructureDescriptor descriptor, int capacity) {
        this.m_descriptor = descriptor;
        this.m_fieldCount = descriptor.size();
        this.m_table = new ArrayList(capacity);
    }

    private EdoTable(EdoTable table) {
        this.m_descriptor = table.m_descriptor;
        this.m_fieldCount = table.m_fieldCount;
        this.m_fieldsThatNeedDeepCopy = table.m_fieldsThatNeedDeepCopy;
        this.m_table = new ArrayList(table.m_table.size());
        table.append(table, 0, table.m_table.size());
    }

    public EdoTable(IStructureDescriptor descriptor) {
        this.m_descriptor = descriptor;
        this.m_fieldCount = descriptor.size();
        this.m_table = new ArrayList();
    }

    public String getMeta() {
        return "T";
    }

    public String getType() {
        return this.m_descriptor.getName();
    }

    public IStructureDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    public int getFieldCount() {
        return this.m_descriptor.size();
    }

    public int getRecordCount() {
        return this.m_table.size();
    }

    public void clear() {
        this.m_table.clear();
    }

    public Iterator getRecordIterator() {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public IEdoStructure getRecord(int recordIndex) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public IDataContainerBean getRecordDataBean(int recordIndex) {
        IDataContainerBean record = (IDataContainerBean)this.m_table.get(recordIndex);
        return record;
    }

    public boolean isInitial(int recordIndex, String fieldName) {
        return this.isInitial(recordIndex, this.getFieldIndex(fieldName));
    }

    public final boolean isInitial(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        return this.getValueInternal(recordIndex, fieldIndex) == null;
    }

    public Object getValue(int recordIndex, String fieldName) {
        return this.getValue(recordIndex, this.getFieldIndex(fieldName));
    }

    public final Object getValue(int recordIndex, int fieldIndex) {
        String type = this.getFieldType(fieldIndex);
        if (type.equals("VARIANT")) {
            return this.getVariantValue(recordIndex, fieldIndex);
        }
        if (type.equals("TIMESTAMP")) {
            java.util.Date d = (java.util.Date)this.getValueInternal(recordIndex, fieldIndex);
            if (d != null && !(d instanceof Timestamp)) {
                return new Timestamp(d.getTime());
            }
            return d;
        }
        return this.getValueInternal(recordIndex, fieldIndex);
    }

    public void setValue(int recordIndex, String fieldName, Object value) {
        this.setValue(recordIndex, this.getFieldIndex(fieldName), value);
    }

    public final void setValue(int recordIndex, int fieldIndex, Object value) {
        String type = this.getFieldType(fieldIndex);
        if (type.equals("VARIANT")) {
            throw new NoSuchMethodError("Method setValue() is not supported for variants.");
        }
        if (value instanceof Long) {
            this.checkRecordIndex(recordIndex);
            this.checkFieldIndex(fieldIndex);
            this.setValueInternal(recordIndex, fieldIndex, value);
        } else {
            this.checkRecordIndex(recordIndex);
            this.checkFieldIndex(fieldIndex);
            this.checkFieldType(fieldIndex, type);
            String str = TypeHelper.getType((String)type).format(value);
            Object obj = TypeHelper.getType((String)type).parse(str);
            if ("STRING".equals(type) && "".equals(obj)) {
                obj = null;
            }
            this.setValueInternal(recordIndex, fieldIndex, obj);
        }
    }

    public final void setValue(int index, IDataContainerBean data) {
        IFieldDescriptor[] fields = this.m_descriptor.getFieldDescriptors();
        for (int i = 0; i < fields.length; ++i) {
            try {
                Object value;
                String fieldType = fields[i].getType();
                String fieldName = fields[i].getName();
                if (!"STRING".equals(fieldType)) {
                    value = data.getProperty(fieldName);
                    if (value instanceof Long) {
                        data.setProperty(fieldName, value);
                        continue;
                    }
                    TypeHelper.Type type = TypeHelper.getType((String)fieldType);
                    String str = type.format(value);
                    Object parsedObj = type.parse(str);
                    data.setProperty(fieldName, parsedObj);
                    continue;
                }
                value = data.getProperty(fieldName);
                if (!"".equals(value)) continue;
                data.setProperty(fieldName, null);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (index < this.m_table.size()) {
            this.m_table.set(index, data);
        } else {
            this.m_table.add(data);
        }
    }

    public Object getValue(int recordIndex, String fieldName, boolean createIfNull) {
        return this.getValue(recordIndex, this.getFieldIndex(fieldName), createIfNull);
    }

    public final Object getValue(int recordIndex, int fieldIndex, boolean createIfNull) {
        String type = this.getFieldType(fieldIndex);
        if (type.equals("VARIANT")) {
            return this.getVariantValue(recordIndex, fieldIndex, createIfNull);
        }
        if (type.equals("TIMESTAMP")) {
            java.util.Date d = (java.util.Date)this.getValueInternal(recordIndex, fieldIndex);
            if (d != null && !(d instanceof Timestamp)) {
                return new Timestamp(d.getTime());
            }
            return d;
        }
        return this.getValueInternal(recordIndex, fieldIndex);
    }

    public final String getStringValue(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "STRING");
        try {
            Object value = this.getValueInternal(recordIndex, fieldIndex);
            return value != null ? value.toString() : "";
        }
        catch (Exception e) {
            logger.catching((Throwable)e);
            return "";
        }
    }

    public String getStringValue(int recordIndex, String fieldname) {
        Object value = this.getValueInternal(recordIndex, this.getFieldIndex(fieldname));
        return value != null ? value.toString() : "";
    }

    public final void setStringValue(int recordIndex, int fieldIndex, String value) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "STRING");
        this.setValueInternal(recordIndex, fieldIndex, value);
    }

    public void setStringValue(int recordIndex, String fieldname, String value) {
        this.checkRecordIndex(recordIndex);
        this.setValueInternal(recordIndex, this.getFieldIndex(fieldname), value);
    }

    public int getIntValue(int recordIndex, String fieldName) {
        return this.getIntValue(recordIndex, this.getFieldIndex(fieldName));
    }

    public void setIntValue(int recordIndex, String fieldName, int value) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public final int getIntValue(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "INTEGER");
        return TypeHelper.getType((String)"INTEGER").parseInt(this.getStringValue(recordIndex, fieldIndex));
    }

    public final void setIntValue(int recordIndex, int fieldIndex, int value) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public boolean getBooleanValue(int recordIndex, String fieldName) {
        return this.getBooleanValue(recordIndex, this.getFieldIndex(fieldName));
    }

    public void setBooleanValue(int recordIndex, String fieldName, boolean value) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public final boolean getBooleanValue(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "BOOLEAN");
        return TypeHelper.getType((String)"BOOLEAN").parseBoolean(this.getStringValue(recordIndex, fieldIndex));
    }

    public final void setBooleanValue(int recordIndex, int fieldIndex, boolean value) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public double getDoubleValue(int recordIndex, String fieldName) {
        return this.getDoubleValue(recordIndex, this.getFieldIndex(fieldName));
    }

    public void setDoubleValue(int recordIndex, String fieldName, double value) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public final double getDoubleValue(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "DOUBLE");
        return TypeHelper.getType((String)"DOUBLE").parseDouble(this.getStringValue(recordIndex, fieldIndex));
    }

    public final void setDoubleValue(int recordIndex, int fieldIndex, double value) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public Date getDateValue(int recordIndex, String fieldName) {
        return this.getDateValue(recordIndex, this.getFieldIndex(fieldName));
    }

    public void setDateValue(int recordIndex, String fieldName, Date value) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public final Date getDateValue(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "DATE");
        return (Date)TypeHelper.parse((String)this.getStringValue(recordIndex, fieldIndex), (String)"DATE");
    }

    public final void setDateValue(int recordIndex, int fieldIndex, Date value) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public Time getTimeValue(int recordIndex, String fieldName) {
        return this.getTimeValue(recordIndex, this.getFieldIndex(fieldName));
    }

    public void setTimeValue(int recordIndex, String fieldName, Time value) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public final Time getTimeValue(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "TIME");
        return (Time)TypeHelper.parse((String)this.getStringValue(recordIndex, fieldIndex), (String)"TIME");
    }

    public final void setTimeValue(int recordIndex, int fieldIndex, Time value) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public BigDecimal getDecimalValue(int recordIndex, String fieldName) {
        return this.getDecimalValue(recordIndex, this.getFieldIndex(fieldName));
    }

    public void setDecimalValue(int recordIndex, String fieldName, BigDecimal value) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public final BigDecimal getDecimalValue(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "DECIMAL");
        return (BigDecimal)TypeHelper.parse((String)this.getStringValue(recordIndex, fieldIndex), (String)"DECIMAL");
    }

    public final void setDecimalValue(int recordIndex, int fieldIndex, BigDecimal value) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public Timestamp getTimestampValue(int recordIndex, String fieldName) {
        return this.getTimestampValue(recordIndex, this.getFieldIndex(fieldName));
    }

    public void setTimestampValue(int recordIndex, String fieldName, Timestamp value) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public final Timestamp getTimestampValue(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "TIMESTAMP");
        return (Timestamp)TypeHelper.parse((String)this.getStringValue(recordIndex, fieldIndex), (String)"TIMESTAMP");
    }

    public final void setTimestampValue(int recordIndex, int fieldIndex, Timestamp value) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public byte[] getBinaryValue(int recordIndex, String fieldName) {
        return this.getBinaryValue(recordIndex, this.getFieldIndex(fieldName));
    }

    public void setBinaryValue(int recordIndex, String fieldName, byte[] value) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public final byte[] getBinaryValue(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "BINARY");
        return (byte[])TypeHelper.parse((String)this.getStringValue(recordIndex, fieldIndex), (String)"BINARY");
    }

    public final void setBinaryValue(int recordIndex, int fieldIndex, byte[] value) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public final IEdoVariant getVariantValue(int recordIndex, int fieldIndex) {
        this.checkRecordIndex(recordIndex);
        this.checkFieldIndex(fieldIndex);
        this.checkFieldType(fieldIndex, "VARIANT");
        Object value = this.getValueInternal(recordIndex, fieldIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof IEdoVariant) {
            return (IEdoVariant)value;
        }
        IFieldDescriptor fieldDescriptor = this.m_descriptor.getFieldDescriptor(fieldIndex);
        IEdoVariant variant = EdoVariant.convertXMLToVariant((IFieldDescriptor)fieldDescriptor, (String)((String)value));
        this.setValueInternal(recordIndex, fieldIndex, variant);
        return variant;
    }

    public IEdoVariant getVariantValue(int recordIndex, String fieldname) {
        return this.getVariantValue(recordIndex, this.getFieldIndex(fieldname));
    }

    public final IEdoVariant getVariantValue(int recordIndex, int fieldIndex, boolean createIfNull) {
        IEdoVariant value = this.getVariantValue(recordIndex, fieldIndex);
        if (value == null && createIfNull) {
            return this.newVariantValueInternal(recordIndex, fieldIndex);
        }
        return value;
    }

    public IEdoVariant getVariantValue(int recordIndex, String fieldname, boolean createIfNull) {
        return this.getVariantValue(recordIndex, this.getFieldIndex(fieldname), createIfNull);
    }

    public int append(int count) {
        int retValue = this.m_table.size();
        while (count > 0) {
            this.m_table.add(this.newRecord());
            --count;
        }
        return retValue;
    }

    public int append(IEdoStructure source) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    public int append(IEdoTable source, int sourceIndex, int count) {
        ArrayList sTable = ((EdoTable)source).m_table;
        this.checkDescriptor(source.getDescriptor());
        int retValue = this.m_table.size();
        this.m_table.ensureCapacity(retValue + count);
        int endIndex = sourceIndex + count;
        while (sourceIndex < endIndex) {
            this.m_table.add(this.newRecord(sTable.get(sourceIndex)));
            ++sourceIndex;
        }
        return retValue;
    }

    public void setRecord(int recordIndex, IEdoStructure source) {
        this.checkRecordIndex(recordIndex);
        this.checkDescriptor(source.getDescriptor());
        this.copyRecord(((EdoStructure)source).m_record, this.m_table.get(recordIndex));
    }

    public void getRecord(int recordIndex, IEdoStructure destination) {
        this.checkRecordIndex(recordIndex);
        this.checkDescriptor(destination.getDescriptor());
        this.copyRecord(this.m_table.get(recordIndex), ((EdoStructure)destination).m_record);
    }

    public void getTable(int[] recordIndices, IEdoTable destination) {
        int len = recordIndices.length;
        EdoTable d = (EdoTable)destination;
        this.checkDescriptor(d.m_descriptor);
        ArrayList dTable = d.m_table;
        dTable.ensureCapacity(dTable.size() + len);
        for (int i = 0; i < len; ++i) {
            int srcRecordIndex = recordIndices[i];
            this.checkRecordIndex(srcRecordIndex);
            dTable.add(this.newRecord(this.m_table.get(srcRecordIndex)));
        }
    }

    public void setTable(int[] recordIndices, IEdoTable source, int startIndex) {
        int len = recordIndices.length;
        EdoTable s = (EdoTable)source;
        this.checkDescriptor(s.m_descriptor);
        s.checkRecordIndex(startIndex + len - 1);
        ArrayList sTable = s.m_table;
        int i = 0;
        int srcRecordIndex = startIndex;
        while (i < len) {
            int destRecordIndex = recordIndices[i];
            this.checkRecordIndex(destRecordIndex);
            this.copyRecord(sTable.get(srcRecordIndex), this.m_table.get(destRecordIndex));
            ++i;
            ++srcRecordIndex;
        }
    }

    public void insertAt(int index, int count) {
        if (index == this.m_table.size()) {
            this.append(count);
        } else {
            this.checkRecordIndex(index);
            ArrayList<Object> tempList = new ArrayList<Object>(count);
            while (count > 0) {
                tempList.add(this.newRecord());
                --count;
            }
            this.m_table.addAll(index, tempList);
        }
    }

    public int insertAt(int index, IEdoStructure source) {
        EdoStructure sRecord = (EdoStructure)source;
        this.checkDescriptor(source.getDescriptor());
        int retValue = this.m_table.size();
        this.m_table.add(index, this.newRecord(sRecord.m_record));
        return retValue;
    }

    public void insertAt(int index, IEdoTable source, int sourceIndex, int count) {
        if (index == this.m_table.size()) {
            this.append(source, sourceIndex, count);
        } else {
            this.checkRecordIndex(index);
            this.checkDescriptor(source.getDescriptor());
            ArrayList sTable = ((EdoTable)source).m_table;
            ArrayList<Object[]> tempList = new ArrayList<Object[]>(count);
            int endIndex = sourceIndex + count;
            while (sourceIndex < endIndex) {
                tempList.add(this.newRecord(sTable.get(sourceIndex)));
                ++sourceIndex;
            }
            this.m_table.addAll(index, tempList);
        }
    }

    public void deleteFrom(int index) {
        this.checkRecordIndex(index);
        this.m_table.remove(index);
    }

    public void deleteFrom(int startIndex, int count) {
        this.checkRecordIndex(startIndex + count - 1);
        this.m_table.subList(startIndex, startIndex + count).clear();
    }

    public void readFrom(IEdoReadStream readStream) {
        readStream.read((IEdoTable)this);
    }

    public void writeTo(IEdoWriteStream writeStream) {
        writeStream.write((IEdoTable)this);
    }

    final int getRecordCountInternal() {
        return this.m_table.size();
    }

    final Object getValueInternal(int recordIndex, int fieldIndex) {
        IDataContainerBean data = (IDataContainerBean)this.m_table.get(recordIndex);
        if (data != null) {
            return data.getProperty(this.m_descriptor.getFieldDescriptor(fieldIndex).getName());
        }
        return null;
    }

    final void setValueInternal(int recordIndex, int fieldIndex, Object value) {
        IDataContainerBean data = (IDataContainerBean)this.m_table.get(recordIndex);
        data.setProperty(this.m_descriptor.getFieldDescriptor(fieldIndex).getName(), value);
    }

    final EdoVariant newVariantValueInternal(int recordIndex, int fieldIndex) {
        EdoVariant value = new EdoVariant(this.m_descriptor.getFieldDescriptor(fieldIndex));
        this.setValueInternal(recordIndex, fieldIndex, value);
        return value;
    }

    final void clearInternal() {
        this.m_table.clear();
    }

    final void appendInternal() {
        this.m_table.add(this.newRecord());
    }

    final EdoStructure getRow(Object[] record) {
        throw new UnsupportedOperationException("This operation is not supported");
    }

    EdoAbstractValue deepCopy() {
        return new EdoTable(this);
    }

    private int getFieldIndex(String fieldname) {
        int fieldIndex = this.m_descriptor.getFieldIndex(fieldname);
        if (0 > fieldIndex) {
            throw new IllegalArgumentException("Field name '" + fieldname + "' not found in structure '" + this.m_descriptor.getName() + "'.");
        }
        return fieldIndex;
    }

    private void checkRecordIndex(int recordIndex) {
        if (recordIndex < 0 || recordIndex >= this.m_table.size()) {
            throw new IndexOutOfBoundsException("Record index " + recordIndex + " out of range. Should be >= 0 and < " + this.m_table.size());
        }
    }

    private void checkFieldIndex(int fieldIndex) {
        if (fieldIndex < 0 || fieldIndex >= this.m_fieldCount) {
            throw new IndexOutOfBoundsException("Field index " + fieldIndex + " out of range. Should be >= 0 and < " + this.m_fieldCount);
        }
    }

    private void checkDescriptor(IStructureDescriptor descriptor) {
        if (!this.m_descriptor.equals(descriptor)) {
            throw new IllegalArgumentException("Different Structure type: expected '" + this.m_descriptor.getName() + "' found '" + descriptor.getName() + "'.");
        }
    }

    private Object newRecord() {
        SimpleDataContainer data = new SimpleDataContainer();
        IFieldDescriptor[] fields = this.m_descriptor.getFieldDescriptors();
        for (int i = 0; i < fields.length; ++i) {
            try {
                if ("STRING".equals(fields[i].getType())) continue;
                TypeHelper.Type type = TypeHelper.getType((String)fields[i].getType());
                Object value = data.getProperty(fields[i].getName());
                String str = type.format(value);
                Object parsedObj = type.parse(str);
                data.setProperty(fields[i].getName(), parsedObj);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return data;
    }

    private Object[] newRecord(Object[] src) {
        Object[] newRecord = new Object[this.m_fieldCount + NO_OF_EXTRA_FIELDS];
        this.copyRecord(src, newRecord);
        return newRecord;
    }

    private Object[] newRecord(Object src) {
        Object[] newRecord = new Object[this.m_fieldCount + NO_OF_EXTRA_FIELDS];
        this.copyRecord(src, newRecord);
        return newRecord;
    }

    private void copyRecord(Object src, Object dest) {
        System.arraycopy(src, 0, dest, 0, this.m_fieldCount);
        this.deepCopyFieldsThatNeedDeepCopy((Object[])dest);
    }

    private void deepCopyFieldsThatNeedDeepCopy(Object[] record) {
        if (this.m_fieldsThatNeedDeepCopy == empty_fieldsThatNeedDeepCopy) {
            return;
        }
        if (this.m_fieldsThatNeedDeepCopy == null) {
            this.m_fieldsThatNeedDeepCopy = EdoTable.getFieldsThatNeedDeepCopy(this.m_descriptor);
            if (this.m_fieldsThatNeedDeepCopy.length == 0) {
                this.m_fieldsThatNeedDeepCopy = empty_fieldsThatNeedDeepCopy;
                return;
            }
        }
        int len = this.m_fieldsThatNeedDeepCopy.length;
        for (int i = 0; i < len; ++i) {
            int index = this.m_fieldsThatNeedDeepCopy[i];
            EdoAbstractValue value = (EdoAbstractValue)record[index];
            if (value == null) continue;
            record[index] = value.deepCopy();
        }
    }

    private void checkFieldType(int fieldIndex, String type) {
        boolean typeInvalid = false;
        IFieldDescriptor fieldDescriptor = this.m_descriptor.getFieldDescriptor(fieldIndex);
        if (type.equals("VARIANT") && !type.equals(fieldDescriptor.getType())) {
            typeInvalid = true;
        } else if (type.equals("STRING") && fieldDescriptor.getType().equals("VARIANT")) {
            typeInvalid = true;
        }
        if (typeInvalid) {
            throw new IllegalArgumentException("Different Field type : expected '" + type + "' found '" + fieldDescriptor.getType() + "'.");
        }
    }

    private String getFieldType(int fieldIndex) {
        IFieldDescriptor fieldDescriptor = this.m_descriptor.getFieldDescriptor(fieldIndex);
        return fieldDescriptor.getType();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

