/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.generic;

import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.EdoIllegalArgumentException;
import com.sap.tc.col.edo.IEdoReadStream;
import com.sap.tc.col.edo.IEdoValue;
import com.sap.tc.col.edo.IEdoWriteStream;
import java.util.HashMap;

public abstract class EdoAbstractValue
implements IEdoValue {
    public static final int RESET_INDEX = -1;
    private int m_valueIndex = -1;
    private HashMap m_properties = null;

    public int getIndex() {
        return this.m_valueIndex;
    }

    public void setIndex(int index) {
        this.m_valueIndex = index;
    }

    public void createSlot(String name) {
        if (this.m_properties != null) {
            this.m_properties = new HashMap();
        }
        if (this.m_properties.containsKey(name)) {
            throw new EdoIllegalArgumentException(this.getClass().getName(), "createProperty", "name", (Object)name, "property exists");
        }
        this.m_properties.put(name, null);
    }

    public Object getSlot(String name) {
        if (this.m_properties == null || !this.m_properties.containsKey(name)) {
            throw new EdoIllegalArgumentException(this.getClass().getName(), "getProperty", "name", (Object)name, "property does not exist");
        }
        return this.m_properties.get(name);
    }

    public Object setSlot(String name, Object value) {
        if (this.m_properties == null || !this.m_properties.containsKey(name)) {
            throw new EdoIllegalArgumentException(this.getClass().getName(), "setProperty", "name", (Object)name, "property does not exist");
        }
        return this.m_properties.put(name, value);
    }

    public void removeSlot(String name) {
        if (this.m_properties == null || !this.m_properties.containsKey(name)) {
            throw new EdoIllegalArgumentException(this.getClass().getName(), "removeProperty", "name", (Object)name, "property does not exist");
        }
        this.m_properties.remove(name);
    }

    public boolean existsSlot(String name) {
        return this.m_properties != null && this.m_properties.containsKey(name);
    }

    EdoAbstractValue deepCopy() {
        throw new NoSuchMethodError("Method deepCopy() is not supported.");
    }

    public abstract void readFrom(IEdoReadStream var1);

    public abstract void writeTo(IEdoWriteStream var1);

    public abstract void clear();

    public abstract String getMeta();

    public abstract String getType();

    public static int[] getCorrespondingIndices(IStructureDescriptor one, IStructureDescriptor two) {
        int twoSize;
        int oneSize = one.size();
        int[] indices = new int[3 * (oneSize <= (twoSize = two.size()) ? twoSize : oneSize)];
        int len = 0;
        for (int oneIndex = 0; oneIndex < oneSize; ++oneIndex) {
            IFieldDescriptor oneFD = one.getFieldDescriptor(oneIndex);
            int twoIndex = two.getFieldIndex(oneFD.getName());
            if (twoIndex < 0 || !oneFD.getType().equals(two.getFieldDescriptor(twoIndex).getType())) continue;
            indices[len] = oneIndex;
            indices[len + 1] = twoIndex;
            indices[len + 2] = EdoAbstractValue.needsDeepCopy(oneFD) ? 1 : 0;
            len += 3;
        }
        int[] retValue = new int[len];
        System.arraycopy(indices, 0, retValue, 0, len);
        return retValue;
    }

    public static int[] getFieldsThatNeedDeepCopy(IStructureDescriptor desc) {
        int[] indices = new int[desc.size()];
        int count = 0;
        int len = desc.size();
        for (int i = 0; i < len; ++i) {
            if (!EdoAbstractValue.needsDeepCopy(desc.getFieldDescriptor(i))) continue;
            indices[count++] = i;
        }
        int[] retValue = new int[count];
        System.arraycopy(indices, 0, retValue, 0, count);
        return retValue;
    }

    private static boolean needsDeepCopy(IFieldDescriptor fd) {
        return "VARIANT" == fd.getType();
    }
}

