/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.generic;

import com.sap.caf.rt.services.serviceaccess.CAFServiceAccessHome;
import com.sap.caf.rt.services.serviceaccess.CAFServiceAccessLocalHome;
import com.sap.caf.rt.services.serviceaccess.ICAFServiceAccess;
import com.sap.caf.rt.ui.cool.generic.Aspect;
import com.sap.caf.rt.ui.cool.generic.AspectServiceAccess;
import com.sap.caf.rt.ui.cool.generic.CAFRepositoryManager;
import com.sap.caf.rt.ui.cool.generic.MessageFactory;
import com.sap.caf.rt.ui.cool.generic.ServiceFacadeFactory;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.servicemanager.api.ICoolObjectKey;
import com.sap.tc.col.servicemanager.api.ISrvMgrCallbackOnFlush;
import com.sap.tc.col.servicemanager.api.ISrvMgrMessage;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrCall;
import com.sap.tc.col.servicemanager.core.calls.AbstractCall;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.clientserver.cal.ClientComponent;
import com.sap.tc.webdynpro.progmodel.api.IWDMessageManager;
import com.sap.tc.webdynpro.services.cal.core.IUpdateServerPeerData;
import com.sap.tc.webdynpro.services.session.IApplication;
import com.sap.tc.webdynpro.services.session.IComponent;
import com.sap.tc.webdynpro.services.session.IMaintainScope;
import com.sap.tc.webdynpro.services.session.IPhaseListener;
import com.sap.tc.webdynpro.services.session.IScope;
import com.sap.tc.webdynpro.services.session.IScopeListener;
import com.sap.tc.webdynpro.services.session.ScopeType;
import com.sap.tc.webdynpro.services.session.Utils;
import com.sap.tc.webdynpro.services.task.ITask;
import com.sap.tc.webdynpro.services.task.TaskBinder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

public class CAFServiceManager
implements ISrvMgrServiceManager {
    public static final String CAF_ACCESS_JNDI_REMOTE_KEY = "sap.com/caf.runtime/CAFServiceAccess";
    public static final String CAF_ACCESS_JNDI_LOCAL_KEY = "localejbs/sap.com/caf.runtime/CAFServiceAccess";
    ISrvMgrCallbackOnFlush mCallbackOnFlush;
    boolean mToSave;
    String mTransactionID;
    ArrayList mCallList;
    boolean synchronous = false;
    HashMap smList;
    CAFRepositoryManager smRepository;
    ICAFServiceAccess access;
    Map descriptors;
    Map proxies;
    Locale mLocale;
    protected List systemMessages = new ArrayList(5);
    private static final String APPLICATION = (class$com$sap$caf$rt$ui$cool$generic$CAFServiceManager == null ? (class$com$sap$caf$rt$ui$cool$generic$CAFServiceManager = CAFServiceManager.class$("com.sap.caf.rt.ui.cool.generic.CAFServiceManager")) : class$com$sap$caf$rt$ui$cool$generic$CAFServiceManager).getName();
    private static final String jARMRequest = "XAP:COOL:" + APPLICATION;
    private static final Location logger = Location.getLocation((String)APPLICATION);
    private static final ISrvMgrMessage[] EMPTY_MESSAGES_ARRAY = new ISrvMgrMessage[0];
    private String TASK_SCOPE_LISTENER_PARAMETER = "TASK_SCOPE_LISTENER";
    static /* synthetic */ Class class$com$sap$caf$rt$ui$cool$generic$CAFServiceManager;
    static /* synthetic */ Class class$com$sap$caf$rt$services$serviceaccess$CAFServiceAccessHome;
    static /* synthetic */ Class class$com$sap$caf$rt$services$serviceaccess$CAFServiceAccessLocalHome;

    public CAFServiceManager() {
        this(Locale.getDefault());
    }

    public CAFServiceManager(Locale locale) {
        this.mCallList = new ArrayList();
        this.smList = new HashMap();
        this.setLocale(locale);
        this.proxies = new HashMap();
        this.descriptors = new HashMap();
    }

    public CAFServiceManager(Hashtable connection_properties, Locale locale) {
        this.mCallList = new ArrayList();
        this.smList = new HashMap();
        this.setLocale(locale);
        this.proxies = new HashMap();
        this.descriptors = new HashMap();
        this.init(connection_properties);
    }

    protected void init(Hashtable properties) {
        IScope scope;
        String coolURL = null;
        if (properties != null) {
            coolURL = (String)properties.get("java.naming.provider.url");
        }
        if (coolURL == null || "".equals(coolURL)) {
            this.lookupLocal(null);
        } else {
            this.lookupRemote(properties);
        }
        if (this.access != null && (scope = Utils.getScope((ScopeType)IScope.TASK_SCOPE)) != null) {
            if (coolURL == null || "".equals(coolURL)) {
                scope.put((Object)CAF_ACCESS_JNDI_LOCAL_KEY, (Object)this.access);
            } else {
                scope.put((Object)CAF_ACCESS_JNDI_REMOTE_KEY, (Object)this.access);
            }
            ITask task = TaskBinder.getCurrentTask();
            if (task != null) {
                IApplication taskApplication;
                IScope taskScope = task.getScope();
                if (taskScope.get((Object)this.TASK_SCOPE_LISTENER_PARAMETER) == null) {
                    TaskScopeListener tsl = new TaskScopeListener();
                    task.registerToBeDestroyedListener((IScopeListener)tsl);
                    taskScope.put((Object)this.TASK_SCOPE_LISTENER_PARAMETER, (Object)tsl);
                }
                if ((taskApplication = task.getApplication()) != null && taskApplication.getScope().get((Object)this.TASK_SCOPE_LISTENER_PARAMETER) == null) {
                    TaskScopeListener tsl = new TaskScopeListener();
                    taskApplication.registerPhaseListener((IPhaseListener)tsl);
                    taskApplication.getScope().put((Object)this.TASK_SCOPE_LISTENER_PARAMETER, (Object)tsl);
                }
            }
        }
    }

    protected void lookupRemote(Hashtable properties) {
        try {
            InitialContext context = new InitialContext(properties);
            Object o = context.lookup(CAF_ACCESS_JNDI_REMOTE_KEY);
            CAFServiceAccessHome access_home = (CAFServiceAccessHome)PortableRemoteObject.narrow((Object)o, (Class)(class$com$sap$caf$rt$services$serviceaccess$CAFServiceAccessHome == null ? (class$com$sap$caf$rt$services$serviceaccess$CAFServiceAccessHome = CAFServiceManager.class$("com.sap.caf.rt.services.serviceaccess.CAFServiceAccessHome")) : class$com$sap$caf$rt$services$serviceaccess$CAFServiceAccessHome));
            Hashtable<String, Locale> prop = new Hashtable<String, Locale>();
            if (this.getLocale() != null) {
                prop.put("LOCALE", this.getLocale());
            }
            this.access = access_home.create(prop);
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable((int)500, (String)e.toString(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    protected void lookupLocal(Hashtable properties) {
        try {
            InitialContext context = new InitialContext(properties);
            Object o = context.lookup(CAF_ACCESS_JNDI_LOCAL_KEY);
            CAFServiceAccessLocalHome access_home = (CAFServiceAccessLocalHome)PortableRemoteObject.narrow((Object)o, (Class)(class$com$sap$caf$rt$services$serviceaccess$CAFServiceAccessLocalHome == null ? (class$com$sap$caf$rt$services$serviceaccess$CAFServiceAccessLocalHome = CAFServiceManager.class$("com.sap.caf.rt.services.serviceaccess.CAFServiceAccessLocalHome")) : class$com$sap$caf$rt$services$serviceaccess$CAFServiceAccessLocalHome));
            Hashtable<String, Locale> prop = new Hashtable<String, Locale>();
            if (this.getLocale() != null) {
                prop.put("LOCALE", this.getLocale());
            }
            this.access = access_home.create(prop);
        }
        catch (Exception e) {
            CAFPublicLogger.traceThrowable((int)500, (String)e.toString(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public ICAFServiceAccess getServiceAccess() {
        ITask task;
        if (this.access != null && (task = TaskBinder.getCurrentTask()) != null) {
            IApplication taskApplication;
            IScope taskScope = task.getScope();
            if (taskScope.get((Object)this.TASK_SCOPE_LISTENER_PARAMETER) == null) {
                TaskScopeListener tsl = new TaskScopeListener();
                task.registerToBeDestroyedListener((IScopeListener)tsl);
                taskScope.put((Object)this.TASK_SCOPE_LISTENER_PARAMETER, (Object)tsl);
            }
            if ((taskApplication = task.getApplication()) != null && taskApplication.getScope().get((Object)this.TASK_SCOPE_LISTENER_PARAMETER) == null) {
                TaskScopeListener tsl = new TaskScopeListener();
                taskApplication.registerPhaseListener((IPhaseListener)tsl);
                taskApplication.getScope().put((Object)this.TASK_SCOPE_LISTENER_PARAMETER, (Object)tsl);
            }
        }
        return this.access;
    }

    public AspectServiceAccess getAspectServiceAccess(String serviceName) {
        AspectServiceAccess accessSrv = (AspectServiceAccess)this.proxies.get(serviceName);
        if (accessSrv == null) {
            accessSrv = new AspectServiceAccess(this, this.getServiceModuleDescriptor(serviceName));
            this.proxies.put(serviceName, accessSrv);
        }
        return accessSrv;
    }

    public ISrvMgrCallbackOnFlush registerCallbackOnFlush(ISrvMgrCallbackOnFlush callbackObject) {
        ISrvMgrCallbackOnFlush oldCallback = this.mCallbackOnFlush;
        this.mCallbackOnFlush = callbackObject;
        return oldCallback;
    }

    public void closeConnection() {
        this.invalidateModuleCache();
    }

    public void copyCorresponding(IEdoTable arg0, IEdoTable arg1) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        String method = jARMRequest + ":flush()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        try {
            if (this.mCallbackOnFlush != null && !this.mCallbackOnFlush.beforeFlush("", "")) {
                throw new RuntimeException("Flush operation aborted by beforeFlush() callback");
            }
            AbstractCall[] callArray = null;
            if (this.mCallbackOnFlush != null) {
                int len = this.mCallList.size();
                callArray = new AbstractCall[len];
                for (int i = 0; i < len; ++i) {
                    callArray[i] = (ISrvMgrCall)this.mCallList.get(i);
                }
            }
            if (this.mCallbackOnFlush != null) {
                this.mCallbackOnFlush.afterFlush((ISrvMgrCall[])callArray);
            }
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
    }

    public String getBackendVersion() {
        return "CAF1.0";
    }

    public String getFrontendVersion() {
        return "CAF1.0";
    }

    public ISrvMgrMessage[] getMessages() {
        return this.systemMessages.toArray(EMPTY_MESSAGES_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRelativeAspectRowKey(IAspectDescriptor aspect, IEdoTable table, int index) {
        String method = jARMRequest + ":getRelativeAspectRowKey(IAspectDescriptor, IEdoTable, int)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            if (index < 0 || index >= table.getRecordCount()) {
                throw new ArrayIndexOutOfBoundsException("Index " + index + " out of bounds for given table (record count: " + table.getRecordCount() + ")");
            }
            if (aspect.getStructure() != table.getDescriptor()) {
                throw new IllegalArgumentException("Aspect structure ('" + aspect.getStructure().getName() + "') does not match table strucure ('" + table.getDescriptor().getName() + "')");
            }
            StringBuffer buf = new StringBuffer(100);
            buf.append("/").append(aspect.getKeyDescriptor().getName()).append("/1KEY");
            IStructureDescriptor keyStructure = aspect.getKeyDescriptor().getStructure();
            for (int i = 0; i < keyStructure.size(); ++i) {
                IFieldDescriptor fieldDesc = keyStructure.getFieldDescriptor(i);
                buf.append("/");
                String value = table.getStringValue(index, fieldDesc.getName());
                if (value == null) continue;
                if (fieldDesc.getType().equals("STRING")) {
                    value = table.getStringValue(index, fieldDesc.getName()).trim();
                    if ("".equals(value)) {
                        value = " ";
                    }
                } else {
                    value = fieldDesc.getType().equals("INTEGER") ? String.valueOf(table.getIntValue(index, fieldDesc.getName())) : (fieldDesc.getType().equals("DATE") ? table.getStringValue(index, fieldDesc.getName()) : (fieldDesc.getType().equals("TIME") ? table.getStringValue(index, fieldDesc.getName()) : (fieldDesc.getType().equals("TIMESTAMP") ? table.getStringValue(index, fieldDesc.getName()) : table.getStringValue(index, fieldDesc.getName()))));
                }
                if (value == null) continue;
                buf.append(URLEncoder.encode(value));
            }
            String string = buf.toString();
            return string;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    public ISrvMgrServiceModule getServiceModule(String moduleName, String moduleConfigurationName) {
        return null;
    }

    public ISrvMgrServiceModule getServiceModule(String moduleName) {
        return this.getServiceModule(moduleName, "");
    }

    public String[] getServiceModuleConfigurationNames(String serviceModuleName) {
        return this.getRepositoryManager().getConfigurationNames(serviceModuleName);
    }

    public IServiceModuleDescriptor getServiceModuleDescriptor(String serviceModuleName) {
        return this.getRepositoryManager().getServiceModuleDescriptor(serviceModuleName);
    }

    public IServiceModuleDescriptor getServiceModuleDescriptor(String serviceModuleName, String serviceModuleConfigurationName) {
        return this.getRepositoryManager().getServiceModuleDescriptor(serviceModuleName, serviceModuleConfigurationName);
    }

    protected CAFRepositoryManager getRepositoryManager() {
        if (this.smRepository == null) {
            this.smRepository = new CAFRepositoryManager(this);
        }
        return this.smRepository;
    }

    public String[] getServiceModuleNames() {
        return this.getRepositoryManager().getServiceModuleNames();
    }

    public String getTransactionID() {
        return this.mTransactionID;
    }

    public void invalidateModuleCache() {
        this.getRepositoryManager().invalidate();
    }

    public boolean isServiceModule(String serviceModuleName) {
        return this.getRepositoryManager().isServiceModule(serviceModuleName);
    }

    public boolean isToSave() {
        return this.mToSave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        String method = jARMRequest + ":cleanup()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            try {
                if (this.access != null) {
                    this.access.rollback();
                }
                Aspect.setDirtyStateForChangedAspects();
            }
            catch (Exception e) {
                SrvMgrMessage m = new SrvMgrMessage(1, "MSG1", e.getLocalizedMessage(), "", false, true);
                this.systemMessages.add(m);
            }
            this.flush();
            this.setToSave(false);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    protected void setToSave(boolean mToSave) {
        this.mToSave = mToSave;
    }

    public boolean save() {
        try {
            if (this.access != null) {
                this.access.commit();
            }
            Aspect.clearAspectWaitingStates();
            return true;
        }
        catch (Throwable e) {
            SrvMgrMessage m = new SrvMgrMessage(2, "MSG1", e.getLocalizedMessage(), "", false, true);
            this.systemMessages.add(m);
            Aspect.setDirtyStateForChangedAspects();
            return false;
        }
    }

    public void setDebug(boolean arg0, String arg1, String arg2) {
        throw new IllegalAccessError("setDebug not supported in CAF");
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public void flush(String arg0, String arg1) {
    }

    public String[] getActiveFeatures() {
        return null;
    }

    public String getActiveVersion() {
        return null;
    }

    public String[] getSupportedFeatures() {
        return null;
    }

    public boolean isFeatureActive(String arg0) {
        return false;
    }

    public boolean isFeatureSupported(String arg0) {
        return false;
    }

    public ISrvMgrMessage removeMessage(int arg0) {
        return (ISrvMgrMessage)this.systemMessages.remove(arg0);
    }

    public int sizeMessages() {
        return this.systemMessages.size();
    }

    public void useServiceModule(String arg0, String arg1) {
    }

    public void clearMessages() {
        this.systemMessages.clear();
    }

    public ISrvMgrMessage[] getAspectMessages(String arg0, boolean arg1) {
        return null;
    }

    public ISrvMgrMessage[] getAspectRowMessages(String arg0) {
        return null;
    }

    public ISrvMgrMessage[] getSystemMessages() {
        return this.systemMessages.toArray(EMPTY_MESSAGES_ARRAY);
    }

    public void removeMessage(ISrvMgrMessage arg0) {
        this.systemMessages.remove(arg0);
    }

    public void removeMessages(ISrvMgrMessage[] arg0) {
        for (int i = 0; i < arg0.length; ++i) {
            this.systemMessages.remove(arg0[i]);
        }
    }

    public boolean check() {
        return false;
    }

    public ISrvMgrMessage[] getAndClearSystemMessages() {
        ISrvMgrMessage[] ma = this.getSystemMessages();
        this.clearMessages();
        return ma;
    }

    private void setLocale(Locale locale) {
        this.mLocale = locale;
    }

    protected Locale getLocale() {
        return this.mLocale;
    }

    public void rollback() throws Exception {
        this.access.rollback();
        Aspect.setDirtyStateForChangedAspects();
    }

    public void commit() throws Exception {
        try {
            this.access.commit();
            Aspect.clearAspectWaitingStates();
        }
        catch (Exception ex) {
            Aspect.setDirtyStateForChangedAspects();
            throw ex;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class TaskScopeListener
    implements IScopeListener,
    IPhaseListener {
        public void scopeToBeDestroyed(IMaintainScope arg0) {
            try {
                ITask task = TaskBinder.getCurrentTask();
                if (task != null) {
                    task.getApplication().unregisterPhaseListener((IPhaseListener)this);
                    task.getApplication().getScope().put((Object)CAFServiceManager.this.TASK_SCOPE_LISTENER_PARAMETER, null);
                }
                CAFServiceManager.this.commit();
            }
            catch (Exception e) {
                logger.catching((Throwable)e);
                Aspect.setDirtyStateForChangedAspects();
            }
        }

        public void afterHandleActionEvent(boolean arg0) {
            block2: {
                try {
                    CAFServiceManager.this.commit();
                }
                catch (Exception e) {
                    logger.catching((Throwable)e);
                    IServiceFacade sf = ServiceFacadeFactory.getFacadeInstance(null);
                    if (sf == null) break block2;
                    MessageFactory.createAndRegisterMessageFromException((Throwable)e, sf);
                    IComponent c = TaskBinder.getCurrentTask().getCurrentTransportRoot();
                    if (!(c instanceof ClientComponent)) break block2;
                    ClientComponent cc = (ClientComponent)c;
                    IWDMessageManager mm = cc.getComponent().getMessageManager();
                    MessageFactory.reportOrRaiseCoolMessages(sf.getAllMessages(), mm, true, true, false);
                }
            }
        }

        public void beforeTransportData(IUpdateServerPeerData arg0) {
        }
    }

    static class SrvMgrMessage
    implements ISrvMgrMessage {
        boolean isOutBound;
        int category;
        String aspectName;
        String aspectField;
        String aspectKey;
        String[] aspectKeyFields;
        String aspectKeySID;
        String aspectKeyServiceModule;
        String aspectKeyAspect;
        String code;
        String extention;
        boolean isFailed;
        int inrecordIndex;
        String text;
        int type;
        boolean isInfo;
        boolean isWarning;
        boolean isError;
        String vars;
        String[] varsAsArray;

        public SrvMgrMessage(int type, String code, String text, Object extention, boolean isOutOfBound, boolean isFailed) {
            this.type = type;
            this.code = code;
            this.text = text;
            this.extention = String.valueOf(extention);
            this.isOutBound = isOutOfBound;
            this.isFailed = isFailed;
        }

        public boolean isOutbound() {
            return this.isOutBound;
        }

        public int getCategory() {
            return this.category;
        }

        public String getAspectName() {
            return this.aspectName;
        }

        public String getAspectField() {
            return this.aspectField;
        }

        public ICoolObjectKey getCoolObjectKey() {
            return null;
        }

        public String getAspectKey() {
            return this.aspectKey;
        }

        public String[] getAspectKeyFields() {
            return this.aspectKeyFields;
        }

        public String getAspectKeySID() {
            return this.aspectKeySID;
        }

        public String getAspectKeyServiceModule() {
            return this.aspectKeyServiceModule;
        }

        public String getAspectKeyAspect() {
            return this.aspectKeyAspect;
        }

        public String getCode() {
            return this.code;
        }

        public Object getExtension() {
            return this.extention;
        }

        public boolean isFailed() {
            return this.isFailed;
        }

        public int getInrecordIndex() {
            return this.inrecordIndex;
        }

        public String getText() {
            return this.text;
        }

        public int getType() {
            return this.type;
        }

        public boolean isInfo() {
            return this.isInfo;
        }

        public boolean isWarning() {
            return this.isWarning;
        }

        public boolean isError() {
            return this.isError;
        }

        public String getVars() {
            return this.vars;
        }

        public String[] getVarsAsArray() {
            return this.varsAsArray;
        }
    }
}

