/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.generic;

import com.sap.caf.rt.services.serviceaccess.ICAFServiceAccess;
import com.sap.caf.rt.ui.cool.generic.CAFServiceManager;
import com.sap.caf.rt.ui.cool.generic.CategoryFieldService;
import com.sap.caf.rt.ui.cool.generic.ColModelInfo;
import com.sap.caf.rt.ui.cool.metadata.ServiceModuleDescriptor;
import com.sap.caf.rt.ui.cool.metadata.TypedFieldDescriptor;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.cmi.metadata.ICMIModelInfo;
import com.sap.tc.col.client.metadata.api.IAspectActionDescriptor;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IQueryDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.logging.Location;
import com.sap.typeservices.ISimpleValueServices;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CAFRepositoryManager {
    private static final String APPLICATION = (class$com$sap$caf$rt$ui$cool$generic$CAFRepositoryManager == null ? (class$com$sap$caf$rt$ui$cool$generic$CAFRepositoryManager = CAFRepositoryManager.class$("com.sap.caf.rt.ui.cool.generic.CAFRepositoryManager")) : class$com$sap$caf$rt$ui$cool$generic$CAFRepositoryManager).getName();
    public static final String CAF_CATEGORY = "CAF_CATEGORY";
    private static final Location logger = Location.getLocation((String)APPLICATION);
    private CAFServiceManager manager;
    private Map descriptors = new HashMap();
    private Map models = new HashMap();
    private Collection serviceNames = null;
    static /* synthetic */ Class class$com$sap$caf$rt$ui$cool$generic$CAFRepositoryManager;

    public CAFRepositoryManager(CAFServiceManager manager) {
        this.manager = manager;
    }

    public String[] getServiceModuleNames() {
        ICAFServiceAccess access;
        String[] result = new String[]{};
        if (this.serviceNames == null && (access = this.manager.getServiceAccess()) != null) {
            try {
                this.serviceNames = access.getServiceNames();
            }
            catch (Exception e) {
                CAFPublicLogger.traceThrowable((int)500, (String)e.getMessage(), (Throwable)e);
            }
        }
        if (this.serviceNames != null) {
            result = this.serviceNames.toArray(new String[0]);
        }
        return result;
    }

    public IServiceModuleDescriptor getServiceModuleDescriptor(String serviceName) {
        IServiceModuleDescriptor descriptor = (IServiceModuleDescriptor)this.descriptors.get(serviceName);
        if (descriptor == null) {
            descriptor = this.loadServiceModuleDescriptor(serviceName);
            if (descriptor == null) {
                throw new IllegalArgumentException(serviceName);
            }
            this.descriptors.put(serviceName, descriptor);
            ColModelInfo model = new ColModelInfo(this, descriptor);
            this.models.put(serviceName, model);
        }
        return descriptor;
    }

    public ICMIModelInfo getCMIModel(String serviceName) {
        ICMIModelInfo model = (ICMIModelInfo)this.models.get(serviceName);
        if (model == null) {
            IServiceModuleDescriptor descriptor = (IServiceModuleDescriptor)this.descriptors.get(serviceName);
            if (descriptor == null) {
                descriptor = this.loadServiceModuleDescriptor(serviceName);
                this.descriptors.put(serviceName, descriptor);
            }
            model = new ColModelInfo(this, descriptor);
            this.models.put(serviceName, model);
        }
        return model;
    }

    public IServiceModuleDescriptor getServiceModuleDescriptor(String serviceName, String configName) {
        return this.getServiceModuleDescriptor(serviceName);
    }

    public String[] getConfigurationNames(String configName) {
        return new String[0];
    }

    public boolean isServiceModule(String serviceName) {
        ICAFServiceAccess access;
        if (this.serviceNames == null && (access = this.manager.getServiceAccess()) != null) {
            try {
                this.serviceNames = access.getServiceNames();
            }
            catch (Exception e) {
                CAFPublicLogger.traceThrowable((int)500, (String)e.getMessage(), (Throwable)e);
            }
        }
        if (this.serviceNames != null) {
            return this.serviceNames.contains(serviceName);
        }
        return false;
    }

    public void invalidate() {
        this.descriptors.clear();
    }

    private IServiceModuleDescriptor loadServiceModuleDescriptor(String serviceName) {
        ICAFServiceAccess access = this.manager.getServiceAccess();
        ServiceModuleDescriptor result = null;
        if (access != null) {
            try {
                result = access.getServiceModuleDescriptor(serviceName);
                this.addServicesToFieldDescriptors((IServiceModuleDescriptor)result);
            }
            catch (Exception e) {
                CAFPublicLogger.traceThrowable((int)500, (String)e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getLocalizedMessage());
            }
        }
        return result;
    }

    private void addServicesToFieldDescriptors(IServiceModuleDescriptor sMDescr) {
        if (sMDescr == null) {
            return;
        }
        this.processAspects(sMDescr);
        this.processQueries(sMDescr);
    }

    private void processAspects(IServiceModuleDescriptor sMDescr) {
        IAspectDescriptor[] aDescrs = sMDescr.getAspectDescriptors();
        for (int i = 0; i < aDescrs.length; ++i) {
            IAspectDescriptor aDescr = aDescrs[i];
            if (aDescr == null || aDescr.getStructure() == null) continue;
            this.processAspectActions(aDescr);
            IFieldDescriptor[] fieldDescrs = aDescr.getStructure().getFieldDescriptors();
            for (int j = 0; j < fieldDescrs.length; ++j) {
                IFieldDescriptor fd = fieldDescrs[j];
                this.processFieldDescriptor(fd);
            }
        }
    }

    private void processQueries(IServiceModuleDescriptor sMDescr) {
        IQueryDescriptor[] qDescrs = sMDescr.getQueryDescriptors();
        for (int i = 0; i < qDescrs.length; ++i) {
            IQueryDescriptor qDescr = qDescrs[i];
            if (qDescr == null || qDescr.getInputParameters() == null) continue;
            IFieldDescriptor[] fieldDescrs = qDescr.getInputParameters().getFieldDescriptors();
            for (int j = 0; j < fieldDescrs.length; ++j) {
                IFieldDescriptor fd = fieldDescrs[j];
                this.processFieldDescriptor(fd);
            }
        }
    }

    private void processAspectActions(IAspectDescriptor aDescr) {
        IAspectActionDescriptor[] actionDescrs = aDescr.getAspectActionDescriptors();
        for (int i = 0; i < actionDescrs.length; ++i) {
            IAspectActionDescriptor actionDescr = actionDescrs[i];
            if (actionDescr == null || actionDescr.getInputParameters() == null) continue;
            IFieldDescriptor[] fieldDescrs = actionDescr.getInputParameters().getFieldDescriptors();
            for (int j = 0; j < fieldDescrs.length; ++j) {
                IFieldDescriptor fd = fieldDescrs[j];
                this.processFieldDescriptor(fd);
            }
        }
    }

    private void processFieldDescriptor(IFieldDescriptor fd) {
        if (fd instanceof TypedFieldDescriptor && ((TypedFieldDescriptor)fd).getServiceRequired() == 2) {
            TypedFieldDescriptor tfd = (TypedFieldDescriptor)fd;
            CategoryFieldService cfs = new CategoryFieldService(tfd.getDefaultLocale(), this.manager);
            String categoryID = tfd.getCategoryID();
            cfs.setCategoryId(categoryID);
            tfd.setSimpleValueService((ISimpleValueServices)cfs);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

