/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.generic;

import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.services.serviceaccess.SimpleDataContainer;
import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.caf.rt.ui.cool.generic.Aspect;
import com.sap.caf.rt.ui.cool.generic.AspectRow;
import com.sap.caf.rt.ui.cool.generic.CAFServiceManager;
import com.sap.caf.rt.ui.cool.generic.Structure;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IRelationDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.logging.Location;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class AspectServiceAccess {
    private static final String APPLICATION = (class$com$sap$caf$rt$ui$cool$generic$AspectServiceAccess == null ? (class$com$sap$caf$rt$ui$cool$generic$AspectServiceAccess = AspectServiceAccess.class$("com.sap.caf.rt.ui.cool.generic.AspectServiceAccess")) : class$com$sap$caf$rt$ui$cool$generic$AspectServiceAccess).getName();
    private static final String jARMRequest = "XAP:COOL:" + APPLICATION;
    private static final Location logger = Location.getLocation((String)APPLICATION);
    private static final String EMPTY_SUBMIT_ACTION_NAME = "$submit$";
    private static final String QUERY_FIND_BY_MULTIPLEPARAMETERS = "findByMultipleParameters";
    private static final String QUERY_FIND_BY_KMPROPERTYSEARCH = "findByKMPropertySearch";
    private CAFServiceManager manager;
    private IServiceModuleDescriptor descriptor;
    static /* synthetic */ Class class$com$sap$caf$rt$ui$cool$generic$AspectServiceAccess;

    public AspectServiceAccess(CAFServiceManager manager, IServiceModuleDescriptor descriptor) {
        this.manager = manager;
        this.descriptor = descriptor;
    }

    public IServiceModuleDescriptor getServiceModuleDescriptor() {
        return this.descriptor;
    }

    public Collection readAspectObjects(String aspectName, Collection keys) throws ServiceException {
        String method = jARMRequest + ":readAspectObjects(String, Collection)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        Collection result = null;
        try {
            Collection dataObjects;
            result = dataObjects = this.manager.getServiceAccess().readDataObject(this.descriptor.getName(), aspectName, this.convertToObjectKeys(keys));
        }
        catch (RemoteException re) {
            logger.throwing((Throwable)re);
            throw new ServiceException((Throwable)re);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
        return result;
    }

    public Aspect readAspect(Aspect targetAspect, Collection keys) throws ServiceException {
        String method = jARMRequest + ":readAspect(Aspect, Collection)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        Aspect result = targetAspect;
        try {
            Collection rawResult = this.manager.getServiceAccess().readDataObject(this.descriptor.getName(), targetAspect.getName(), this.convertToObjectKeys(keys));
            targetAspect.setState(5);
            if (rawResult instanceof List) {
                Iterator it = ((List)rawResult).iterator();
                while (it.hasNext()) {
                    this.createRow(targetAspect, (IDataContainerBean)it.next());
                }
            } else {
                this.createRow(targetAspect, (IDataContainerBean)rawResult);
            }
            targetAspect.setState(0);
        }
        catch (RemoteException re) {
            logger.throwing((Throwable)re);
            throw new ServiceException((Throwable)re);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
        return result;
    }

    public Collection readRelatedAspects(String parentAspect, String relationName, Collection refKeys) throws ServiceException {
        String method = jARMRequest + ":readRelatedAspects(String, String, Collection)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        if (refKeys == null || refKeys.isEmpty()) {
            return new ArrayList();
        }
        Collection result = null;
        IAspectDescriptor asDesc = this.descriptor.getAspectDescriptor(parentAspect);
        IRelationDescriptor relDesc = asDesc.getRelationDescriptor(relationName);
        IAspectDescriptor refAspectDesc = relDesc.getTargetAspectDescriptor();
        result = this.manager.getAspectServiceAccess(refAspectDesc.getServiceModuleDescriptor().getName()).readAspectObjects(refAspectDesc.getName(), this.convertToObjectKeys(refKeys));
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        return result;
    }

    public Collection updateAspects(Collection aspectRows) throws ServiceException {
        String method = jARMRequest + ":updateAspects(Collection)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        Collection result = aspectRows;
        int size = aspectRows.size();
        Iterator it = aspectRows.iterator();
        while (it.hasNext()) {
            this.updateAspect((AspectRow)it.next());
        }
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAspectRow updateAspect(IAspectRow row) throws ServiceException {
        String method = jARMRequest + ":updateAspect(IAspectRow)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        IDataContainerBean dcb = ((Aspect)row.getAspect()).getAspectData().getRecordDataBean(((AspectRow)row).getIndex());
        try {
            dcb = this.manager.getServiceAccess().updateDataObject(this.descriptor.getName(), row.getAspect().getDescriptor().getName(), dcb);
            this.refreshAspect(row, dcb);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
        return row;
    }

    public boolean insertAspectRows(Collection rows) throws ServiceException {
        String method = jARMRequest + ":insertAspectRows(Collection)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        boolean result = false;
        Iterator it = rows.iterator();
        while (it.hasNext()) {
            Object v = it.next();
            result = result && this.insertAspectRow((IAspectRow)v);
        }
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertAspectRow(IAspectRow row) throws ServiceException {
        String method = jARMRequest + ":insertAspectRow(IAspectRow)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        boolean result = false;
        IDataContainerBean dcb = ((Aspect)row.getAspect()).getAspectData().getRecordDataBean(((AspectRow)row).getIndex());
        try {
            dcb = this.manager.getServiceAccess().createDataObject(this.descriptor.getName(), row.getAspect().getDescriptor().getName(), dcb);
            this.refreshAspect(row, dcb);
            result = false;
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteAspectRows(String aspectName, IKeyList keys) throws ServiceException {
        String method = jARMRequest + ":deleteAspectRows(String, IKeyList)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        boolean result = false;
        try {
            Collection keysV = this.convertToObjectKeys((Collection)keys);
            result = this.manager.getServiceAccess().deleteDataObject(this.descriptor.getName(), aspectName, keysV);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
        return result;
    }

    public Collection findBy(String aspectName, String query, IStructure parameters) throws ServiceException {
        String method = jARMRequest + ":findBy(String, String, IStructure)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        Collection result = null;
        Collection pars = null;
        pars = QUERY_FIND_BY_KMPROPERTYSEARCH.equals(query) || QUERY_FIND_BY_MULTIPLEPARAMETERS.equals(query) ? this.convertToParametersWithNulls(parameters) : this.convertToParameters(parameters);
        try {
            result = this.manager.getServiceAccess().findByDataObject(this.descriptor.getName(), query, pars);
        }
        catch (RemoteException re) {
            Throwable ce = re.getCause();
            if (ce instanceof ServiceException) {
                throw (ServiceException)ce;
            }
            if (ce == null) {
                throw new ServiceException((Throwable)re);
            }
            throw new ServiceException(ce);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
        return result;
    }

    public IAspect valueHelp(String aspectName, String attribute) throws ServiceException {
        String method = jARMRequest + ":valueHelp(String, String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        IAspect result = null;
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        return result;
    }

    public void recalculate(IAspectRow row) throws ServiceException {
    }

    public Object invokeOperation(String operationName, IStructure parameters, IKeyList keys) throws ServiceException {
        String method = jARMRequest + ":invokeOperation(String, IStructure, IKeyList)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        Object result = null;
        try {
            if (!EMPTY_SUBMIT_ACTION_NAME.equals(operationName)) {
                Collection pars = this.convertToParameters(parameters);
                Collection keysV = this.convertToObjectKeys((Collection)keys);
                result = this.manager.getServiceAccess().invokeCustom(this.descriptor.getName(), operationName, (Object)pars, keysV);
            }
        }
        catch (RemoteException re) {
            Throwable ce = re.getCause();
            if (ce instanceof ServiceException) {
                throw (ServiceException)ce;
            }
            if (ce == null) {
                throw new ServiceException((Throwable)re);
            }
            throw new ServiceException(ce);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
        return result;
    }

    public Object invokeOperation(String operationName, Object[] parameters, IKeyList keys) throws ServiceException {
        String method = jARMRequest + ":invokeOperation(String, Object[])";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        Object result = null;
        try {
            Collection keysV = this.convertToObjectKeys((Collection)keys);
            result = this.manager.getServiceAccess().invokeCustom(this.descriptor.getName(), operationName, (Object)parameters, keysV);
        }
        catch (RemoteException re) {
            Throwable ce = re.getCause();
            if (ce instanceof ServiceException) {
                throw (ServiceException)ce;
            }
            if (ce == null) {
                throw new ServiceException((Throwable)re);
            }
            throw new ServiceException(ce);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
        return result;
    }

    void refreshAspect(IAspectRow row, IDataContainerBean data) {
        ((AspectRow)row).supplyRowWithData(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createRow(IAspect result, IDataContainerBean bean) {
        String method = jARMRequest + ":createRow(IAspect, IDataContainerBean)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            AspectRow row = (AspectRow)((Aspect)result).createAspectRow();
            row.supplyRowWithData(bean);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    protected IDataContainerBean createSimpleDataContainer(IAspectRow row) {
        SimpleDataContainer result = new SimpleDataContainer();
        ((AspectRow)row).refreshData((IDataContainerBean)result);
        return result;
    }

    protected Object convertToObjectKey(IKey key) {
        String result = key.toString();
        return result;
    }

    protected Collection convertToObjectKeys(Collection keyList) {
        if (keyList instanceof IKeyList) {
            ArrayList<Object> result = new ArrayList<Object>(keyList.size());
            for (int i = 0; i < keyList.size(); ++i) {
                result.add(this.convertToObjectKey(((IKeyList)keyList).getKey(i)));
            }
            return result;
        }
        return keyList;
    }

    protected Collection convertToParameters(IStructure structure) {
        ArrayList<Object> result = new ArrayList<Object>();
        int size = structure.size();
        for (int i = 0; i < size; ++i) {
            result.add(structure.getAttributeValue(i));
        }
        return result;
    }

    protected Collection convertToParametersWithNulls(IStructure structure) {
        ArrayList<Object> result = new ArrayList<Object>();
        Structure struct = (Structure)structure;
        int size = struct.size();
        for (int i = 0; i < size; ++i) {
            result.add(struct.getInternalValue(i));
        }
        return result;
    }

    protected void handleException(Exception e) throws ServiceException {
        String method = jARMRequest + ":handleException(e)";
        if (e instanceof InvocationTargetException) {
            e = (Exception)((InvocationTargetException)e).getCause();
        }
        if (!(e instanceof ServiceException)) {
            e = new ServiceException(e);
        }
        CAFPublicLogger.traceThrowableT((int)100, (Location)logger, (String)method, (String)("Error in " + method), (Throwable)e);
        logger.throwing(method, e);
        throw (ServiceException)e;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

