/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.generic;

import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.services.serviceaccess.SimpleDataContainer;
import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.caf.rt.ui.cool.generic.AbstractModelClass;
import com.sap.caf.rt.ui.cool.generic.Aspect;
import com.sap.caf.rt.ui.cool.generic.DependantAspectCache;
import com.sap.caf.rt.ui.cool.generic.IEdoTableEx;
import com.sap.caf.rt.ui.cool.generic.Key;
import com.sap.caf.rt.ui.cool.generic.KeyList;
import com.sap.caf.rt.ui.cool.generic.MessageFactory;
import com.sap.caf.rt.ui.cool.generic.ServiceFacade;
import com.sap.caf.rt.ui.cool.generic.ServiceModule;
import com.sap.caf.rt.ui.cool.generic.Util;
import com.sap.caf.rt.ui.cool.metadata.AspectDescriptor;
import com.sap.caf.rt.ui.cool.metadata.TypedFieldDescriptor;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.cmi.metadata.CMICardinality;
import com.sap.tc.cmi.metadata.ICMIModelClassInfo;
import com.sap.tc.cmi.model.ICMIModel;
import com.sap.tc.cmi.model.ICMIModelClass;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.ILockState;
import com.sap.tc.col.client.generic.api.IMessageList;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.LockStrategy;
import com.sap.tc.col.client.generic.api.SortingCriteria;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IRelationDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrCall;
import com.sap.tc.logging.Location;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class AspectRow
extends AbstractModelClass
implements IAspectRow {
    private static final String APPLICATION = (class$com$sap$caf$rt$ui$cool$generic$AspectRow == null ? (class$com$sap$caf$rt$ui$cool$generic$AspectRow = AspectRow.class$("com.sap.caf.rt.ui.cool.generic.AspectRow")) : class$com$sap$caf$rt$ui$cool$generic$AspectRow).getName();
    private static final String jARMRequest = "XAP:COOL:" + APPLICATION;
    private static final Location logger = Location.getLocation((String)APPLICATION);
    protected boolean m_keyFieldsChanged;
    private final Aspect aspect;
    private final Key key;
    private boolean recalculateTrigger = true;
    private BitSet loadedAttributes;
    private static final int CALC_MODE_NONE = 0;
    private static final Integer ICALC_MODE_NONE = new Integer(0);
    private static final String SCALC_MODE_NONE = "none";
    private static final String SCALC_MODE_FALSE = "false";
    private static final int CALC_MODE_ALWAYS = 1;
    private static final Integer ICALC_MODE_ALWAYS = new Integer(1);
    private static final String SCALC_MODE_ALWAYS = "always";
    private static final int CALC_MODE_ONCHANGE = 2;
    private static final Integer ICALC_MODE_ONCHANGE = new Integer(2);
    private static final String SCALC_MODE_ONCHANGE = "onchange";
    private static final String SCALC_MODE_TRUE = "true";
    private static final Map CALCULABLE;
    private boolean m_lockedForRefresh;
    private int state = 0;
    private HashMap m_calcFields = new HashMap();
    private final DependantAspectCache dependantAspectCache = new DependantAspectCache();
    private int index;
    static /* synthetic */ Class class$com$sap$caf$rt$ui$cool$generic$AspectRow;

    protected AspectRow(Aspect aspect, int index) {
        this(aspect, index, new Key(aspect.getDescriptor().getKeyDescriptor()));
    }

    protected AspectRow(Aspect aspect, int index, Key key) {
        this.aspect = aspect;
        this.index = index;
        this.key = key;
        int size = aspect.getDescriptor().getStructure().size();
        this.loadedAttributes = new BitSet(size);
        this.loadedAttributes.set(0, size);
    }

    public IStructureDescriptor getDescriptor() {
        return this.aspect.getDescriptor().getStructure();
    }

    public int size() {
        return this.getDescriptor().size();
    }

    public ICMIModel associatedModel() {
        return this.aspect.associatedModel();
    }

    public ICMIModelClassInfo associatedModelClassInfo() {
        return this.aspect.associatedModelObjectCollectionInfo().getElementModelClassInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IKey getKey() {
        String method = jARMRequest + ":getKey()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            Key keyDescriptor;
            this.handleAccessAspectRow();
            if (this.m_keyFieldsChanged) {
                keyDescriptor = this.key.getKeyDescriptor();
                IStructureDescriptor structure = keyDescriptor.getStructure();
                int noOfKeyFields = structure.size();
                String[] sKeyFields = new String[noOfKeyFields];
                for (int i = 0; i < noOfKeyFields; ++i) {
                    String keyField = structure.getFieldDescriptor(i).getName();
                    sKeyFields[i] = (String)this.getAttributeValue(keyField);
                }
                this.key.setKeyFields(sKeyFields);
                this.m_keyFieldsChanged = false;
            }
            keyDescriptor = this.key;
            return keyDescriptor;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this);
            IKey iKey = null;
            return iKey;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    public IAspect getRelatedAspect(String relationName, String targetAspectName) {
        return this.getRelatedAspect(relationName, targetAspectName, LockStrategy.SHARED_READ_ONLY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAspect getRelatedAspect(String relationName, String targetAspectName, LockStrategy lockMode) {
        String method = jARMRequest + ":getRelatedAspect(String, String, LockStrategy)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        try {
            IRelationDescriptor relationDescriptor = this.aspect.getRelationDescriptorOrFail(relationName);
            String targetOfRelation = relationDescriptor.getTargetAspectDescriptor().getName();
            if (targetOfRelation.equals(targetAspectName)) {
                IAspect iAspect = this.getRelatedAspect(relationName, lockMode);
                return iAspect;
            }
            Aspect targetAspect = (Aspect)this.getRelatedAspect(relationName, LockStrategy.SHARED_READ_ONLY);
            IAspect iAspect = targetAspect.getAspect(targetAspectName, lockMode);
            return iAspect;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this);
            IAspect iAspect = null;
            return iAspect;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
    }

    public IAspectRow getRelatedAspectRow(String relationName, String targetAspectName) {
        return this.getRelatedAspectRow(relationName, targetAspectName, LockStrategy.SHARED_READ_ONLY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAspectRow getRelatedAspectRow(String relationName, String targetAspectName, LockStrategy lockMode) {
        String method = jARMRequest + ":getRelatedAspectRow(String, String, LockStrategy)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            IRelationDescriptor relationDescriptor = this.aspect.getRelationDescriptorOrFail(relationName);
            String targetOfRelation = relationDescriptor.getTargetAspectDescriptor().getName();
            if (targetOfRelation.equals(targetAspectName)) {
                IAspectRow iAspectRow = this.getRelatedAspectRow(relationName, lockMode);
                return iAspectRow;
            }
            AspectRow targetAspectRow = (AspectRow)this.getRelatedAspectRow(relationName, LockStrategy.SHARED_READ_ONLY);
            IAspectRow iAspectRow = targetAspectRow.getAspectRow(targetAspectName, lockMode);
            return iAspectRow;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this);
            IAspectRow iAspectRow = null;
            return iAspectRow;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    public IAspect getRelatedAspect(String relationName) {
        return this.getRelatedAspect(relationName, LockStrategy.SHARED_READ_ONLY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IAspect getRelatedFromCache(String relationName, LockStrategy lockMode) throws ServiceException, InvocationTargetException, IllegalAccessException {
        String method = jARMRequest + ":getRelatedFromCache(String, LockStrategy)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            Aspect targetAspect = this.dependantAspectCache.getRelatedAspect(relationName);
            if (targetAspect != null) {
                if (lockMode != LockStrategy.SHARED_READ_ONLY && targetAspect.getState() != 0 && targetAspect.getState() != 1) {
                    throw new IllegalArgumentException("Locking of aspect '" + targetAspect.getName() + "' not allowed, cause Aspect is not CLEAN or HOLLOW!");
                }
            } else {
                IRelationDescriptor relationDescriptor = this.aspect.getRelationDescriptorOrFail(relationName);
                String sourceAspectName = relationDescriptor.getSourceAspectDescriptor().getName();
                if (!sourceAspectName.equals(this.aspect.getName())) {
                    Aspect keyAspect = (Aspect)this.aspect.getAspect(sourceAspectName);
                    IAspectRow keyAspectRow = keyAspect.getAspectRow(this.key);
                    if (keyAspectRow == null) {
                        keyAspectRow = keyAspect.createAspectRow(this.key);
                    }
                    IAspect iAspect = keyAspectRow.getRelatedAspect(relationName, lockMode);
                    return iAspect;
                }
            }
            Aspect aspect = targetAspect;
            return aspect;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IAspect createAndPopulateRelatedAspect(String relationName, LockStrategy lockMode) throws ServiceException, InvocationTargetException, IllegalAccessException {
        String method = jARMRequest + ":createAndPopulateRelatedAspect(String, LockStrategy)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        try {
            IAspect targetAspect = this.createTargetAspect(relationName);
            this.populateRelatedAspect(relationName, lockMode, targetAspect);
            this.dependantAspectCache.addRelatedAspect(this, relationName, (Aspect)targetAspect, null);
            IAspect iAspect = targetAspect;
            return iAspect;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IAspect createTargetAspect(String relationName) {
        String method = jARMRequest + ":createTargetAspect(String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            Aspect targetAspect;
            IRelationDescriptor relationDescriptor = this.aspect.getRelationDescriptorOrFail(relationName);
            IAspectDescriptor targetDesc = relationDescriptor.getTargetAspectDescriptor();
            ServiceModule serviceModule = (ServiceModule)this.aspect.getServiceModule();
            ServiceFacade facade = serviceModule.getServiceFacade();
            IServiceModule targetServiceModule = facade.getServiceModule(targetDesc.getServiceModuleDescriptor().getName());
            Aspect aspect = targetAspect = (Aspect)targetServiceModule.createAspect(targetDesc.getName());
            return aspect;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateRelatedAspect(String relationName, LockStrategy lockMode, IAspect targetAspect) throws ServiceException, InvocationTargetException, IllegalAccessException {
        String method = jARMRequest + ":populateRelatedAspect(String, LockStrategy, IAspect)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        try {
            ServiceModule serviceModule = (ServiceModule)this.aspect.getServiceModule();
            IRelationDescriptor relationDescriptor = this.aspect.getRelationDescriptorOrFail(relationName);
            String relationAttribute = Util.getSourceRelationAttribute(relationDescriptor);
            Object refObject = this.aspect.getAspectData().getRecordDataBean(this.index).getProperty(relationAttribute);
            if (SCALC_MODE_TRUE.equals(relationDescriptor.getAttributeStringValue("complex_attribute"))) {
                ((Aspect)targetAspect).setState(5);
                if (refObject instanceof Collection) {
                    Iterator it = ((Collection)refObject).iterator();
                    while (it.hasNext()) {
                        Object value = it.next();
                        if (value == null) continue;
                        this.createRow(targetAspect, (IDataContainerBean)value);
                    }
                } else if (refObject != null) {
                    this.createRow(targetAspect, (IDataContainerBean)refObject);
                }
                ((Aspect)targetAspect).setState(0);
            } else if (SCALC_MODE_TRUE.equals(((AspectDescriptor)((Aspect)targetAspect).getDescriptor()).getAttributeStringValue("collection_support"))) {
                if (refObject != null) {
                    ((Aspect)targetAspect).setState(5);
                    if (refObject instanceof Collection) {
                        Iterator it = ((Collection)refObject).iterator();
                        while (it.hasNext()) {
                            SimpleDataContainer sc = new SimpleDataContainer();
                            sc.setProperty("value", it.next());
                            this.createRow(targetAspect, (IDataContainerBean)sc);
                        }
                    }
                    ((Aspect)targetAspect).setState(0);
                }
            } else if (refObject != null) {
                Collection<Object> refKeys = null;
                if (refObject instanceof Collection) {
                    refKeys = ((Collection)refObject).isEmpty() ? null : (Collection)refObject;
                } else {
                    refKeys = new HashSet();
                    if (refObject != null && !"".equals(((String)refObject).trim())) {
                        refKeys.add(refObject);
                    }
                }
                if (refKeys != null) {
                    Collection rawResult = serviceModule.getAspectServiceAccess().readRelatedAspects(this.aspect.getName(), relationName, refKeys);
                    ((Aspect)targetAspect).setState(5);
                    if (rawResult instanceof Collection) {
                        Iterator it = rawResult.iterator();
                        while (it.hasNext()) {
                            this.createRow(targetAspect, (IDataContainerBean)it.next());
                        }
                    } else {
                        this.createRow(targetAspect, (IDataContainerBean)rawResult);
                    }
                    ((Aspect)targetAspect).setState(0);
                }
            }
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAspect getRelatedAspect(String relationName, LockStrategy lockMode) {
        String method = jARMRequest + ":getRelatedAspect(String, LockStrategy)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        IAspect targetAspect = null;
        try {
            if (this.state != 1) {
                this.handleAccessAspectRow();
            }
            if ((targetAspect = this.getRelatedFromCache(relationName, lockMode)) == null) {
                targetAspect = this.createAndPopulateRelatedAspect(relationName, lockMode);
            }
            this.aspect.addRelatedAspect(targetAspect);
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this);
            try {
                targetAspect = this.createTargetAspect(relationName);
            }
            catch (Exception e2) {
                MessageFactory.createAndRegisterMessageFromException((Throwable)e, this);
            }
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
        return targetAspect;
    }

    private void createRow(IAspect result, IDataContainerBean bean) {
        AspectRow row = (AspectRow)result.createAspectRow();
        row.supplyRowWithData(bean);
    }

    public void supplyRowWithData(IDataContainerBean data) {
        this.setAttributeValue(data);
    }

    public void refreshData(IDataContainerBean data) {
        IDataContainerBean row = this.aspect.getAspectData().getRecordDataBean(this.index);
        IStructureDescriptor desc = this.aspect.getDescriptor().getStructure();
        IFieldDescriptor[] descs = desc.getFieldDescriptors();
        for (int i = 0; i < descs.length; ++i) {
            data.setProperty(descs[i].getName(), row.getProperty(descs[i].getName()));
        }
    }

    public IAspectRow getRelatedAspectRow(String relationName) {
        return this.getRelatedAspectRow(relationName, LockStrategy.SHARED_READ_ONLY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAspectRow getRelatedAspectRow(String relationName, LockStrategy lockMode) {
        String method = jARMRequest + ":getRelatedAspectRow(String, LockStrategy)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            IRelationDescriptor relationDescriptor = this.aspect.getRelationDescriptorOrFail(relationName);
            CMICardinality cardinality = relationDescriptor.getAttributeTargetCardinality();
            if (cardinality.isMultiple()) {
                throw new IllegalArgumentException(" Cardinality of relation " + relationName + " has to be 1:0..1 but is " + cardinality);
            }
            Aspect targetAspect = (Aspect)this.getRelatedAspect(relationName, lockMode);
            if (targetAspect != null && targetAspect.size() > 0) {
                IAspectRow iAspectRow = targetAspect.getAspectRow(0);
                return iAspectRow;
            }
            IAspectRow iAspectRow = null;
            return iAspectRow;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this);
            IAspectRow iAspectRow = null;
            return iAspectRow;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    public boolean addRelatedModelObject(String rolename, ICMIModelClass o) {
        boolean result = false;
        if (rolename != null && o instanceof AspectRow) {
            AspectRow relRow = (AspectRow)o;
            IRelationDescriptor r_desc = this.aspect.getDescriptor().getRelationDescriptor(rolename);
            Aspect asp = (Aspect)this.getRelatedAspect(rolename);
            result = asp.createRelatedAspectRow(relRow) != null;
            this.handleDirtyState("key");
            this.setState(2);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelatedModelObject(String roleName, ICMIModelClass o) {
        String method = jARMRequest + ":setRelatedModelObject(String, ICMIModelClass)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        try {
            if (o instanceof AspectRow) {
                IAspect old = this.getRelatedFromCache(roleName, LockStrategy.SHARED_READ_ONLY);
                if (old != null) {
                    old.invalidate();
                }
                IAspect targetAspect = this.createTargetAspect(roleName);
                this.dependantAspectCache.addRelatedAspect(this, roleName, (Aspect)targetAspect, null);
                this.addRelatedModelObject(roleName, o);
                this.handleDirtyState("key");
                this.setState(2);
            }
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelatedModelObjects(String roleName, Collection o) {
        String method = jARMRequest + ":setRelatedModelObject(String, Collection)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        try {
            if (o instanceof Aspect) {
                IAspect old = this.getRelatedFromCache(roleName, LockStrategy.SHARED_READ_ONLY);
                if (old != null) {
                    old.invalidate();
                }
                this.dependantAspectCache.addRelatedAspect(this, roleName, (Aspect)((Object)o), null);
                this.aspect.addRelatedAspect((IAspect)o);
                this.handleDirtyState("key");
                this.setState(2);
            }
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRelatedModelObject(String roleName, ICMIModelClass o) {
        block6: {
            String method = jARMRequest + ":removeRelatedModelObject(String, ICMIModelClass)";
            CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
            try {
                if (roleName == null || !(o instanceof AspectRow)) break block6;
                AspectRow relRow = (AspectRow)o;
                IRelationDescriptor r_desc = this.aspect.getDescriptor().getRelationDescriptor(roleName);
                Aspect asp = (Aspect)this.getRelatedAspect(roleName);
                int current_state = asp.getState();
                try {
                    asp.setState(3);
                    asp.removeAspectRow(relRow);
                    this.handleDirtyState("key");
                }
                finally {
                    asp.setState(current_state);
                    this.setState(2);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)1);
            }
        }
        return false;
    }

    public IAspectRow getAspectRow(String aspectName) {
        return this.getAspectRow(aspectName, LockStrategy.SHARED_READ_ONLY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAspectRow getAspectRow(String aspectName, LockStrategy lockMode) {
        String method = jARMRequest + ":getAspectRow(String, LockStrategy)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            AspectRow targetRow;
            this.handleAccessAspectRow();
            Aspect resultAspect = this.dependantAspectCache.getSiblingAspect(aspectName);
            if (resultAspect != null) {
                IAspectRow iAspectRow = resultAspect.getAspectRow(this.getKey(), lockMode);
                return iAspectRow;
            }
            resultAspect = this.aspect.getSelectedAspect(aspectName);
            if (resultAspect != null) {
                IAspectRow iAspectRow = resultAspect.getAspectRow(this.getKey(), lockMode);
                return iAspectRow;
            }
            ServiceModule serviceModule = (ServiceModule)this.aspect.getServiceModule();
            KeyList keyList = new KeyList(this.key.getKeyDescriptor());
            keyList.add(this.key);
            resultAspect = (Aspect)serviceModule.getAspect(this.aspect, aspectName, keyList, lockMode);
            if (resultAspect.getState() == 0) {
                targetRow = (AspectRow)resultAspect.getAspectRow(this.key);
            } else {
                resultAspect.setState(5);
                targetRow = (AspectRow)resultAspect.createAspectRow(0);
                resultAspect.setState(1);
                targetRow.setState(1);
            }
            this.dependantAspectCache.addSiblingAspect(aspectName, resultAspect);
            AspectRow aspectRow = targetRow;
            return aspectRow;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this);
            IAspectRow iAspectRow = null;
            return iAspectRow;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    IDataContainerBean getAspectRowData() {
        return this.aspect.getAspectData().getRecordDataBean(this.index);
    }

    public IAspect getAspect() {
        try {
            this.handleAccessAspectRow();
            return this.aspect;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this.aspect);
            return this.aspect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributeValue(IDataContainerBean data) {
        String method = jARMRequest + ":setAttributeValue(IDataContainerBean)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            this.handleAccessAspectRow();
            this.recalculateTrigger = true;
            this.aspect.getAspectData().setValue(this.index, data);
            this.key.takeFieldsFromRow(this);
            IFieldDescriptor[] fieldDescs = this.getDescriptor().getFieldDescriptors();
            for (int i = 0; i < fieldDescs.length; ++i) {
                this.handleDirtyState(fieldDescs[i].getName());
            }
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributeValue(String name, Object value) {
        String method = jARMRequest + ":setAttributeValue(String, Object)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            this.aspect.getAspectData().setValue(this.index, name, value);
            this.handleDirtyState(name);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributeValue(int attributeIndex, Object attributeValue) {
        String method = jARMRequest + ":setAttributeValue(int, Object)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            this.handleAccessAspectRow();
            this.recalculateTrigger = true;
            this.aspect.getAspectData().setValue(this.index, attributeIndex, attributeValue);
            this.handleDirtyState(this.getDescriptor().getFieldDescriptor(attributeIndex).getName());
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this);
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    private int getFieldIndex(String fieldName) {
        IStructureDescriptor descriptor = this.getDescriptor();
        int fieldIndex = descriptor.getFieldIndex(fieldName);
        if (fieldIndex < 0) {
            throw new IllegalArgumentException("Field name '" + fieldName + "' not found in structure '" + descriptor.getName() + "'.");
        }
        return fieldIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAttributeValue(String attributeName) {
        Aspect aParentAspect = (Aspect)this.getAspect();
        int iOldState = aParentAspect.getState();
        try {
            aParentAspect.setState(5);
            ((ServiceModule)this.aspect.getServiceModule()).getAspectServiceAccess().invokeOperation("loadProperty", new Object[]{attributeName}, null);
        }
        catch (ServiceException e) {
        }
        finally {
            aParentAspect.setState(iOldState);
        }
    }

    private static int getCalcMode(String attr) {
        Object o = CALCULABLE.get(attr);
        return attr == null || o == null ? 0 : (Integer)o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshCalculableValues(String attributeName, IEdoTable table) {
        String method = jARMRequest + ":refreshCalculableValues(String, IEdoTable)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            IFieldDescriptor fieldDescriptor = this.getDescriptor().getFieldDescriptor(attributeName);
            if (!this.m_lockedForRefresh && this.needToRecalc(fieldDescriptor)) {
                this.refreshCalculableValues(fieldDescriptor);
            }
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshCalculableValues(int attributeIndex, IEdoTable table) {
        String method = jARMRequest + ":refreshCalculableValues(int, IEdoTable)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            IFieldDescriptor fieldDescriptor = this.getDescriptor().getFieldDescriptor(attributeIndex);
            if (!this.m_lockedForRefresh && this.needToRecalc(fieldDescriptor)) {
                this.refreshCalculableValues(fieldDescriptor);
            }
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    private boolean needToRecalc(IFieldDescriptor fd) {
        return this.needToRecalc(fd.getText(1));
    }

    private boolean needToRecalc(String s) {
        int iCalculableMode = AspectRow.getCalcMode(s);
        return iCalculableMode == 1 || iCalculableMode == 2 && this.recalculateTrigger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void refreshCalculableValues(IFieldDescriptor fieldDescriptor) {
        String method = jARMRequest + ":refreshCalculableValues(IFieldDescriptor)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            if (this.m_lockedForRefresh) return;
            if (!this.needToRecalc(fieldDescriptor)) return;
            this.m_lockedForRefresh = true;
            try {
                ((ServiceModule)this.aspect.getServiceModule()).getAspectServiceAccess().recalculate(this);
                this.m_lockedForRefresh = false;
                this.recalculateTrigger = false;
                return;
            }
            catch (ServiceException serviceException) {
                return;
            }
            finally {
                this.m_lockedForRefresh = false;
                this.recalculateTrigger = false;
            }
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttributeValue(String attributeName) {
        String method = jARMRequest + ":getAttributeValue(String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            this.handleAccessAspectRow();
            this.refreshCalculableValues(attributeName, (IEdoTable)this.aspect.getAspectData());
            this.ensureAttributeLoaded(attributeName);
            Object value = this.aspect.getAspectData().getValue(this.index, attributeName);
            if (value == null) {
                value = AspectRow.getDefaultValue(this.getDescriptor().getFieldDescriptor(attributeName));
            }
            Object object = value;
            return object;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this);
            Object var4_6 = null;
            return var4_6;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributeAsString(int attributeIndex) {
        String method = jARMRequest + ":getAttributeAsString(int)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            this.handleAccessAspectRow();
            this.refreshCalculableValues(attributeIndex, (IEdoTable)this.aspect.getAspectData());
            this.ensureAttributeLoaded(attributeIndex);
            Object value = this.aspect.getAspectData().getValue(this.index, attributeIndex);
            if (value != null) {
                String string = value.toString();
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this);
            String string = null;
            return string;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttributeValue(int attributeIndex) {
        String method = jARMRequest + ":getAttributeValue(int)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            this.handleAccessAspectRow();
            this.refreshCalculableValues(attributeIndex, (IEdoTable)this.aspect.getAspectData());
            this.ensureAttributeLoaded(attributeIndex);
            Object value = this.aspect.getAspectData().getValue(this.index, attributeIndex);
            if (value == null) {
                value = AspectRow.getDefaultValue(this.getDescriptor().getFieldDescriptor(attributeIndex));
            }
            Object object = value;
            return object;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this);
            Object var4_6 = null;
            return var4_6;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributeAsString(String attributeName) {
        String method = jARMRequest + ":getAttributeAsString(String)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            this.handleAccessAspectRow();
            this.refreshCalculableValues(attributeName, (IEdoTable)this.aspect.getAspectData());
            if (this.getDescriptor().getFieldDescriptor(attributeName) == null) {
                throw new IllegalArgumentException("attribute with name '" + attributeName + "' doesn't exist!");
            }
            this.ensureAttributeLoaded(attributeName);
            String string = this.aspect.getAspectData().getStringValue(this.index, attributeName);
            return string;
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this);
            String string = null;
            return string;
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    private void ensureAttributeLoaded(String attributeName) {
        this.ensureAttributeLoaded(this.getFieldIndex(attributeName));
    }

    private void ensureAttributeLoaded(int attributeIndex) {
        TypedFieldDescriptor descriptor;
        IFieldDescriptor desc = this.getDescriptor().getFieldDescriptor(attributeIndex);
        if (desc instanceof TypedFieldDescriptor && (descriptor = (TypedFieldDescriptor)this.getDescriptor().getFieldDescriptor(attributeIndex)).isLoadOnDemand() && this.isAttributeInitial(attributeIndex)) {
            this.loadAttributeValue(descriptor.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAccessAspectRow() {
        String method = jARMRequest + ":handleAccessAspectRow()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            if (this.state == 1 || this.aspect.getState() == 1) {
                ((ServiceModule)this.aspect.getServiceModule()).flush();
            }
            if (this.state == 4 || this.aspect.getState() == 4) {
                throw new IllegalStateException(" AspectRow with Key: " + this.key + " of Aspect '" + this.aspect.getName() + "' is invalid: Fatal Access Error!!!");
            }
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    protected void setState(int state) {
        CAFPublicLogger.LOC_CAF.debugT("setState state=" + state);
        this.state = state;
    }

    public String toString() {
        try {
            this.handleAccessAspectRow();
            String nl = System.getProperty("line.separator");
            StringBuffer buf = new StringBuffer();
            buf.append("  <AspectRow>").append(nl);
            for (int i = 0; i < this.size(); ++i) {
                IFieldDescriptor field = this.getDescriptor().getFieldDescriptor(i);
                String attributeValue = this.getAttributeAsString(i);
                buf.append("     ").append(field.getName()).append("=").append(attributeValue == null ? "<null>" : attributeValue).append(nl);
            }
            buf.append("  </AspectRow>").append(nl);
            return buf.toString();
        }
        catch (Exception e) {
            return "Error while converting AspectRow to String. Super.toString() is: " + super.toString();
        }
    }

    private boolean needToChangeDirty(String attributeName) {
        Boolean field = (Boolean)this.m_calcFields.get(attributeName);
        if (null == field) {
            IFieldDescriptor fieldDescriptor = this.getDescriptor().getFieldDescriptor(attributeName);
            field = new Boolean(!this.needToRecalc(fieldDescriptor));
            this.m_calcFields.put(attributeName, field);
        }
        return null == field ? false : field;
    }

    void handleDirtyState(String fieldName) {
        IFieldDescriptor fieldDescriptor;
        if ("key".equals(fieldName) && this.getDescriptor().getFieldIndex(fieldName) == -1 && this.getDescriptor().size() > 0 && (fieldDescriptor = this.getDescriptor().getFieldDescriptor(0)) != null) {
            fieldName = fieldDescriptor.getName();
        }
        if (this.aspect.getState() == 5 || this.state == 5 || !this.needToChangeDirty(fieldName)) {
            return;
        }
        this.setState(2);
        this.aspect.registerUpdate(this.key, fieldName);
        AspectRow sourceRow = this.aspect.getSourceAspectRowOfCreatingRelation();
        if (sourceRow != null) {
            sourceRow.handleDirtyState("key");
        }
    }

    public ICMIModelClass getRelatedModelObject(String rolename) {
        return this.getRelatedAspectRow(rolename);
    }

    public Collection getRelatedModelObjects(String rolename) {
        return this.getRelatedAspect(rolename);
    }

    int getIndex() {
        return this.index;
    }

    protected void invalidateInternal() {
        if (this.state == 4) {
            return;
        }
        this.setState(4);
        ((ServiceModule)this.aspect.getServiceModule()).unregisterAspectRowKey(this.aspect, this.key);
        this.dependantAspectCache.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setKeyFields(Key newKey) {
        String method = jARMRequest + ":setKeyFields(Key)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        try {
            if (newKey.isLocalKey()) {
                if (!this.key.isLocalKey()) {
                    throw new RuntimeException("Initialized key cannot be converted to local one.");
                }
            } else {
                IStructureDescriptor structureDescriptor = this.aspect.getDescriptor().getKeyDescriptor().getStructure();
                int noOfFields = structureDescriptor.size();
                String[] keyFields = newKey.getKeyFields();
                for (int i = 0; i < noOfFields && i < keyFields.length; ++i) {
                    String fieldName = structureDescriptor.getFieldDescriptor(i).getName();
                    this.aspect.getAspectData().setStringValue(this.index, fieldName, keyFields[i]);
                }
                this.key.setKeyFields(keyFields);
            }
        }
        finally {
            CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)logger, (int)2);
        }
    }

    public void promoteLock() {
    }

    public void lock(LockStrategy lockMode) {
        try {
            this.handleAccessAspectRow();
            if (lockMode == LockStrategy.SHARED_READ_ONLY) {
                return;
            }
            this.aspect.lockAndRefresh(this, lockMode);
        }
        catch (Exception e) {
            MessageFactory.createAndRegisterMessageFromException((Throwable)e, this);
        }
    }

    public void unlock() {
    }

    public void onCallsProcessed(ISrvMgrCall[] calls) {
    }

    void setIndex(int i) {
        this.index = i;
    }

    public boolean isValid() {
        return this.state != 4;
    }

    public String getName() {
        return this.aspect.getDescriptor().getName();
    }

    public String getRelativeKeyUrl() {
        return null;
    }

    public IMessageList getMessages() {
        return null;
    }

    public IAspect getRelatedAspect(String arg0, LockStrategy arg1, SortingCriteria arg2) {
        return this.getRelatedAspect(arg0, arg1);
    }

    public boolean isAttributeInitial(int attributeIndex) {
        return !this.loadedAttributes.get(attributeIndex);
    }

    public boolean isAttributeInitial(String attributeName) {
        int index = this.getFieldIndex(attributeName);
        return this.isAttributeInitial(index);
    }

    public boolean hasExclusiveLock() {
        return false;
    }

    public boolean hasNoLock() {
        return false;
    }

    public boolean hasSharedLock() {
        return false;
    }

    public boolean hasSharedPromotableLock() {
        return false;
    }

    public boolean isDirty() {
        return this.aspect.getState() == 2 || this.aspect.getState() == 3;
    }

    public ILockState getLockState() {
        return null;
    }

    public int hashCode() {
        return String.valueOf(this.getKey()).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AspectRow) {
            AspectRow ar = (AspectRow)o;
            IKey arKey = ar.getKey();
            if (arKey.getFields() != null && arKey.getFields().length == 0) {
                return arKey.equals(this.getKey()) && ar.getAspect() == this.getAspect() && this.isAttributesEqual(ar);
            }
            return arKey.equals(this.getKey()) && ar.getAspect() == this.getAspect();
        }
        return false;
    }

    private boolean isAttributesEqual(AspectRow ar) {
        IStructureDescriptor arDesc = ar.getDescriptor();
        IStructureDescriptor thisDesc = this.getDescriptor();
        int size = thisDesc.size();
        if (arDesc.size() == size) {
            for (int i = 0; i < size; ++i) {
                String name2;
                IFieldDescriptor fd1 = thisDesc.getFieldDescriptor(i);
                IFieldDescriptor fd2 = arDesc.getFieldDescriptor(i);
                String name1 = fd1.getName();
                if (name1.equals(name2 = fd2.getName())) {
                    Object a1 = this.getAttributeValue(name1);
                    Object a2 = ar.getAttributeValue(name1);
                    if ((a1 != null || a2 == null) && (a1 == null || a1.equals(a2))) continue;
                    return false;
                }
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    protected void calculateReferences() {
        try {
            IRelationDescriptor[] descrs = this.aspect.getDescriptor().getRelationDescriptors();
            for (int i = 0; i < descrs.length; ++i) {
                Collection keys;
                String relationName = descrs[i].getName();
                Aspect relAspect = (Aspect)this.getRelatedFromCache(relationName, LockStrategy.SHARED_READ_ONLY);
                if (relAspect == null) continue;
                String isComplex = relAspect.getDescriptor().getAttributeStringValue("complex_attribute");
                String relationAttribute = Util.getSourceRelationAttribute(descrs[i]);
                if (SCALC_MODE_TRUE.equals(isComplex) && !descrs[i].getAttributeTargetCardinality().isMultiple()) {
                    IEdoTableEx table = relAspect.getAspectData();
                    if (table != null && table.getRecordCount() > 0) {
                        this.getAspectRowData().setProperty(relationAttribute, (Object)table.getRecordDataBean(0));
                    } else {
                        this.getAspectRowData().setProperty(relationAttribute, null);
                    }
                    if (this.aspect.getState() != 0 || relAspect.getState() != 2) continue;
                    this.aspect.setState(2);
                    continue;
                }
                if (descrs[i].getAttributeTargetCardinality().isMultiple()) {
                    if (SCALC_MODE_TRUE.equals(isComplex)) {
                        ArrayList<IDataContainerBean> complexAttrData = new ArrayList<IDataContainerBean>();
                        IEdoTableEx table = relAspect.getAspectData();
                        int size = table.getRecordCount();
                        for (int j = 0; j < size; ++j) {
                            IDataContainerBean val = table.getRecordDataBean(j);
                            if (val == null) continue;
                            complexAttrData.add(val);
                        }
                        this.getAspectRowData().setProperty(relationAttribute, complexAttrData);
                    } else if (SCALC_MODE_TRUE.equals(relAspect.getDescriptor().getAttributeStringValue("collection_support"))) {
                        Collection values = relAspect.getCollectionValues("value");
                        this.getAspectRowData().setProperty(relationAttribute, (Object)values);
                    } else {
                        keys = relAspect.getCollectionStringKeys();
                        this.getAspectRowData().setProperty(relationAttribute, (Object)keys);
                    }
                } else {
                    keys = relAspect.getCollectionStringKeys();
                    if (keys != null && !keys.isEmpty()) {
                        this.getAspectRowData().setProperty(relationAttribute, keys.iterator().next());
                    } else {
                        this.getAspectRowData().setProperty(relationAttribute, null);
                    }
                }
                if (this.aspect.getState() != 0) continue;
                this.aspect.setState(2);
            }
        }
        catch (Exception e) {
            logger.catching((Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HashMap<String, Integer> m = new HashMap<String, Integer>(11);
        m.put("calculable=none", ICALC_MODE_NONE);
        m.put("calculable=false", ICALC_MODE_NONE);
        m.put("calculable=always", ICALC_MODE_ALWAYS);
        m.put("calculable=onchange", ICALC_MODE_ONCHANGE);
        m.put("calculable=true", ICALC_MODE_ONCHANGE);
        CALCULABLE = Collections.unmodifiableMap(m);
    }
}

