/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.rt.ui.cool.generic;

import com.sap.caf.rt.ui.cool.generic.Aspect;
import com.sap.caf.rt.ui.cool.generic.AspectRow;
import com.sap.caf.rt.ui.cool.generic.Key;
import com.sap.caf.rt.ui.cool.generic.KeyList;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class AspectChanges {
    private IStructureDescriptor structureDescriptor;
    private Aspect aspect;
    private static final Location logger = Location.getLocation((Class)(class$com$sap$caf$rt$ui$cool$generic$AspectChanges == null ? (class$com$sap$caf$rt$ui$cool$generic$AspectChanges = AspectChanges.class$("com.sap.caf.rt.ui.cool.generic.AspectChanges")) : class$com$sap$caf$rt$ui$cool$generic$AspectChanges));
    private KeyList deletedKeyList;
    private Map updatedRows = new HashMap();
    private ArrayList insertedRows = new ArrayList();
    private Map insertedRelatedRows = new HashMap();
    private boolean changingAction = false;
    private KeyList deletedKeyList2;
    private Map updatedRows2 = new HashMap();
    private ArrayList insertedRows2 = new ArrayList();
    private Map insertedRelatedRows2 = new HashMap();
    private boolean changingAction2 = false;
    static /* synthetic */ Class class$com$sap$caf$rt$ui$cool$generic$AspectChanges;

    AspectChanges(Aspect aspect) {
        this.structureDescriptor = aspect.getDescriptor().getStructure();
        this.aspect = aspect;
    }

    protected void registerAction() {
        logger.entering("registerAction");
        this.changingAction = true;
        logger.exiting();
    }

    protected void resetAction() {
        logger.entering("resetAction");
        this.collectActionChanges();
        this.changingAction = false;
        logger.exiting();
    }

    private void collectActionChanges() {
        if (this.changingAction) {
            this.changingAction2 = this.changingAction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerInsert(IKey key) {
        logger.entering("registerInsert");
        try {
            if (key == null) {
                throw new IllegalArgumentException("Key of AspectRow '" + this.aspect.getName() + "' is null!");
            }
            this.insertedRows.add(key);
        }
        finally {
            logger.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerInsertRelation(IKey key, IKey sourceKey) {
        logger.entering("registerInsertRelation");
        try {
            if (key == null || sourceKey == null) {
                throw new IllegalArgumentException("Key of AspectRow '" + this.aspect.getName() + "' is null or Key of sourceAspect!");
            }
            this.insertedRelatedRows.put(key, sourceKey);
        }
        finally {
            logger.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerUpdate(IKey key, String fieldName) {
        logger.entering("registerUpdate");
        try {
            if (key == null) {
                throw new IllegalArgumentException("Key of AspectRow '" + this.aspect.getName() + "' is null!");
            }
            if (this.insertedRows.contains(key)) {
                return;
            }
            int index = this.structureDescriptor.getFieldIndex(fieldName);
            if (index < 0) {
                throw new IllegalArgumentException("Illegal field name '" + fieldName + "'");
            }
            if (this.deletedKeyList != null && this.deletedKeyList.contains(key)) {
                if (this.updatedRows.containsKey(key)) {
                    this.updatedRows.remove(key);
                }
                return;
            }
            BitSet changedFields = (BitSet)this.updatedRows.get(key);
            if (changedFields == null) {
                changedFields = new BitSet(this.structureDescriptor.size());
                this.updatedRows.put(key, changedFields);
            }
            changedFields.set(index);
        }
        finally {
            logger.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetAllUpdates() {
        logger.entering("resetAllUpdates");
        try {
            this.collectUpdateChanges();
            this.updatedRows.clear();
        }
        finally {
            logger.exiting();
        }
    }

    private void collectUpdateChanges() {
        Iterator i = this.updatedRows.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object key = entry.getKey();
            if (this.insertedRows2.indexOf(key) >= 0 || this.deletedKeyList2 != null && (this.deletedKeyList2 == null || this.deletedKeyList2.indexOf(key) >= 0)) continue;
            this.updatedRows2.put(key, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetUpdates(int[] rows) {
        logger.entering("resetUpdates");
        try {
            for (int i = 0; i < rows.length; ++i) {
                IAspectRow row = this.aspect.getAspectRow(rows[i]);
                IKey key = row.getKey();
                boolean flag = true;
                flag &= this.insertedRows2 == null ? true : this.insertedRows2.indexOf(key) < 0;
                if (flag &= this.deletedKeyList2 == null ? true : this.deletedKeyList2.indexOf(key) < 0) {
                    this.updatedRows2.put(key, this.updatedRows.get(key));
                }
                this.updatedRows.remove(key);
            }
        }
        finally {
            logger.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetInsert(IKey key) {
        logger.entering("resetInsert");
        try {
            this.collectInsertChange(key);
            this.insertedRows.remove(key);
            this.insertedRelatedRows.remove(key);
        }
        finally {
            logger.exiting();
        }
    }

    private void collectInsertChange(IKey key) {
        if (this.insertedRows2.indexOf(key) < 0) {
            this.insertedRows2.add(key);
            this.insertedRelatedRows2.put(key, this.insertedRelatedRows.get(key));
            this.updatedRows2.remove(key);
            if (this.deletedKeyList2 != null) {
                this.deletedKeyList2.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetAllInserts() {
        logger.entering("resetAllInserts");
        try {
            Iterator i = this.insertedRows.iterator();
            while (i.hasNext()) {
                this.collectInsertChange((IKey)i.next());
            }
            this.insertedRows.clear();
            this.insertedRelatedRows.clear();
        }
        finally {
            logger.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetDeleteButKeyList(IKeyList keyList) {
        logger.entering("resetDeleteButKeyList");
        try {
            if (this.deletedKeyList != null) {
                this.collectDeleteChanges(keyList);
                if (keyList != null) {
                    this.deletedKeyList.retainAll((Collection<?>)keyList);
                } else {
                    this.deletedKeyList.clear();
                }
            }
        }
        finally {
            logger.exiting();
        }
    }

    private void collectDeleteChanges(IKeyList keyList) {
        Iterator i = this.deletedKeyList.iterator();
        while (i.hasNext()) {
            IKey key = (IKey)i.next();
            if (keyList != null && (keyList == null || keyList.indexOf((Object)key) >= 0)) continue;
            this.deletedKeyList2.add(key);
            this.updatedRows2.remove(key);
            this.insertedRows2.remove(key);
            this.insertedRelatedRows2.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerDelete(AspectRow row) {
        logger.entering("registerDelete");
        try {
            Key key = (Key)row.getKey();
            if (this.insertedRows.contains(key)) {
                this.insertedRows.remove(key);
                return;
            }
            BitSet fields = (BitSet)this.updatedRows.get(key);
            if (fields != null) {
                this.updatedRows.remove(key);
            }
            if (this.deletedKeyList == null) {
                this.deletedKeyList = new KeyList(key.getKeyDescriptor());
                this.deletedKeyList2 = new KeyList(key.getKeyDescriptor());
            }
            if (!this.deletedKeyList.contains(key)) {
                this.deletedKeyList.add(key);
            }
        }
        finally {
            logger.exiting();
        }
    }

    protected int[] getInsertedAspectRows() {
        Iterator it = this.insertedRows.iterator();
        int[] indexArray = new int[this.insertedRows.size()];
        int i = 0;
        while (it.hasNext()) {
            AspectRow row = (AspectRow)this.aspect.getAspectRow((IKey)it.next());
            indexArray[i++] = row.getIndex();
        }
        return indexArray;
    }

    protected IKey getRelatedInsertedKey(IKey key) {
        return (IKey)this.insertedRelatedRows.get(key);
    }

    protected IKey getRelatedInsertedKey(int index) {
        if (this.insertedRelatedRows.isEmpty()) {
            return null;
        }
        IKey key = (IKey)this.insertedRows.get(index);
        return this.getRelatedInsertedKey(key);
    }

    protected int[] getChangedAspectRows() {
        Iterator it = this.updatedRows.keySet().iterator();
        int[] indexArray = new int[this.updatedRows.keySet().size()];
        int i = 0;
        while (it.hasNext()) {
            AspectRow row = (AspectRow)this.aspect.getAspectRow((IKey)it.next());
            indexArray[i++] = row.getIndex();
        }
        return indexArray;
    }

    protected KeyList getDeletedKeys() {
        return this.deletedKeyList;
    }

    protected boolean isEmpty() {
        return (this.deletedKeyList == null || this.deletedKeyList.isEmpty()) && this.updatedRows.isEmpty() && this.insertedRows.isEmpty();
    }

    protected void reset() {
        this.resetDeleteButKeyList(null);
        this.resetAllUpdates();
        this.resetAllInserts();
        this.resetAction();
    }

    protected BitSet getChangesState() {
        BitSet changeState = new BitSet(4);
        if (this.insertedRows.size() > 0) {
            changeState.set(0);
        }
        if (this.updatedRows.size() > 0) {
            changeState.set(1);
        }
        if (this.deletedKeyList != null && !this.deletedKeyList.isEmpty()) {
            changeState.set(2);
        }
        if (this.changingAction) {
            changeState.set(3);
        }
        return changeState;
    }

    protected Map getUpdatedRows() {
        return this.updatedRows;
    }

    protected void commitChanges() {
        this.resetCollectedChanges();
    }

    private void resetCollectedChanges() {
        if (this.deletedKeyList2 != null) {
            this.deletedKeyList2.clear();
        }
        this.updatedRows2.clear();
        this.insertedRows2.clear();
        this.insertedRelatedRows2.clear();
        this.changingAction2 = false;
    }

    protected void rollbackChanges() {
        this.updatedRows.clear();
        this.insertedRows.clear();
        this.insertedRelatedRows.clear();
        this.changingAction = false;
        if (this.deletedKeyList != null) {
            this.deletedKeyList.clear();
            this.deletedKeyList.addAll((Collection)this.deletedKeyList2);
        }
        this.updatedRows.putAll(this.updatedRows2);
        this.insertedRows.addAll(this.insertedRows2);
        this.insertedRelatedRows.putAll(this.insertedRelatedRows2);
        this.changingAction = this.changingAction2;
        this.resetCollectedChanges();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

