/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.wsdlImpl.util.xml;

import com.sapportals.portal.prt.service.soap.util.QName;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.WSDLException;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMUtils {
    public static String getAttribute(Element el, String attrName) {
        String sRet = null;
        Attr attr = el.getAttributeNode(attrName);
        if (attr != null) {
            sRet = attr.getValue();
        }
        return sRet;
    }

    public static String getAttribute(Node el, String attrName) {
        String sRet = null;
        NamedNodeMap listattrs = el.getAttributes();
        int i = 0;
        while (i < listattrs.getLength()) {
            Node n = listattrs.item(i);
            if (n.getNodeName().equals(attrName)) {
                sRet = n.getNodeValue();
                break;
            }
            ++i;
        }
        return sRet;
    }

    public static String normalize(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case '&': {
                    sb.append("&#38;");
                    break;
                }
                case '<': {
                    sb.append("&#60;");
                    break;
                }
                case '>': {
                    sb.append("&#62;");
                    break;
                }
                case '\u008b': {
                    sb.append("&#139;");
                    break;
                }
                case '\u009b': {
                    sb.append("&#155;");
                    break;
                }
                case '\u00a0': {
                    sb.append("&#160;");
                    break;
                }
                case '\u00ab': {
                    sb.append("&#171;");
                    break;
                }
                case '\u00b7': {
                    sb.append("&#183;");
                    break;
                }
                case '\u00bb': {
                    sb.append("&#187;");
                    break;
                }
                case '\u00c4': {
                    sb.append("&#196;");
                    break;
                }
                case '\u00d6': {
                    sb.append("&#214;");
                    break;
                }
                case '\u00dc': {
                    sb.append("&#220;");
                    break;
                }
                case '\u00df': {
                    sb.append("&#223;");
                    break;
                }
                case '\u00e1': {
                    sb.append("&#225;");
                    break;
                }
                case '\u00e4': {
                    sb.append("&#228;");
                    break;
                }
                case '\u00e8': {
                    sb.append("&#232;");
                    break;
                }
                case '\u00e9': {
                    sb.append("&#233;");
                    break;
                }
                case '\u00ea': {
                    sb.append("&#234;");
                    break;
                }
                case '\u00f4': {
                    sb.append("&#244;");
                    break;
                }
                case '\u00f6': {
                    sb.append("&#246;");
                    break;
                }
                case '\u00fc': {
                    sb.append("&#252;");
                    break;
                }
                case '\r': {
                    break;
                }
                case '\n': {
                    break;
                }
                case '\t': {
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String denormalize(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == '&') {
                StringBuffer substring = new StringBuffer();
                int length = i + 6;
                if (length > s.length()) {
                    length = s.length();
                }
                int k = i;
                while (k < length) {
                    substring.append(s.charAt(k));
                    if (s.charAt(k) == ';') break;
                    ++k;
                }
                if (substring.length() > 3) {
                    if (substring.charAt(1) != '#' || substring.charAt(substring.length() - 1) != ';') {
                        sb.append(ch);
                    } else {
                        int ascii = 0;
                        int power = 1;
                        int j = substring.length() - 2;
                        while (j >= 2) {
                            try {
                                Integer integer = new Integer("" + substring.charAt(j));
                                ascii += power * integer;
                            }
                            catch (Exception e) {
                                ascii = -1;
                                break;
                            }
                            power *= 10;
                            --j;
                        }
                        if (ascii >= 0) {
                            char character = (char)ascii;
                            sb.append(character);
                            i = i + substring.length() - 1;
                        } else {
                            sb.append(ch);
                        }
                    }
                } else {
                    sb.append(ch);
                }
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String getAttributeNS(Element el, String namespaceURI, String localPart) {
        String sRet = null;
        Attr attr = el.getAttributeNodeNS(namespaceURI, localPart);
        if (attr != null) {
            sRet = attr.getValue();
        }
        return sRet;
    }

    public static String getChildCharacterData(Element parentEl) {
        if (parentEl == null) {
            return null;
        }
        Node tempNode = parentEl.getFirstChild();
        StringBuffer strBuf = new StringBuffer();
        while (tempNode != null) {
            switch (tempNode.getNodeType()) {
                case 3: 
                case 4: {
                    CharacterData charData = (CharacterData)tempNode;
                    strBuf.append(charData.getData());
                }
            }
            tempNode = tempNode.getNextSibling();
        }
        return strBuf.toString();
    }

    public static Element getFirstChildElement(Element elem) {
        Node n = elem.getFirstChild();
        while (n != null) {
            if (n.getNodeType() == 1) {
                return (Element)n;
            }
            n = n.getNextSibling();
        }
        return null;
    }

    public static String getNamespaceURIFromPrefix(Node context, String prefix) {
        short nodeType = context.getNodeType();
        Node tempNode = null;
        switch (nodeType) {
            case 2: {
                tempNode = ((Attr)context).getOwnerElement();
                break;
            }
            case 1: {
                tempNode = context;
                break;
            }
            default: {
                tempNode = context.getParentNode();
                break;
            }
        }
        while (tempNode != null && tempNode.getNodeType() == 1) {
            String namespaceURI;
            Element tempEl = (Element)tempNode;
            String string = namespaceURI = prefix == null ? DOMUtils.getAttribute(tempEl, "xmlns") : DOMUtils.getAttributeNS(tempEl, "http://www.w3.org/2000/xmlns/", prefix);
            if (namespaceURI != null) {
                return namespaceURI;
            }
            tempNode = tempEl.getParentNode();
        }
        return null;
    }

    public static Element getNextSiblingElement(Element elem) {
        Node n = elem.getNextSibling();
        while (n != null) {
            if (n.getNodeType() == 1) {
                return (Element)n;
            }
            n = n.getNextSibling();
        }
        return null;
    }

    public static String getPrefix(String namespaceURI, Definition def) throws WSDLException {
        String prefix = def.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = DOMUtils.getPrefixInWSDLWithImportInclude(def, namespaceURI);
        }
        if (namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            return null;
        }
        if (prefix == null) {
            throw new WSDLException("OTHER_ERROR", "Can't find prefix for '" + namespaceURI + "'. Namespace prefixes must be set on the" + " Definition object using the " + "addNamespace(...) method.");
        }
        return prefix;
    }

    public static String getPrefixInWSDLWithImportInclude(Definition wsdl, String namespace) {
        String prefix = wsdl.getPrefix(namespace);
        if (prefix != null) {
            return prefix;
        }
        Map imports = wsdl.getImports();
        Iterator iter = imports.keySet().iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            Vector listImp = (Vector)wsdl.getImports((String)item);
            int i = 0;
            while (i < listImp.size()) {
                String pref;
                Import imp = (Import)listImp.get(i);
                if (imp.getDefinition() != null && (pref = DOMUtils.getPrefixInWSDLWithImportInclude(imp.getDefinition(), namespace)) != null) {
                    return pref;
                }
                ++i;
            }
        }
        return null;
    }

    public static QName getQualifiedAttributeValue(Element el, String attrName, String elDesc, boolean isRequired) throws WSDLException {
        String attrValue = DOMUtils.getAttribute(el, attrName);
        if (attrValue != null) {
            int index = attrValue.indexOf(58);
            String attrValuePrefix = index != -1 ? attrValue.substring(0, index) : null;
            String attrValueLocalPart = attrValue.substring(index + 1);
            String attrValueNamespaceURI = DOMUtils.getNamespaceURIFromPrefix(el, attrValuePrefix);
            if (attrValueNamespaceURI != null) {
                return new QName(attrValueNamespaceURI, attrValueLocalPart);
            }
            WSDLException wsdlExc = new WSDLException("INVALID_WSDL", "Unable to determine namespace of '" + (attrValuePrefix != null ? attrValuePrefix + ":" : "") + attrValueLocalPart + "'.");
            throw wsdlExc;
        }
        if (isRequired) {
            WSDLException wsdlExc = new WSDLException("INVALID_WSDL", "The '" + attrName + "' attribute must be " + "specified for every " + elDesc + " element.");
            throw wsdlExc;
        }
        return null;
    }

    public static String getQualifiedValue(String namespaceURI, String localPart, Definition def) throws WSDLException {
        String prefix = null;
        if (namespaceURI != null && !namespaceURI.equals("")) {
            prefix = DOMUtils.getPrefix(namespaceURI, def);
        }
        return (prefix != null && !prefix.equals("") ? prefix + ":" : "") + localPart;
    }

    public static int countKids(Element elem, short nodeType) {
        int nkids = 0;
        Node n = elem.getFirstChild();
        while (n != null) {
            if (n.getNodeType() == nodeType) {
                ++nkids;
            }
            n = n.getNextSibling();
        }
        return nkids;
    }

    public static Element findChildElementWithAttribute(Element elem, String attrName, String attrValue) {
        Node n = elem.getFirstChild();
        while (n != null) {
            if (n.getNodeType() == 1 && attrValue.equals(DOMUtils.getAttribute((Element)n, attrName))) {
                return (Element)n;
            }
            n = n.getNextSibling();
        }
        return null;
    }

    public static void printAttribute(String name, String value, PrintWriter pw) {
        if (value != null) {
            pw.print(' ' + name + "=\"" + DOMUtils.normalize(value) + '\"');
        }
    }

    public static String printAttribute(String name, String value) {
        if (value != null) {
            return " " + name + "=\"" + DOMUtils.normalize(value) + "\"";
        }
        return "";
    }

    public static void printQualifiedAttribute(QName name, String value, Definition def, PrintWriter pw) throws WSDLException {
        if (name != null) {
            DOMUtils.printAttribute(DOMUtils.getQualifiedValue(name.getNamespaceURI(), name.getLocalPart(), def), value, pw);
        }
    }

    public static String printQualifiedAttribute(QName name, String value, Definition def) throws WSDLException {
        if (name != null) {
            return DOMUtils.printAttribute(DOMUtils.getQualifiedValue(name.getNamespaceURI(), name.getLocalPart(), def), value);
        }
        return "null";
    }

    public static void printQualifiedAttribute(String name, QName value, Definition def, PrintWriter pw) throws WSDLException {
        if (value != null) {
            DOMUtils.printAttribute(name, DOMUtils.getQualifiedValue(value.getNamespaceURI(), value.getLocalPart(), def), pw);
        }
    }

    public static void throwWSDLException(Element location) throws WSDLException {
        String elName = new QName(location.getNodeName()).toString();
        WSDLException wsdlExc = new WSDLException("INVALID_WSDL", "Encountered unexpected '" + elName + "'.");
        throw wsdlExc;
    }
}

