/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.wsdlImpl.util.xml;

import com.sapportals.portal.prt.service.soap.wsdlImpl.util.ObjectRegistry;
import com.sapportals.portal.prt.service.soap.wsdlImpl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOM2Writer {
    private static final String CHAR_DOUBLEQUOTE = "\"";
    private static final String TAB_SEPARATOR = "\t";
    private static int offset = 0;

    public static String nodeToString(Node node) {
        StringWriter sw = new StringWriter();
        DOM2Writer.serializeAsXML(node, sw, null, true);
        return sw.toString();
    }

    public static String nodeToString(Node node, Definition def) {
        StringWriter sw = new StringWriter();
        DOM2Writer.serializeAsXML(node, sw, def, true);
        return sw.toString();
    }

    public static String nodeToString(Node node, boolean formatedText) {
        StringWriter sw = new StringWriter();
        DOM2Writer.serializeAsXML(node, sw, null, formatedText);
        return sw.toString();
    }

    public static String nodeToString(Node node, Definition def, boolean formatedText) {
        StringWriter sw = new StringWriter();
        DOM2Writer.serializeAsXML(node, sw, def, formatedText);
        return sw.toString();
    }

    public static void serializeAsXML(Node node, Writer writer, Definition def, boolean formatedText) {
        DOM2Writer.print(node, null, new PrintWriter(writer), def, formatedText);
    }

    /*
     * Unable to fully structure code
     */
    private static void print(Node node, ObjectRegistry namespaceStack, PrintWriter out, Definition def, boolean formattedText) {
        if (node == null) {
            return;
        }
        hasChildren = false;
        type = node.getNodeType();
        switch (type) {
            case 9: {
                out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                children = node.getChildNodes();
                if (children == null) break;
                numChildren = children.getLength();
                i = 0;
                while (i < numChildren) {
                    DOM2Writer.print(children.item(i), namespaceStack, out, def, formattedText);
                    ++i;
                }
                break;
            }
            case 1: {
                try {
                    namespaceStack = new ObjectRegistry(namespaceStack);
                    space = "";
                    if (formattedText) {
                        ts = 0;
                        while (ts < DOM2Writer.offset) {
                            space = space + "\t";
                            ++ts;
                        }
                        ++DOM2Writer.offset;
                        out.print("\n" + space + "<");
                    } else {
                        out.print("<");
                    }
                    elPrefix = node.getPrefix();
                    elNamespaceURI = node.getNamespaceURI();
                    if (def != null && node.getNamespaceURI() != null && elPrefix != null && !elPrefix.equals("")) {
                        out.print(DOMUtils.getQualifiedValue(node.getNamespaceURI(), node.getLocalName(), def));
                    } else {
                        out.print(node.getNodeName());
                    }
                    if (elPrefix == null || elNamespaceURI == null) ** GOTO lbl49
                    prefixIsDeclared = false;
                    try {
                        namespaceURI = (String)namespaceStack.lookup(elPrefix);
                        if (elNamespaceURI.equals(namespaceURI)) {
                            prefixIsDeclared = true;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        if (def.getNamespace(elPrefix) == null) ** GOTO lbl47
                        prefixIsDeclared = true;
                    }
lbl47:
                    // 3 sources

                    if (!prefixIsDeclared) {
                        DOM2Writer.printNamespaceDecl(node, namespaceStack, out);
                    }
lbl49:
                    // 4 sources

                    len = (attrs = node.getAttributes()) != null ? attrs.getLength() : 0;
                    i = 0;
                    while (i < len) {
                        attr = (Attr)attrs.item(i);
                        attrPrefix = attr.getPrefix();
                        attrNamespaceURI = attr.getNamespaceURI();
                        if (def != null && attr.getNamespaceURI() != null && (attrPrefix == null || attrPrefix.equals(""))) {
                            try {
                                out.print(" " + DOMUtils.getQualifiedValue(attr.getNamespaceURI(), attr.getLocalName(), def) + "=\"" + DOMUtils.normalize(attr.getValue()) + "\"");
                            }
                            catch (WSDLException e) {
                                out.print(" " + attr.getNodeName() + "=\"" + DOMUtils.normalize(attr.getValue()) + "\"");
                            }
                        } else {
                            out.print(" " + attr.getNodeName() + "=\"" + DOMUtils.normalize(attr.getValue()) + "\"");
                        }
                        if (attrPrefix == null || attrNamespaceURI == null) ** GOTO lbl75
                        prefixIsDeclared = false;
                        try {
                            namespaceURI = (String)namespaceStack.lookup(attrPrefix);
                            if (attrNamespaceURI.equals(namespaceURI)) {
                                prefixIsDeclared = true;
                            }
                        }
                        catch (IllegalArgumentException e) {
                            if (def.getNamespace(elPrefix) == null) ** GOTO lbl73
                            prefixIsDeclared = true;
                        }
lbl73:
                        // 3 sources

                        if (!prefixIsDeclared) {
                            DOM2Writer.printNamespaceDecl(attr, namespaceStack, out);
                        }
lbl75:
                        // 4 sources

                        ++i;
                    }
                    children = node.getChildNodes();
                    if (children != null) {
                        numChildren = children.getLength();
                        v0 = hasChildren = numChildren > 0;
                        if (hasChildren) {
                            out.print(">");
                        }
                        i = 0;
                        while (i < numChildren) {
                            DOM2Writer.print(children.item(i), namespaceStack, out, def, formattedText);
                            ++i;
                        }
                    } else {
                        hasChildren = false;
                    }
                    if (hasChildren) break;
                    out.print("/>");
                    --DOM2Writer.offset;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 5: {
                out.print('&');
                out.print(node.getNodeName());
                out.print(';');
                break;
            }
            case 4: {
                out.print("<![CDATA[");
                out.print(node.getNodeValue());
                out.print("]]>\n");
                break;
            }
            case 3: {
                break;
            }
            case 8: {
                out.print("<!--\n");
                out.print(node.getNodeValue());
                out.print("\n-->");
                break;
            }
            case 7: {
                out.print("<?");
                out.print(node.getNodeName());
                data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    out.print(' ');
                    out.print(data);
                }
                out.println("?>");
                break;
            }
        }
        if (type == 1 && hasChildren) {
            space = "";
            --DOM2Writer.offset;
            if (formattedText) {
                ts = 0;
                while (ts < DOM2Writer.offset) {
                    space = space + "\t";
                    ++ts;
                }
                out.print("\n" + space + "</");
            } else {
                out.print("</");
            }
            elPrefix = node.getPrefix();
            if (def != null && node.getNamespaceURI() != null && elPrefix != null && !elPrefix.equals("")) {
                try {
                    out.print(DOMUtils.getQualifiedValue(node.getNamespaceURI(), node.getLocalName(), def));
                }
                catch (Exception ex) {
                    ex.printStackTrace(out);
                }
            } else {
                out.print(node.getNodeName());
            }
            out.print(">");
            hasChildren = false;
        }
    }

    private static void printNamespaceDecl(Node node, ObjectRegistry namespaceStack, PrintWriter out) {
        switch (node.getNodeType()) {
            case 2: {
                DOM2Writer.printNamespaceDecl(((Attr)node).getOwnerElement(), node, namespaceStack, out);
                break;
            }
            case 1: {
                DOM2Writer.printNamespaceDecl((Element)node, node, namespaceStack, out);
            }
        }
    }

    private static void printNamespaceDecl(Element owner, Node node, ObjectRegistry namespaceStack, PrintWriter out) {
        String namespaceURI = node.getNamespaceURI();
        String prefix = node.getPrefix();
        if (!namespaceURI.equals("http://www.w3.org/2000/xmlns/") || !prefix.equals("xmlns")) {
            if (DOMUtils.getAttributeNS(owner, "http://www.w3.org/2000/xmlns/", prefix) == null) {
                out.print(" xmlns:" + prefix + "=\"" + namespaceURI + '\"');
            }
        } else {
            prefix = node.getLocalName();
            namespaceURI = node.getNodeValue();
        }
        namespaceStack.register(prefix, namespaceURI);
    }

    public static void serializeAsXML(Element element, PrintWriter pw) {
        DOM2Writer.print(element, null, pw, null, true);
    }

    public static void serializeAsXML(Element element, PrintWriter pw, boolean formatedText) {
        DOM2Writer.print(element, null, pw, null, formatedText);
    }

    public static void serializeAsXML(Element element, PrintWriter pw, Definition def) {
        DOM2Writer.print(element, null, pw, def, true);
    }

    public static void serializeAsXML(Element element, PrintWriter pw, Definition def, boolean formatedText) {
        DOM2Writer.print(element, null, pw, def, formatedText);
    }
}

