/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.util;

import com.sapportals.portal.prt.service.soap.ISOAPMessageContext;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultInternalError;
import com.sapportals.portal.prt.service.soap.exception.PRTFaultSerializator;
import com.sapportals.portal.prt.service.soap.util.QName;
import com.sapportals.portal.prt.service.soap.util.QNameURI;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;

public class XMLValueExtractor {
    public static QName getQNameForAttribute(SOAPElement element, Name name, ISOAPMessageContext context) {
        if (name != null) {
            if (name.getLocalName().equals("type")) {
                String value = element.getAttributeValue(name);
                return XMLValueExtractor.getQNameForAttributeValue(value, context);
            }
            if (name.getLocalName().equals("arrayType")) {
                return XMLValueExtractor.getArrayTypeForAttributeValue(name, context);
            }
        }
        return null;
    }

    public static QName getQNameForElement(SOAPElement element, ISOAPMessageContext context, boolean arrayType) {
        if (context.isDocumentStyleEncoding()) {
            return null;
        }
        QName n = null;
        if (element != null) {
            Iterator iter = element.getAllAttributes();
            while (iter.hasNext()) {
                Name name = (Name)iter.next();
                if (name.getLocalName().equals("type") && !arrayType) {
                    String value = element.getAttributeValue(name);
                    n = XMLValueExtractor.getQNameForAttributeValue(value, context);
                }
                if (!name.getLocalName().equals("arrayType")) continue;
                n = XMLValueExtractor.getQNameForAttributeValue(name.getPrefix() + ":Array", context);
            }
        }
        return n;
    }

    public static QName getQNameForElement(SOAPElement element, ISOAPMessageContext context) {
        return XMLValueExtractor.getQNameForElement(element, context, false);
    }

    public static QNameURI getQNameURIForElement(SOAPElement element, ISOAPMessageContext context) {
        return XMLValueExtractor.getQNameURIForElement(element, context, false);
    }

    public static QNameURI getQNameURIForElement(SOAPElement element, ISOAPMessageContext context, boolean arrayType) {
        if (context.isDocumentStyleEncoding()) {
            return null;
        }
        QNameURI n = null;
        if (element != null) {
            Iterator iter = element.getAllAttributes();
            while (iter.hasNext()) {
                String value;
                QName qname;
                Name name = (Name)iter.next();
                if (name.getLocalName().equals("type") && !arrayType && (qname = XMLValueExtractor.getQNameForAttributeValue(value = element.getAttributeValue(name), context)) != null) {
                    n = new QNameURI(qname, name.getURI());
                }
                if (!name.getLocalName().equals("arrayType")) continue;
                QName qname2 = null;
                if (arrayType) {
                    String value2 = element.getAttributeValue(name);
                    String cutvalue = XMLValueExtractor.cutArray(value2);
                    qname2 = XMLValueExtractor.getQNameForAttributeValue(cutvalue, context);
                } else {
                    qname2 = XMLValueExtractor.getQNameForAttributeValue(name.getPrefix() + ":Array", context);
                }
                if (qname2 == null) continue;
                n = new QNameURI(qname2, name.getURI());
            }
        }
        return n;
    }

    public static Name getNameForReference(SOAPElement element, ISOAPMessageContext context) {
        Name value = null;
        if (element != null) {
            Iterator iter = element.getAllAttributes();
            while (iter.hasNext()) {
                Name name = (Name)iter.next();
                String localName = name.getLocalName();
                if (!localName.equals("href")) continue;
                value = name;
            }
        }
        return value;
    }

    public static QName getQNameForAttributeValue(String value, ISOAPMessageContext context) {
        int index;
        if (value != null && (index = value.indexOf(58)) != -1) {
            String valuePrefix = value.substring(0, index);
            String valueLocalPart = value.substring(index + 1);
            String valueNamespaceURI = context.getNamespaceFromPrefix(valuePrefix);
            if (valueNamespaceURI != null) {
                return new QName(valueNamespaceURI, valueLocalPart);
            }
            throw new IllegalStateException("Namespace not found for the prefix " + valuePrefix);
        }
        return null;
    }

    public static QName getQNameForAttributeValueFromConfig(String value, String namespace) {
        int index;
        if (value != null && (index = value.indexOf(58)) != -1) {
            String valueLocalPart = value.substring(index + 1);
            if (namespace != null) {
                return new QName(namespace, valueLocalPart);
            }
        }
        return null;
    }

    private static QName getArrayTypeForAttributeValue(Name name, ISOAPMessageContext context) {
        return new QName(context.getNamespaceFromPrefix(name.getPrefix()), name.getLocalName());
    }

    private static String cutArray(String arrayTypeAndSize) {
        int leftBracketIndex = arrayTypeAndSize.lastIndexOf(91);
        int rightBracketIndex = arrayTypeAndSize.lastIndexOf(93);
        if (leftBracketIndex == -1 || rightBracketIndex == -1 || rightBracketIndex < leftBracketIndex) {
            throw new PRTFaultSerializator("Malformed arrayTypeValue '" + arrayTypeAndSize + "'.", null, new IllegalArgumentException("Malformed arrayTypeValue '" + arrayTypeAndSize + "'."));
        }
        String typeName = arrayTypeAndSize.substring(0, leftBracketIndex);
        return typeName;
    }

    public static SOAPElement getSOAPElementFromRef(SOAPElement param, ISOAPMessageContext context) throws PRTFaultInternalError {
        Name nameRef = XMLValueExtractor.getNameForReference(param, context);
        if (nameRef != null) {
            SOAPBodyElement multiref;
            String key = param.getAttributeValue(nameRef);
            if (key == null) {
                throw new PRTFaultInternalError((Object)param, new IllegalArgumentException("The id is empty to find the ref"));
            }
            int index = key.indexOf("#");
            if (index != -1) {
                key = key.substring(index + 1);
            }
            if ((multiref = context.getId(key)) != null) {
                Name nameRefFound = XMLValueExtractor.getNameForReference((SOAPElement)multiref, context);
                if (nameRefFound == null) {
                    return multiref;
                }
                return XMLValueExtractor.getSOAPElementFromRef((SOAPElement)multiref, context);
            }
            throw new PRTFaultInternalError((Object)param, new IllegalArgumentException("The soap element is not found from the ref '" + key + "'"));
        }
        return param;
    }

    public static boolean isValueNull(SOAPElement element) {
        Iterator iter = element.getAllAttributes();
        while (iter.hasNext()) {
            Name attr = (Name)iter.next();
            if (attr.getLocalName().equals("null") && (element.getAttributeValue(attr).equals("true") || element.getAttributeValue(attr).equals("1"))) {
                return true;
            }
            if (attr.getLocalName().equals("nillable") && (element.getAttributeValue(attr).equals("true") || element.getAttributeValue(attr).equals("1"))) {
                return true;
            }
            if (!attr.getLocalName().equals("nil") || !element.getAttributeValue(attr).equals("true") && !element.getAttributeValue(attr).equals("1")) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static String getAttributeValue(SOAPElement element, String attribute_name) {
        iter = element.getAllAttributes();
        if (iter != null) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            attrName = (Name)iter.next();
            if (!attrName.getLocalName().equals(attribute_name)) continue;
            return element.getAttributeValue(attrName);
lbl7:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl8:
        // 1 sources

        return null;
    }
}

