/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.types;

import com.sapportals.portal.prt.service.soap.types.NormalizedString;
import com.sapportals.portal.prt.service.soap.wsdlImpl.util.xml.DOMUtils;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLData {
    private Element mm_content;
    private String mm_rawContent;
    private boolean mm_XMLHandlingOk = false;

    public XMLData() {
        this.mm_content = null;
        this.mm_XMLHandlingOk = false;
    }

    public XMLData(Element element) {
        this.mm_content = element;
        this.mm_XMLHandlingOk = true;
    }

    public XMLData(String element) throws Exception {
        this.mm_rawContent = element;
        this.mm_XMLHandlingOk = false;
        this.setContent(new NormalizedString(element));
    }

    public XMLData(NormalizedString element) throws Exception {
        this.mm_XMLHandlingOk = false;
        this.mm_rawContent = element.getContentNoNormalized();
        this.setContent(element);
    }

    public NormalizedString getContent() {
        if (this.mm_content != null && this.mm_XMLHandlingOk) {
            NormalizedString data = this.transformContentAsNormalizedString();
            if (data != null) {
                return data;
            }
            return null;
        }
        return null;
    }

    public void setContent(NormalizedString data) throws Exception {
        if (data != null) {
            StringBuffer dataConverted = new StringBuffer();
            dataConverted.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><RootNode__to_extract>");
            dataConverted.append(data.getContentNoNormalized());
            dataConverted.append("</RootNode__to_extract>");
            ByteArrayInputStream inputSource = new ByteArrayInputStream(dataConverted.toString().getBytes());
            Document dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputSource);
            NodeList list = dom.getChildNodes();
            if (list.getLength() < 1) {
                this.mm_XMLHandlingOk = false;
                throw new IllegalArgumentException("data empty in the DOM Object");
            }
            NodeList listXMLDataChilds = ((Element)list.item(0)).getChildNodes();
            if (listXMLDataChilds.getLength() < 1) {
                this.mm_XMLHandlingOk = false;
                throw new IllegalArgumentException("no element in the DOM Object");
            }
            int i = 0;
            while (i < listXMLDataChilds.getLength()) {
                Node node = listXMLDataChilds.item(i);
                if (node.getNodeType() == 1) {
                    this.mm_content = (Element)node;
                    this.mm_XMLHandlingOk = true;
                    break;
                }
                ++i;
            }
            if (this.mm_content == null) {
                this.mm_XMLHandlingOk = false;
            }
        }
    }

    public String transformContentAsString() {
        if (!this.mm_XMLHandlingOk) {
            throw new IllegalArgumentException("data empty after the deserialization of the XML content [transformContentAsString]");
        }
        if (this.mm_content != null) {
            return this.mm_content.toString();
        }
        return null;
    }

    public void insertContentInSOAPElement(SOAPElement parent, SOAPEnvelope env) {
        if (this.mm_content == null) {
            throw new IllegalArgumentException("data empty of XML content [insertContentInSOAPElement]");
        }
        this.insertContentInSOAPElement(this.mm_content, parent, env);
    }

    private void insertContentInSOAPElement(Element source, SOAPElement parent, SOAPEnvelope env) {
        if (source != null) {
            try {
                SOAPElement element = parent.addChildElement(source.getLocalName());
                NamedNodeMap attrs = source.getAttributes();
                if (attrs != null) {
                    int i = 0;
                    while (i < attrs.getLength()) {
                        Attr attr = (Attr)attrs.item(i);
                        Name nAttr = env.createName(attr.getName());
                        element.addAttribute(nAttr, attr.getValue());
                        ++i;
                    }
                }
                if (source.getNodeValue() != null) {
                    element.addTextNode(source.getNodeValue());
                }
                if (source.hasChildNodes()) {
                    NodeList list = source.getChildNodes();
                    int i = 0;
                    while (i < list.getLength()) {
                        Node node = list.item(i);
                        if (node.getNodeType() == 1) {
                            this.insertContentInSOAPElement((Element)node, element, env);
                        }
                        if (node.getNodeType() == 3) {
                            element.addTextNode(((Text)node).getData());
                        }
                        ++i;
                    }
                }
            }
            catch (SOAPException e) {
                throw new IllegalStateException("Error during the insert [" + e.toString() + "]");
            }
        }
    }

    public Element transformContentAsElement() {
        if (!this.mm_XMLHandlingOk) {
            throw new IllegalArgumentException("data empty after the deserialization of the XML content [transformContentAsElement]");
        }
        if (this.mm_content == null) {
            throw new IllegalArgumentException("data empty after the deserialization of the XML content [transformContentAsElement]");
        }
        return this.mm_content;
    }

    public NormalizedString transformContentAsNormalizedString() {
        if (!this.mm_XMLHandlingOk) {
            return null;
        }
        if (this.mm_content != null) {
            String contentConverted = this.transformContentAsString();
            if (contentConverted != null) {
                return new NormalizedString(contentConverted);
            }
            return null;
        }
        return null;
    }

    public static void main(String[] args) {
        String TEST_CONTENT = "dhdhiwdhfeiw";
        NormalizedString TEST_CONTENT_NORM = new NormalizedString(TEST_CONTENT, false);
        System.out.println("validate NORMALIZE");
        System.out.println(NormalizedString.validateNormalizedStringRepresentation(DOMUtils.normalize(TEST_CONTENT)));
        System.out.println("validate BASE");
        System.out.println(NormalizedString.validateNormalizedStringRepresentation(TEST_CONTENT));
        System.out.println("step 1. Test NormalizedString.toString()");
        System.out.println(TEST_CONTENT_NORM);
        if (TEST_CONTENT_NORM.getContentNormalized().equals(DOMUtils.normalize(TEST_CONTENT))) {
            System.out.println("step 1. Test NormalizedString Compare OK ");
        } else {
            System.out.println("step 1. Test NormalizedString Compare Fail ");
        }
        System.out.println("\n\n--------------");
        try {
            System.out.println("step 2.1 Test XMLData constructor empty");
            XMLData typetest = new XMLData();
            System.out.println(typetest);
            System.out.println("step 2.2 Test XMLData constructor String");
            typetest = new XMLData(TEST_CONTENT);
            Element ref1 = typetest.transformContentAsElement();
            System.out.println("step 2.3 Test XMLData constructor NormalizedString");
            typetest = new XMLData(TEST_CONTENT_NORM);
            Element ref2 = typetest.transformContentAsElement();
        }
        catch (Exception e2) {
            System.out.println("Step 2 fail !");
            e2.printStackTrace();
        }
        System.out.println("\n\n--------------");
        XMLData type = new XMLData();
        try {
            type.setContent(TEST_CONTENT_NORM);
            System.out.println("step 3. Test setContent method Ok!");
        }
        catch (Exception e) {
            System.out.println("step 3. Test setContent method fail!");
            e.printStackTrace();
        }
        NormalizedString contentreturn = type.getContent();
        if (contentreturn == null) {
            System.out.println("step 4.error1 Test getContent method fail!");
        } else if (contentreturn.equals(TEST_CONTENT_NORM)) {
            System.out.println("step 4. Test getContent method OK!");
        } else {
            System.out.println("step 4.error2 Test getContent method fail!");
        }
        NormalizedString contentNormalized = type.getContent();
        if (contentNormalized == null) {
            System.out.println("step 5.error1 Test transformContentAsNormalizedString method fail!");
        } else {
            System.out.println("step 5. " + contentNormalized.getContentNormalized());
        }
        Element el = type.transformContentAsElement();
        if (el == null) {
            System.out.println("step 6.error1 Test transformContentAsNormalizedString method fail!");
        } else {
            System.out.println("step 6. " + el);
        }
    }

    public String toString() {
        return this.mm_content != null ? this.mm_content.toString() : "null";
    }

    public boolean equals(Object obj) {
        return this.transformContentAsString().equals(((XMLData)obj).transformContentAsString());
    }

    public String getRawContent() {
        if (this.mm_rawContent == null && this.mm_XMLHandlingOk) {
            return this.getContent().toString();
        }
        return this.mm_rawContent;
    }

    public boolean isXMLHandlingOk() {
        return this.mm_XMLHandlingOk;
    }
}

