/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.types;

import com.sapportals.portal.prt.service.soap.wsdlImpl.util.xml.DOMUtils;

public class Token {
    private String mm_content = null;
    private String mm_contentTokenized = null;

    public Token() {
    }

    public Token(String content) {
        this.mm_content = content;
        String normalized = DOMUtils.normalize(content);
        this.mm_contentTokenized = this.tokenize(normalized);
    }

    public Token(String content, boolean bool) {
        this.mm_content = content;
        if (bool) {
            Token.validateTokenRepresentation(content);
            String normalized = DOMUtils.normalize(content);
            this.mm_contentTokenized = this.tokenize(normalized);
        } else {
            String normalized = DOMUtils.normalize(content);
            this.mm_contentTokenized = this.tokenize(normalized);
        }
    }

    public static boolean validateTokenRepresentation(String s) throws IllegalArgumentException {
        if (s.charAt(0) == ' ' || s.charAt(s.length() - 1) == ' ') {
            throw new IllegalArgumentException("Lexical Representation Error: string to be tokenized may not contain leading nor trailing spaces");
        }
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\n' || s.charAt(i) == '\t' || s.charAt(i) == ' ' && i + 1 < s.length() && s.charAt(i + 1) == ' ') {
                throw new IllegalArgumentException("Lexical Representation Error: string to be tokenized may not contain line feed,tab characters nor internal set of two or more spaces ");
            }
            ++i;
        }
        return true;
    }

    public String tokenize(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        boolean isFirstChar = true;
        boolean isFirstSpace = true;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case ' ': {
                    if (isFirstChar || !isFirstSpace) break;
                    sb.append(c);
                    isFirstSpace = false;
                    break;
                }
                default: {
                    if (isFirstChar) {
                        isFirstChar = false;
                    }
                    sb.append(c);
                    isFirstSpace = true;
                }
            }
            ++i;
        }
        if (sb.charAt(sb.length() - 1) == ' ') {
            return sb.substring(0, sb.length() - 1).toString();
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            Token t = new Token("   < component name= \"ACLMappingComponent\">   <\t\tcomponent-config >   ", false);
            System.out.println(t.getContentTokenized());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getContent() {
        return this.mm_content;
    }

    public String getContentTokenized() {
        return this.mm_contentTokenized;
    }

    public void setContent(String string) {
        this.mm_content = string;
    }

    public void setContentTokenized(String string) {
        this.mm_contentTokenized = string;
    }
}

