/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.types;

import com.sapportals.portal.prt.service.soap.util.DateUtilFormat;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Time {
    public static final int TIME_ZONE_INDEX = 8;
    private String mm_content = null;
    private String mm_hour = null;
    private String mm_minute = null;
    private String mm_second = null;
    private int timeZone_index;
    private boolean mm_isDecimalSecond = false;
    private String mm_timeZone = null;
    private String mm_hourTZ = null;
    private String mm_minuteTZ = null;
    private boolean mm_isCanonical = true;

    public Time(String exp) {
        this.mm_content = exp;
        int exp_length = this.mm_content.length();
        this.timeZone_index = this.mm_content.indexOf(90);
        if (this.timeZone_index == -1) {
            this.timeZone_index = this.mm_content.indexOf(45);
        }
        if (this.timeZone_index == -1) {
            this.timeZone_index = this.mm_content.indexOf(43);
        }
        if (this.mm_content.indexOf(46) == 8) {
            this.mm_isDecimalSecond = true;
        }
        if (this.timeZone_index != -1 && this.timeZone_index != 8 && !this.mm_isDecimalSecond) {
            throw new IllegalArgumentException("Lexical Representation Error: (with time zone and without decimal second) time field must have exactly eight digits HH:MM:SS");
        }
        if (this.timeZone_index == -1 && exp_length != 8 && !this.mm_isDecimalSecond) {
            throw new IllegalArgumentException("Lexical Representation Error: (without time zone and decimal second) time field must have excatly eight digits HH:MM:SS");
        }
        StringTokenizer stk = new StringTokenizer(exp, ":");
        try {
            this.mm_hour = stk.nextToken();
            DateUtilFormat.isDateDigit(this.mm_hour, "hh");
            this.mm_minute = stk.nextToken();
            DateUtilFormat.isDateDigit(this.mm_minute, "mm");
            if (!this.mm_isDecimalSecond) {
                this.mm_second = stk.nextToken().substring(0, 2);
                DateUtilFormat.isDateDigit(this.mm_second, "ss");
            } else if (this.timeZone_index == -1) {
                this.mm_second = stk.nextToken();
                DateUtilFormat.isSecondDigit(this.mm_second, "ss.s");
            } else {
                this.mm_second = exp.substring(6, this.timeZone_index);
                DateUtilFormat.isSecondDigit(this.mm_second, "ss.s");
            }
        }
        catch (NoSuchElementException nsee) {
            throw new IllegalArgumentException("Lexical Representation Error: time field must be HH:MM:SS");
        }
        if (this.timeZone_index != -1) {
            this.mm_timeZone = exp.substring(this.timeZone_index);
            if (!this.mm_timeZone.equals("Z")) {
                this.mm_isCanonical = false;
                if (this.mm_timeZone.length() != 6) {
                    throw new IllegalArgumentException("Lexical Representation Error: the hours and minutes parts are required");
                }
                stk = new StringTokenizer(this.mm_timeZone, ":");
                try {
                    this.mm_hourTZ = stk.nextToken();
                    DateUtilFormat.isDateDigit(this.mm_hourTZ.substring(1, this.mm_hourTZ.length()), "hh of time zone field");
                    this.mm_minuteTZ = stk.nextToken();
                    DateUtilFormat.isDateDigit(this.mm_minuteTZ, "mm of time zone field");
                }
                catch (NoSuchElementException nsee) {
                    throw new IllegalArgumentException("Lexical Representation Error: illegal time zone format ");
                }
            }
        }
    }

    public String getRepresentation() {
        String res = "";
        if (this.mm_hour != null) {
            res = res + this.mm_hour;
        }
        if (this.mm_minute != null) {
            res = res + ":" + this.mm_minute;
        }
        if (this.mm_second != null) {
            res = res + ":" + this.mm_second;
        }
        if (this.mm_timeZone != null) {
            res = res + this.mm_timeZone;
        }
        return res;
    }

    public static int getTIME_ZONE_INDEX() {
        return 8;
    }

    public String getHour() {
        return this.mm_hour;
    }

    public String getHourTZ() {
        return this.mm_hourTZ;
    }

    public String getMinute() {
        return this.mm_minute;
    }

    public String getMinuteTZ() {
        return this.mm_minuteTZ;
    }

    public String getSecond() {
        return this.mm_second;
    }

    public String getTimeZone() {
        return this.mm_timeZone;
    }

    public int getTimeZone_index() {
        return this.timeZone_index;
    }

    public void setHour(String string) {
        this.mm_hour = string;
    }

    public void setHourTZ(String string) {
        this.mm_hourTZ = string;
    }

    public void setMinute(String string) {
        this.mm_minute = string;
    }

    public void setMinuteTZ(String string) {
        this.mm_minuteTZ = string;
    }

    public void setSecond(String string) {
        this.mm_second = string;
    }

    public void setTimeZone(String string) {
        this.mm_timeZone = string;
    }

    public void setTimeZone_index(int i) {
        this.timeZone_index = i;
    }

    public static void main(String[] args) {
        try {
            Time md1 = new Time("21:06:01");
            System.out.println("md1 " + md1.getRepresentation());
            Time md2 = new Time("21:06:01Z");
            System.out.println("md2 " + md2.getRepresentation());
            Time md3 = new Time("21:06:01+01:12");
            System.out.println("md3 " + md3.getRepresentation());
            Time md4 = new Time("21:06:01.123");
            System.out.println("md4 " + md4.getRepresentation());
            Time md5 = new Time("21:06:01.120Z");
            System.out.println("md5 " + md5.getRepresentation());
            Time md6 = new Time("12:04:01.20-09:10");
            System.out.println("md6 " + md6.getRepresentation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

