/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.types;

import com.sapportals.portal.prt.service.soap.wsdlImpl.util.xml.DOMUtils;

public class NormalizedString {
    private String mm_content = null;
    private String mm_contentNormalized = null;

    public NormalizedString() {
    }

    public NormalizedString(String content) {
        this.mm_content = content;
        this.mm_contentNormalized = DOMUtils.normalize(content);
    }

    public NormalizedString(String content, boolean bool) {
        this.mm_content = content;
        if (bool) {
            NormalizedString.validateNormalizedStringRepresentation(content);
            this.mm_contentNormalized = DOMUtils.normalize(content);
        } else {
            this.mm_contentNormalized = DOMUtils.normalize(content);
        }
    }

    public String getContentNoNormalized() {
        return this.mm_content;
    }

    public String getContentNormalized() {
        return this.mm_contentNormalized;
    }

    public void setContentNoNormalized(String content) {
        this.mm_content = content;
        if (this.mm_contentNormalized == null) {
            this.mm_contentNormalized = DOMUtils.normalize(this.mm_content);
        }
    }

    public void setContentNormalized(String content) {
        this.mm_contentNormalized = content;
        if (this.mm_content == null) {
            this.mm_content = DOMUtils.denormalize(this.mm_contentNormalized);
        }
    }

    public String toString() {
        return "[BASE] " + this.mm_content + "\n[NORMALIZED] " + this.mm_contentNormalized;
    }

    public boolean equals(Object obj) {
        NormalizedString valueToCompare = (NormalizedString)obj;
        if (this.getContentNormalized() == null || this.getContentNoNormalized() == null) {
            return false;
        }
        if (valueToCompare.getContentNormalized() == null || valueToCompare.getContentNoNormalized() == null) {
            return false;
        }
        return this.getContentNormalized().equals(valueToCompare.getContentNormalized()) && this.getContentNoNormalized().equals(valueToCompare.getContentNoNormalized());
    }

    public static boolean validateNormalizedStringRepresentation(String s) throws IllegalArgumentException {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\r' || s.charAt(i) == '\n' || s.charAt(i) == '\t') {
                throw new IllegalArgumentException("Lexical Representation Error: string to be normalized may not contain carriage return, line feed nor tab characters");
            }
            ++i;
        }
        return true;
    }
}

