/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.types;

public class NegativeInteger {
    private String mm_content = null;
    private int mm_value;

    public NegativeInteger(String s) {
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException("Lexical Representation Error: String to be analyzed cannot be empty");
        }
        if (s.charAt(0) != '-') {
            throw new IllegalArgumentException("Lexical Representation Error: representation must start with negative sign");
        }
        try {
            this.mm_value = Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Lexical Representation Error: cannot convert representation into integer with radix 10");
        }
        if (this.mm_value > -1) {
            throw new IllegalArgumentException("Lexical Representation Error: the value of maxInclusive must be -1");
        }
    }

    public String toString() {
        return Integer.toString(this.mm_value);
    }

    public String getContent() {
        return this.mm_content;
    }

    public int getValue() {
        return this.mm_value;
    }

    public void setContent(String string) {
        this.mm_content = string;
    }

    public void setValue(int i) {
        this.mm_value = i;
    }

    public static void main(String[] args) {
        try {
            NegativeInteger npi = new NegativeInteger("-123njkp");
            System.out.println(npi.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

