/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.types;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Language {
    private String mm_content = null;
    private String mm_mainTag = null;
    private String mm_subTag = null;

    public Language(String s) {
        this.mm_content = s;
        if (this.mm_content.length() < 2) {
            throw new IllegalArgumentException("Lexical Representation Error: there must be at least the primary tag composed of two letters");
        }
        this.mm_mainTag = s.substring(0, 2);
        if (this.mm_content.length() > 2) {
            StringTokenizer stk = new StringTokenizer(this.mm_content, "-");
            try {
                stk.nextToken();
                this.mm_subTag = stk.nextToken();
            }
            catch (NoSuchElementException nsee) {
                throw new IllegalArgumentException("Lexical Representation Error: Language Format must be Primary-tag *( - Subtag )");
            }
        }
    }

    public String getRepresentation() {
        String res = "";
        if (this.mm_mainTag != null) {
            res = res + this.mm_mainTag;
        }
        if (this.mm_subTag != null) {
            res = res + "-" + this.mm_subTag;
        }
        return res;
    }

    public String getContent() {
        return this.mm_content;
    }

    public String getMm_mainTag() {
        return this.mm_mainTag;
    }

    public String getSubTag() {
        return this.mm_subTag;
    }

    public void setContent(String string) {
        this.mm_content = string;
    }

    public void setMainTag(String string) {
        this.mm_mainTag = string;
    }

    public void setSubTag(String string) {
        this.mm_subTag = string;
    }

    public static void main(String[] args) {
        try {
            Language md1 = new Language("en-US");
            System.out.println("main tag: " + md1.getMm_mainTag());
            System.out.println("sub tag : " + md1.getSubTag());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

