/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.types;

import com.sapportals.portal.prt.service.soap.util.DateUtilFormat;

public class GMonthDay {
    private String mm_content = null;
    private String mm_month = null;
    private String mm_day = null;
    private String mm_timeZone = null;

    public GMonthDay(String exp) {
        this.mm_content = exp;
        if (exp.length() != 7 && exp.length() != 8 && exp.length() != 13) {
            throw new IllegalArgumentException("Lexical Representation Error: month-day field must have _ 7 digits --MM-DD +\n_ 8 digits --MM-DDZ or \n_ 13 digits --MM-DD(+|-)hh:mm.");
        }
        String temp = exp.substring(0, 7);
        if (exp.charAt(0) != '-' || exp.charAt(1) != '-' || exp.charAt(4) != '-') {
            throw new IllegalArgumentException("Lexical Representation Error: representation for date is --MM-DD (bad index of first '-' sign) ");
        }
        this.mm_month = exp.substring(2, 4);
        GMonthDay.isDigit(this.mm_month, "MM");
        this.mm_day = exp.substring(5, 7);
        GMonthDay.isDigit(this.mm_day, "DD");
        if (exp.length() == 8 || exp.length() == 13) {
            this.mm_timeZone = exp.substring(7);
            DateUtilFormat.isCorrectTimeZone(this.mm_timeZone);
        }
    }

    public String getRepresentation() {
        String res = "--";
        if (this.mm_month != null) {
            res = res + this.mm_month;
        }
        if (this.mm_day != null) {
            res = res + "-" + this.mm_day;
        }
        if (this.mm_timeZone != null) {
            res = res + this.mm_timeZone;
        }
        return res;
    }

    public String getMm_day() {
        return this.mm_day;
    }

    public String getMm_month() {
        return this.mm_month;
    }

    public String getMm_timeZone() {
        return this.mm_timeZone;
    }

    public void setMm_day(String string) {
        this.mm_day = string;
    }

    public void setMm_month(String string) {
        this.mm_month = string;
    }

    public void setMm_timeZone(String string) {
        this.mm_timeZone = string;
    }

    public static void isDigit(String str, String type) {
        int i = 0;
        while (i < str.length()) {
            if (!Character.isDigit(str.charAt(i))) {
                throw new IllegalArgumentException("Lexical Representation Error: " + type + " field must be digits ");
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        try {
            GMonthDay md1 = new GMonthDay("--21-10");
            System.out.println("md1" + md1.getRepresentation());
            GMonthDay md2 = new GMonthDay("--21-01Z");
            System.out.println("md2" + md2.getRepresentation());
            GMonthDay md3 = new GMonthDay("--21-01+02:12");
            System.out.println("md3" + md3.getRepresentation());
            GMonthDay md4 = new GMonthDay("--21-01-03:42");
            System.out.println("md4" + md4.getRepresentation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

