/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.types;

import com.sapportals.portal.prt.logger.ILogger;
import com.sapportals.portal.prt.runtime.PortalRuntime;

public class Base64 {
    private byte[] mm_valueBytes = null;
    private byte[] mm_valueBytesEncoded = null;
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 63;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int SIXBIT = 6;
    private static final int FOURBYTE = 4;
    private static final byte PAD = 61;
    private static byte[] base64Alphabet = new byte[255];
    private static byte[] lookUpBase64Alphabet = new byte[63];
    static final int[] base64;

    public Base64(byte[] value) {
        byte[] t1 = value;
        this.mm_valueBytes = value;
        this.encode();
    }

    public Base64() {
    }

    public byte[] getValue() {
        return this.mm_valueBytes;
    }

    public byte[] getValueEncoded() {
        return this.mm_valueBytesEncoded;
    }

    public void setValueEncoded(byte[] val) {
        block2: {
            this.mm_valueBytesEncoded = val;
            try {
                this.decode();
            }
            catch (Exception ex) {
                ILogger logger = PortalRuntime.getLogger((String)"SOAPLogger");
                if (logger == null || !logger.isActive()) break block2;
                logger.warning((Object)this, (Throwable)ex, "SetValueEncoded Method failed");
            }
        }
    }

    public void setValue(byte[] val) {
        this.mm_valueBytes = val;
        this.encode();
    }

    public String toString() {
        return new String(this.mm_valueBytesEncoded);
    }

    static boolean isBase64(byte octect) {
        return octect == 61 || base64Alphabet[octect] != -1;
    }

    static boolean isArrayByteBase64(byte[] arrayOctect) {
        int length = arrayOctect.length;
        if (length == 0) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!Base64.isBase64(arrayOctect[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public byte[] encode() {
        if (this.mm_valueBytes != null) {
            int lengthDataBits = this.mm_valueBytes.length * 8;
            int fewerThan24bits = lengthDataBits % 24;
            int numberTriplets = lengthDataBits / 24;
            Object encodedData = null;
            this.mm_valueBytesEncoded = fewerThan24bits != 0 ? new byte[(numberTriplets + 1) * 4] : new byte[numberTriplets * 4];
            byte k = 0;
            byte l = 0;
            byte b1 = 0;
            byte b2 = 0;
            byte b3 = 0;
            int encodedIndex = 0;
            int dataIndex = 0;
            int i = 0;
            i = 0;
            while (i < numberTriplets) {
                dataIndex = i * 3;
                b1 = this.mm_valueBytes[dataIndex];
                b2 = this.mm_valueBytes[dataIndex + 1];
                b3 = this.mm_valueBytes[dataIndex + 2];
                l = (byte)(b2 & 0xF);
                k = (byte)(b1 & 3);
                encodedIndex = i * 4;
                this.mm_valueBytesEncoded[encodedIndex] = lookUpBase64Alphabet[b1 >> 2];
                this.mm_valueBytesEncoded[encodedIndex + 1] = lookUpBase64Alphabet[b2 >> 4 | k << 4];
                this.mm_valueBytesEncoded[encodedIndex + 2] = lookUpBase64Alphabet[l << 2 | b3 >> 6];
                this.mm_valueBytesEncoded[encodedIndex + 3] = lookUpBase64Alphabet[b3 & 0x3F];
                ++i;
            }
            dataIndex = i * 3;
            encodedIndex = i * 4;
            if (fewerThan24bits == 8) {
                b1 = this.mm_valueBytes[dataIndex];
                k = (byte)(b1 & 3);
                this.mm_valueBytesEncoded[encodedIndex] = lookUpBase64Alphabet[b1 >> 2];
                this.mm_valueBytesEncoded[encodedIndex + 1] = lookUpBase64Alphabet[k << 4];
                this.mm_valueBytesEncoded[encodedIndex + 2] = 61;
                this.mm_valueBytesEncoded[encodedIndex + 3] = 61;
            } else if (fewerThan24bits == 16) {
                b1 = this.mm_valueBytes[dataIndex];
                b2 = this.mm_valueBytes[dataIndex + 1];
                l = (byte)(b2 & 0xF);
                k = (byte)(b1 & 3);
                this.mm_valueBytesEncoded[encodedIndex] = lookUpBase64Alphabet[b1 >> 2];
                this.mm_valueBytesEncoded[encodedIndex + 1] = lookUpBase64Alphabet[b2 >> 4 | k << 4];
                this.mm_valueBytesEncoded[encodedIndex + 2] = lookUpBase64Alphabet[l << 2];
                this.mm_valueBytesEncoded[encodedIndex + 3] = 61;
            }
            return this.mm_valueBytesEncoded;
        }
        return null;
    }

    public byte[] decode() {
        try {
            if (this.mm_valueBytesEncoded != null) {
                int numberQuadruple = this.mm_valueBytesEncoded.length / 4;
                byte b1 = 0;
                byte b2 = 0;
                byte b3 = 0;
                byte b4 = 0;
                byte marker0 = 0;
                byte marker1 = 0;
                int encodedIndex = 0;
                int dataIndex = 0;
                this.mm_valueBytes = new byte[numberQuadruple * 3 + 1];
                int i = 0;
                while (i < numberQuadruple) {
                    dataIndex = i * 4;
                    marker0 = this.mm_valueBytesEncoded[dataIndex + 2];
                    marker1 = this.mm_valueBytesEncoded[dataIndex + 3];
                    b1 = base64Alphabet[this.mm_valueBytesEncoded[dataIndex]];
                    b2 = base64Alphabet[this.mm_valueBytesEncoded[dataIndex + 1]];
                    if (marker0 != 61 && marker1 != 61) {
                        b3 = base64Alphabet[marker0];
                        b4 = base64Alphabet[marker1];
                        this.mm_valueBytes[encodedIndex] = (byte)(b1 << 2 | b2 >> 4);
                        this.mm_valueBytes[encodedIndex + 1] = (byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF);
                        this.mm_valueBytes[encodedIndex + 2] = (byte)(b3 << 6 | b4);
                    } else if (marker0 == 61) {
                        this.mm_valueBytes[encodedIndex] = (byte)(b1 << 2 | b2 >> 4);
                        this.mm_valueBytes[encodedIndex + 1] = (byte)((b2 & 0xF) << 4);
                        this.mm_valueBytes[encodedIndex + 2] = 0;
                    } else if (marker1 == 61) {
                        b3 = base64Alphabet[marker0];
                        this.mm_valueBytes[encodedIndex] = (byte)(b1 << 2 | b2 >> 4);
                        this.mm_valueBytes[encodedIndex + 1] = (byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF);
                        this.mm_valueBytes[encodedIndex + 2] = (byte)(b3 << 6);
                    }
                    encodedIndex += 3;
                    ++i;
                }
                return this.mm_valueBytes;
            }
            return this.mm_valueBytes;
        }
        catch (Exception ex) {
            ILogger logger = PortalRuntime.getLogger((String)"SOAPLogger");
            if (logger != null && logger.isActive()) {
                logger.warning((Object)this, (Throwable)ex, "The value is no correct");
            }
            return null;
        }
    }

    public static String base64Decode(String orig) {
        char[] chars = orig.toCharArray();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int shift = 0;
        int acc = 0;
        i = 0;
        while (i < chars.length) {
            int v = base64[chars[i] & 0xFF];
            if (v >= 64) {
                if (chars[i] != '=') {
                    System.out.println("Wrong char in base64: " + chars[i]);
                }
            } else {
                acc = acc << 6 | v;
                if ((shift += 6) >= 8) {
                    sb.append((char)(acc >> (shift -= 8) & 0xFF));
                }
            }
            ++i;
        }
        return sb.toString();
    }

    static {
        int i = 0;
        while (i < 255) {
            Base64.base64Alphabet[i] = -1;
            ++i;
        }
        int i2 = 90;
        while (i2 >= 65) {
            Base64.base64Alphabet[i2] = (byte)(i2 - 65);
            --i2;
        }
        int i3 = 122;
        while (i3 >= 97) {
            Base64.base64Alphabet[i3] = (byte)(i3 - 97 + 26);
            --i3;
        }
        int i4 = 57;
        while (i4 >= 48) {
            Base64.base64Alphabet[i4] = (byte)(i4 - 48 + 52);
            --i4;
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
        int i5 = 0;
        while (i5 <= 25) {
            Base64.lookUpBase64Alphabet[i5] = (byte)(65 + i5);
            ++i5;
        }
        int i6 = 26;
        int j = 0;
        while (i6 <= 51) {
            Base64.lookUpBase64Alphabet[i6] = (byte)(97 + j);
            ++i6;
            ++j;
        }
        int i7 = 52;
        int j2 = 0;
        while (i7 <= 61) {
            Base64.lookUpBase64Alphabet[i7] = (byte)(48 + j2);
            ++i7;
            ++j2;
        }
        base64 = new int[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 62, 64, 64, 64, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 64, 64, 64, 64, 64, 64, 64, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 64, 64, 64, 64, 64, 64, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
    }
}

