/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.types;

import java.net.MalformedURLException;

public class AnyURI {
    private static final String SEPARATOR = "/";
    private static final String RESERVED_CHARACTERS = ";/?:@&=+$,";
    private static final String MARK_CHARACTERS = "-_.!~*'() ";
    private static final String SCHEME_CHARACTERS = "+-.";
    private static final String USERINFO_CHARACTERS = ";:&=+$,";
    private String m_scheme = null;
    private String m_userinfo = null;
    private String m_host = null;
    private int m_port = -1;
    private String m_path = null;
    private String m_queryString = null;
    private String m_fragment = null;

    public AnyURI() {
    }

    public AnyURI(String p_uriSpec) throws MalformedURLException {
        this.initialize(p_uriSpec);
    }

    public AnyURI(String p_scheme, String p_userinfo, String p_host, int p_port, String p_path, String p_queryString, String p_fragment) throws MalformedURLException {
        if (p_scheme == null || p_scheme.trim().length() == 0) {
            throw new MalformedURLException("Scheme is required!");
        }
        if (p_host == null) {
            if (p_userinfo != null) {
                throw new MalformedURLException("Userinfo may not be specified if host is not specified!");
            }
            if (p_port != -1) {
                throw new MalformedURLException("Port may not be specified if host is not specified!");
            }
        }
        if (p_path != null) {
            if (p_path.indexOf(63) != -1 && p_queryString != null) {
                throw new MalformedURLException("Query string cannot be specified in path and query string!");
            }
            if (p_path.indexOf(35) != -1 && p_fragment != null) {
                throw new MalformedURLException("Fragment cannot be specified in both the path and fragment!");
            }
        }
        this.setScheme(p_scheme);
        this.setHost(p_host);
        this.setPort(p_port);
        this.setUserinfo(p_userinfo);
        this.setPath(p_path);
        this.setQueryString(p_queryString);
        this.setFragment(p_fragment);
    }

    private void initialize(String p_uriSpec) throws MalformedURLException {
        if (p_uriSpec == null || p_uriSpec.trim().length() == 0) {
            throw new MalformedURLException("Cannot initialize URI from empty string.");
        }
        String uriSpec = p_uriSpec.trim();
        int uriSpecLen = uriSpec.length();
        int index = 0;
        if (uriSpec.indexOf(58) == -1) {
            throw new MalformedURLException("No scheme found in URI: " + uriSpec);
        }
        this.initializeScheme(uriSpec);
        index = this.m_scheme.length() + 1;
        if (index + 1 < uriSpecLen && uriSpec.substring(index).startsWith("//")) {
            int startPos = index += 2;
            char testChar = '\u0000';
            while (index < uriSpecLen) {
                testChar = uriSpec.charAt(index);
                if (testChar == '/' || testChar == '?' || testChar == '#') break;
                ++index;
            }
            if (index > startPos) {
                this.initializeAuthority(uriSpec.substring(startPos, index));
            } else {
                this.m_host = "";
            }
        }
        this.initializePath(uriSpec.substring(index));
    }

    private void initializeScheme(String p_uriSpec) throws MalformedURLException {
        int uriSpecLen = p_uriSpec.length();
        int index = 0;
        String scheme = null;
        char testChar = '\u0000';
        while (index < uriSpecLen) {
            testChar = p_uriSpec.charAt(index);
            if (testChar == ':' || testChar == '/' || testChar == '?' || testChar == '#') break;
            ++index;
        }
        if ((scheme = p_uriSpec.substring(0, index)).length() == 0) {
            throw new MalformedURLException("No scheme found in URI.");
        }
        this.setScheme(scheme);
    }

    private void initializeAuthority(String p_uriSpec) throws MalformedURLException {
        int index = 0;
        int start = 0;
        int end = p_uriSpec.length();
        char testChar = '\u0000';
        String userinfo = null;
        if (p_uriSpec.indexOf(64, start) != -1) {
            while (index < end) {
                testChar = p_uriSpec.charAt(index);
                if (testChar == '@') break;
                ++index;
            }
            userinfo = p_uriSpec.substring(start, index);
            ++index;
        }
        String host = null;
        start = index;
        while (index < end) {
            testChar = p_uriSpec.charAt(index);
            if (testChar == ':') break;
            ++index;
        }
        host = p_uriSpec.substring(start, index);
        int port = -1;
        if (host.length() > 0 && testChar == ':') {
            start = ++index;
            while (index < end) {
                ++index;
            }
            String portStr = p_uriSpec.substring(start, index);
            if (portStr.length() > 0) {
                int i = 0;
                while (i < portStr.length()) {
                    if (!AnyURI.isDigit(portStr.charAt(i))) {
                        throw new MalformedURLException(portStr + " is invalid. Port should only contain digits!");
                    }
                    ++i;
                }
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        this.setHost(host);
        this.setPort(port);
        this.setUserinfo(userinfo);
    }

    private void initializePath(String p_uriSpec) throws MalformedURLException {
        if (p_uriSpec == null) {
            throw new MalformedURLException("Cannot initialize path from null string!");
        }
        int index = 0;
        int start = 0;
        int end = p_uriSpec.length();
        char testChar = '\u0000';
        while (index < end) {
            testChar = p_uriSpec.charAt(index);
            if (testChar == '?' || testChar == '#') break;
            if (testChar == '%') {
                if (index + 2 >= end || !AnyURI.isHex(p_uriSpec.charAt(index + 1)) || !AnyURI.isHex(p_uriSpec.charAt(index + 2))) {
                    throw new MalformedURLException("Path contains invalid escape sequence!");
                }
            } else if (!AnyURI.isReservedCharacter(testChar) && !AnyURI.isUnreservedCharacter(testChar) && '\\' != testChar) {
                throw new MalformedURLException("Path contains invalid character: " + testChar);
            }
            ++index;
        }
        this.m_path = p_uriSpec.substring(start, index);
        if (testChar == '?') {
            start = ++index;
            while (index < end) {
                testChar = p_uriSpec.charAt(index);
                if (testChar == '#') break;
                if (testChar == '%') {
                    if (index + 2 >= end || !AnyURI.isHex(p_uriSpec.charAt(index + 1)) || !AnyURI.isHex(p_uriSpec.charAt(index + 2))) {
                        throw new MalformedURLException("Query string contains invalid escape sequence!");
                    }
                } else if (!AnyURI.isReservedCharacter(testChar) && !AnyURI.isUnreservedCharacter(testChar)) {
                    throw new MalformedURLException("Query string contains invalid character:" + testChar);
                }
                ++index;
            }
            this.m_queryString = p_uriSpec.substring(start, index);
        }
        if (testChar == '#') {
            start = ++index;
            while (index < end) {
                testChar = p_uriSpec.charAt(index);
                if (testChar == '%') {
                    if (index + 2 >= end || !AnyURI.isHex(p_uriSpec.charAt(index + 1)) || !AnyURI.isHex(p_uriSpec.charAt(index + 2))) {
                        throw new MalformedURLException("Fragment contains invalid escape sequence!");
                    }
                } else if (!AnyURI.isReservedCharacter(testChar) && !AnyURI.isUnreservedCharacter(testChar)) {
                    throw new MalformedURLException("Fragment contains invalid character:" + testChar);
                }
                ++index;
            }
            this.m_fragment = p_uriSpec.substring(start, index);
        }
    }

    public String getScheme() {
        return this.m_scheme;
    }

    public String getSchemeSpecificPart() {
        StringBuffer schemespec = new StringBuffer();
        if (this.m_userinfo != null || this.m_host != null || this.m_port != -1) {
            schemespec.append("//");
        }
        if (this.m_userinfo != null) {
            schemespec.append(this.m_userinfo);
            schemespec.append('@');
        }
        if (this.m_host != null) {
            schemespec.append(this.m_host);
        }
        if (this.m_port != -1) {
            schemespec.append(':');
            schemespec.append(this.m_port);
        }
        if (this.m_path != null) {
            schemespec.append(this.m_path);
        }
        if (this.m_queryString != null) {
            schemespec.append('?');
            schemespec.append(this.m_queryString);
        }
        if (this.m_fragment != null) {
            schemespec.append('#');
            schemespec.append(this.m_fragment);
        }
        return schemespec.toString();
    }

    public String getUserinfo() {
        return this.m_userinfo;
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public String getPath(boolean p_includeQueryString, boolean p_includeFragment) {
        StringBuffer pathString = new StringBuffer(this.m_path);
        if (p_includeQueryString && this.m_queryString != null) {
            pathString.append('?');
            pathString.append(this.m_queryString);
        }
        if (p_includeFragment && this.m_fragment != null) {
            pathString.append('#');
            pathString.append(this.m_fragment);
        }
        return pathString.toString();
    }

    public String getPath() {
        return this.m_path;
    }

    public String getQueryString() {
        return this.m_queryString;
    }

    public String getFragment() {
        return this.m_fragment;
    }

    public void setScheme(String p_scheme) throws MalformedURLException {
        if (p_scheme == null) {
            throw new MalformedURLException("Cannot set scheme from null string!");
        }
        if (!AnyURI.isConformantSchemeName(p_scheme)) {
            throw new MalformedURLException("The scheme is not conformant.");
        }
        this.m_scheme = p_scheme.toLowerCase();
    }

    public void setUserinfo(String p_userinfo) throws MalformedURLException {
        if (p_userinfo == null) {
            this.m_userinfo = null;
        } else {
            if (this.m_host == null) {
                throw new MalformedURLException("Userinfo cannot be set when host is null!");
            }
            int index = 0;
            int end = p_userinfo.length();
            char testChar = '\u0000';
            while (index < end) {
                testChar = p_userinfo.charAt(index);
                if (testChar == '%') {
                    if (index + 2 >= end || !AnyURI.isHex(p_userinfo.charAt(index + 1)) || !AnyURI.isHex(p_userinfo.charAt(index + 2))) {
                        throw new MalformedURLException("Userinfo contains invalid escape sequence!");
                    }
                } else if (!AnyURI.isUnreservedCharacter(testChar) && USERINFO_CHARACTERS.indexOf(testChar) == -1) {
                    throw new MalformedURLException("Userinfo contains invalid character:" + testChar);
                }
                ++index;
            }
        }
        this.m_userinfo = p_userinfo;
    }

    public void setHost(String p_host) throws MalformedURLException {
        if (p_host == null || p_host.trim().length() == 0) {
            this.m_host = p_host;
            this.m_userinfo = null;
            this.m_port = -1;
        } else if (!this.isWellFormedAddress(p_host)) {
            throw new MalformedURLException("Host is not a well formed address!");
        }
        this.m_host = p_host;
    }

    public void setPort(int p_port) throws MalformedURLException {
        if (p_port >= 0 && p_port <= 65535) {
            if (this.m_host == null) {
                throw new MalformedURLException("Port cannot be set when host is null!");
            }
        } else if (p_port != -1) {
            throw new MalformedURLException("Invalid port number!");
        }
        this.m_port = p_port;
    }

    public void setPath(String p_path) throws MalformedURLException {
        if (p_path == null) {
            this.m_path = null;
            this.m_queryString = null;
            this.m_fragment = null;
        } else {
            this.initializePath(p_path);
        }
    }

    public void appendPath(String p_addToPath) throws MalformedURLException {
        if (p_addToPath == null || p_addToPath.trim().length() == 0) {
            return;
        }
        if (!AnyURI.isURIString(p_addToPath)) {
            throw new MalformedURLException("Path contains invalid character!");
        }
        this.m_path = this.m_path == null || this.m_path.trim().length() == 0 ? (p_addToPath.startsWith(SEPARATOR) ? p_addToPath : SEPARATOR + p_addToPath) : (this.m_path.endsWith(SEPARATOR) ? (p_addToPath.startsWith(SEPARATOR) ? this.m_path.concat(p_addToPath.substring(1)) : this.m_path.concat(p_addToPath)) : (p_addToPath.startsWith(SEPARATOR) ? this.m_path.concat(p_addToPath) : this.m_path.concat(SEPARATOR + p_addToPath)));
    }

    public void setQueryString(String p_queryString) throws MalformedURLException {
        if (p_queryString == null) {
            this.m_queryString = null;
        } else {
            if (!this.isGenericURI()) {
                throw new MalformedURLException("Query string can only be set for a generic URI!");
            }
            if (this.getPath() == null) {
                throw new MalformedURLException("Query string cannot be set when path is null!");
            }
            if (!AnyURI.isURIString(p_queryString)) {
                throw new MalformedURLException("Query string contains invalid character!");
            }
            this.m_queryString = p_queryString;
        }
    }

    public void setFragment(String p_fragment) throws MalformedURLException {
        if (p_fragment == null) {
            this.m_fragment = null;
        } else {
            if (!this.isGenericURI()) {
                throw new MalformedURLException("Fragment can only be set for a generic URI!");
            }
            if (this.getPath() == null) {
                throw new MalformedURLException("Fragment cannot be set when path is null!");
            }
            if (!AnyURI.isURIString(p_fragment)) {
                throw new MalformedURLException("Fragment contains invalid character!");
            }
            this.m_fragment = p_fragment;
        }
    }

    public boolean equals(Object p_test) {
        if (p_test instanceof AnyURI) {
            AnyURI testURI = (AnyURI)p_test;
            if ((this.m_scheme == null && testURI.m_scheme == null || this.m_scheme != null && testURI.m_scheme != null && this.m_scheme.equals(testURI.m_scheme)) && (this.m_userinfo == null && testURI.m_userinfo == null || this.m_userinfo != null && testURI.m_userinfo != null && this.m_userinfo.equals(testURI.m_userinfo)) && (this.m_host == null && testURI.m_host == null || this.m_host != null && testURI.m_host != null && this.m_host.equals(testURI.m_host)) && this.m_port == testURI.m_port && (this.m_path == null && testURI.m_path == null || this.m_path != null && testURI.m_path != null && this.m_path.equals(testURI.m_path)) && (this.m_queryString == null && testURI.m_queryString == null || this.m_queryString != null && testURI.m_queryString != null && this.m_queryString.equals(testURI.m_queryString)) && (this.m_fragment == null && testURI.m_fragment == null || this.m_fragment != null && testURI.m_fragment != null && this.m_fragment.equals(testURI.m_fragment))) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer uriSpecString = new StringBuffer();
        if (this.m_scheme != null) {
            uriSpecString.append(this.m_scheme);
            uriSpecString.append(':');
        }
        uriSpecString.append(this.getSchemeSpecificPart());
        return uriSpecString.toString();
    }

    public boolean isGenericURI() {
        return this.m_host != null;
    }

    public static boolean isConformantSchemeName(String p_scheme) {
        if (p_scheme == null || p_scheme.trim().length() == 0) {
            return false;
        }
        if (!AnyURI.isAlpha(p_scheme.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < p_scheme.length()) {
            char testChar = p_scheme.charAt(i);
            if (!AnyURI.isAlphanum(testChar) && SCHEME_CHARACTERS.indexOf(testChar) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isWellFormedAddress(String p_address) {
        if (p_address == null) {
            return false;
        }
        String address = p_address.trim();
        int addrLength = address.length();
        if (addrLength == 0 || addrLength > 255) {
            return false;
        }
        if (address.startsWith(".") || address.startsWith("-")) {
            return false;
        }
        int index = address.lastIndexOf(46);
        if (address.endsWith(".")) {
            index = address.substring(0, index).lastIndexOf(46);
        }
        if (index + 1 < addrLength && AnyURI.isDigit(p_address.charAt(index + 1))) {
            int numDots = 0;
            int i = 0;
            while (i < addrLength) {
                char testChar = address.charAt(i);
                if (testChar == '.') {
                    if (!AnyURI.isDigit(address.charAt(i - 1)) || i + 1 < addrLength && !AnyURI.isDigit(address.charAt(i + 1))) {
                        return false;
                    }
                    ++numDots;
                } else if (!AnyURI.isDigit(testChar)) {
                    return false;
                }
                ++i;
            }
            if (numDots != 3) {
                return false;
            }
        } else {
            int i = 0;
            while (i < addrLength) {
                char testChar = address.charAt(i);
                if (testChar == '.') {
                    if (!AnyURI.isAlphanum(address.charAt(i - 1))) {
                        return false;
                    }
                    if (i + 1 < addrLength && !AnyURI.isAlphanum(address.charAt(i + 1))) {
                        return false;
                    }
                } else if (!AnyURI.isAlphanum(testChar) && testChar != '-') {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static boolean isDigit(char p_char) {
        return p_char >= '0' && p_char <= '9';
    }

    private static boolean isHex(char p_char) {
        return AnyURI.isDigit(p_char) || p_char >= 'a' && p_char <= 'f' || p_char >= 'A' && p_char <= 'F';
    }

    private static boolean isAlpha(char p_char) {
        return p_char >= 'a' && p_char <= 'z' || p_char >= 'A' && p_char <= 'Z';
    }

    private static boolean isAlphanum(char p_char) {
        return AnyURI.isAlpha(p_char) || AnyURI.isDigit(p_char);
    }

    private static boolean isReservedCharacter(char p_char) {
        return RESERVED_CHARACTERS.indexOf(p_char) != -1;
    }

    private static boolean isUnreservedCharacter(char p_char) {
        return AnyURI.isAlphanum(p_char) || MARK_CHARACTERS.indexOf(p_char) != -1;
    }

    private static boolean isURIString(String p_uric) {
        if (p_uric == null) {
            return false;
        }
        int end = p_uric.length();
        char testChar = '\u0000';
        int i = 0;
        while (i < end) {
            testChar = p_uric.charAt(i);
            if (testChar == '%') {
                if (i + 2 >= end || !AnyURI.isHex(p_uric.charAt(i + 1)) || !AnyURI.isHex(p_uric.charAt(i + 2))) {
                    return false;
                }
                i += 2;
            } else if (!AnyURI.isReservedCharacter(testChar) && !AnyURI.isUnreservedCharacter(testChar)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            new AnyURI("http://www.pocketsoap.com/weblog/");
            new AnyURI("urn:ietf:params:xml:ns:myex myex.xsd");
            AnyURI obj = new AnyURI("http://a/b/c/d;p?q");
            obj.appendPath("g:h");
            System.out.println(obj);
            obj.appendPath("g");
            System.out.println(obj);
            obj.appendPath("./g");
            System.out.println(obj);
            System.out.println(obj.getFragment());
            System.out.println(obj.getHost());
            System.out.println(obj.getPath());
            System.out.println(obj.getPort());
            System.out.println(obj.getQueryString());
            System.out.println(obj.getScheme());
            System.out.println(obj.getUserinfo());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }
}

