/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.mapping;

import com.sapportals.portal.prt.service.soap.ISOAPParamConstants;
import com.sapportals.portal.prt.service.soap.decoding.SOAPDeserializer;
import com.sapportals.portal.prt.service.soap.encoding.SOAPSerializer;
import com.sapportals.portal.prt.service.soap.mapping.ISpecializedRegistry;
import com.sapportals.portal.prt.service.soap.processor.IMethodsAuthorizedProcessor;
import com.sapportals.portal.prt.service.soap.processor.ISOAPHeaderProcessor;
import com.sapportals.portal.prt.service.soap.util.QName;
import com.sapportals.portal.prt.service.soap.util.QNameURI;
import com.sapportals.portal.prt.util.RecyclableStringBuffer;
import com.sapportals.portal.prt.util.StringBufferPool;
import java.util.Hashtable;

public class SOAPRegistry {
    private static SOAPRegistry mm_instance = null;
    private static String soapEncURI = "http://schemas.xmlsoap.org/soap/encoding/";
    private Hashtable mm_listSerializer = new Hashtable();
    private Hashtable mm_listDeserializer = new Hashtable();
    private Hashtable mm_listXml2Java = new Hashtable();
    private Hashtable mm_listJava2Xml = new Hashtable();
    private Hashtable mm_listeRegistry = new Hashtable();
    private Hashtable mm_listMethodsAutorized = new Hashtable();
    private Hashtable mm_listJava2Namespace = new Hashtable();
    private Hashtable mm_listHeaderProcessor = new Hashtable();
    private Hashtable hashPrimitives = new Hashtable();
    private QName mm_arrayQName = null;
    private SOAPSerializer mm_arraySerializer = null;
    private RecyclableStringBuffer mm_bufferGenerateKey = new RecyclableStringBuffer();
    static /* synthetic */ Class class$java$util$Map;

    private SOAPRegistry() {
        this.init();
    }

    public static SOAPRegistry getInstance() {
        if (mm_instance == null) {
            mm_instance = new SOAPRegistry();
        }
        return mm_instance;
    }

    private void destroyLocal() {
        if (mm_instance != null) {
            this.mm_listDeserializer = null;
            this.mm_listMethodsAutorized = null;
            this.mm_listeRegistry = null;
            this.mm_listHeaderProcessor = null;
            this.mm_listJava2Xml = null;
            this.mm_listSerializer = null;
            this.mm_listXml2Java = null;
        }
    }

    public static void destroy() {
        if (mm_instance != null) {
            mm_instance.destroyLocal();
        }
        mm_instance = null;
        soapEncURI = null;
    }

    public SOAPDeserializer getDeserializer(QName qname, String targetNamespace) {
        String key = null;
        key = qname.getNamespaceURI().equals("http://prt.java.soap/schemas") ? this.generateKeyForElementType(qname.getNamespaceURI(), qname) : this.generateKeyForElementType(targetNamespace, qname);
        SOAPDeserializer des = (SOAPDeserializer)this.mm_listDeserializer.get(key);
        return des;
    }

    public SOAPSerializer getSerializer(Class type, String encodingStyleURI) {
        QNameURI qname;
        if (type.isArray()) {
            return this.mm_arraySerializer;
        }
        String key = this.generateKeyForJavaClass(encodingStyleURI, type);
        SOAPSerializer ser = (SOAPSerializer)this.mm_listSerializer.get(key);
        if (ser == null && (qname = this.getElementType(type)) != null) {
            key = this.generateKeyForJavaClass(qname.getQName().getNamespaceURI(), type);
            ser = (SOAPSerializer)this.mm_listSerializer.get(key);
        }
        return ser;
    }

    public QName getElementType(Class type, String targetNamespace) {
        if (type != null && type.isArray() && targetNamespace != null && targetNamespace.equals(soapEncURI)) {
            return this.mm_arrayQName;
        }
        String key = this.generateKeyForJavaClass(targetNamespace, type);
        return (QName)this.mm_listJava2Xml.get(key);
    }

    public QNameURI getElementType(Class type) {
        if (type != null && type.isArray()) {
            return new QNameURI(this.mm_arrayQName, "SOAP-ENC");
        }
        String key = null;
        QName qname = null;
        int i = 0;
        while (i < ISOAPParamConstants.NS_URIS_SCHEMAS.length) {
            key = this.generateKeyForJavaClass(ISOAPParamConstants.NS_URIS_SCHEMAS[i], type);
            qname = (QName)this.mm_listJava2Xml.get(key);
            if (qname != null && !qname.getNamespaceURI().equals("http://www.w3.org/1999/XMLSchema") && !qname.getNamespaceURI().equals("http://www.w3.org/2000/10/XMLSchema")) {
                return new QNameURI(qname, ISOAPParamConstants.NS_URIS_SCHEMAS[i]);
            }
            ++i;
        }
        return null;
    }

    public String getDefaultNamespace(Class type) {
        if (type != null && type.isArray()) {
            return this.mm_arrayQName.getNamespaceURI();
        }
        String key = null;
        QName qname = null;
        int i = 0;
        while (i < ISOAPParamConstants.NS_URIS_SCHEMAS.length) {
            key = this.generateKeyForJavaClass(ISOAPParamConstants.NS_URIS_SCHEMAS[i], type);
            qname = (QName)this.mm_listJava2Xml.get(key);
            if (qname != null) {
                return qname.getNamespaceURI();
            }
            ++i;
        }
        return null;
    }

    public Class getJavaType(QName qname, String targetNamespace) {
        String key = this.generateKeyForElementType(targetNamespace, qname);
        Class javaType = (Class)this.mm_listXml2Java.get(key);
        if (javaType != null) {
            return javaType;
        }
        int i = 0;
        while (i < ISOAPParamConstants.NS_URIS_SCHEMAS.length) {
            key = this.generateKeyForElementType(ISOAPParamConstants.NS_URIS_SCHEMAS[i], qname);
            javaType = (Class)this.mm_listXml2Java.get(key);
            if (javaType != null) break;
            ++i;
        }
        return javaType;
    }

    public boolean isPrimitive(Class aClass) {
        return this.hashPrimitives.containsKey(aClass);
    }

    private void init() {
        this.initPrimitives();
    }

    private void initPrimitives() {
        this.hashPrimitives.put(Integer.TYPE, Integer.TYPE);
        this.hashPrimitives.put(Float.TYPE, Float.TYPE);
        this.hashPrimitives.put(Long.TYPE, Long.TYPE);
        this.hashPrimitives.put(Short.TYPE, Short.TYPE);
        this.hashPrimitives.put(Byte.TYPE, Byte.TYPE);
        this.hashPrimitives.put(Double.TYPE, Double.TYPE);
        this.hashPrimitives.put(Boolean.TYPE, Boolean.TYPE);
        this.hashPrimitives.put(Void.TYPE, Void.TYPE);
        this.hashPrimitives.put(class$java$util$Map == null ? (class$java$util$Map = SOAPRegistry.class$("java.util.Map")) : class$java$util$Map, class$java$util$Map == null ? (class$java$util$Map = SOAPRegistry.class$("java.util.Map")) : class$java$util$Map);
    }

    public void addMappings(String namespace, Class javaType, QName name, SOAPDeserializer deserializer, SOAPSerializer serializer) {
        String keyForXml = this.generateKeyForElementType(namespace, name);
        String keyForJava = this.generateKeyForJavaClass(namespace, javaType);
        if (deserializer != null) {
            this.mm_listDeserializer.put(keyForXml, deserializer);
        }
        if (serializer != null) {
            this.mm_listSerializer.put(keyForJava, serializer);
        }
        if (name != null && javaType != null) {
            this.mm_listJava2Xml.put(keyForJava, name);
            this.mm_listXml2Java.put(keyForXml, javaType);
            this.mm_listJava2Namespace.put(javaType.getName(), namespace);
        }
    }

    private final String generateKeyForJavaClass(String namespace, Object type) {
        if (type == null) {
            return "";
        }
        RecyclableStringBuffer recyclable = StringBufferPool.getInstance().get(255);
        recyclable.getBuffer().append(namespace);
        recyclable.getBuffer().append(type.toString());
        String key = recyclable.toString();
        StringBufferPool.getInstance().release(recyclable);
        return key;
    }

    private final String generateKeyForElementType(String namespace, Object type) {
        if (type == null) {
            return "";
        }
        return type.toString();
    }

    public void addSpecializedRegistry(String name, ISpecializedRegistry registry) {
        this.mm_listeRegistry.put(name, registry);
    }

    public ISpecializedRegistry getSpecializedRegistry(String name) {
        return (ISpecializedRegistry)this.mm_listeRegistry.get(name);
    }

    public Hashtable getAllSpecializedRegistry() {
        return this.mm_listeRegistry;
    }

    public ISpecializedRegistry removeSpecializedRegistry(String name) {
        ISpecializedRegistry registry = (ISpecializedRegistry)this.mm_listeRegistry.remove(name);
        this.mm_listMethodsAutorized.remove(name);
        return registry;
    }

    public void addMethodsAuthorizedProcessor(String name, IMethodsAuthorizedProcessor methods) {
        this.mm_listMethodsAutorized.put(name, methods);
    }

    public IMethodsAuthorizedProcessor getMethodsAuthorizedProcessor(String name) {
        return (IMethodsAuthorizedProcessor)this.mm_listMethodsAutorized.get(name);
    }

    public void setArrayQName(QName name) {
        this.mm_arrayQName = name;
    }

    public QName getArrayQName() {
        return this.mm_arrayQName;
    }

    public void setArraySerializer(SOAPSerializer ser) {
        this.mm_arraySerializer = ser;
    }

    public ISOAPHeaderProcessor getHeaderProcessor(String action) {
        return (ISOAPHeaderProcessor)this.mm_listHeaderProcessor.get(action);
    }

    public Hashtable getListSerializers() {
        return this.mm_listSerializer;
    }

    public Hashtable getListUnSerializers() {
        return this.mm_listDeserializer;
    }

    public Hashtable getListJavaTypes() {
        return this.mm_listXml2Java;
    }

    public Hashtable getListQName() {
        return this.mm_listJava2Xml;
    }

    public Hashtable getListSpecializedRegistry() {
        return this.mm_listeRegistry;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

