/*
 * Decompiled with CFR 0.152.
 */
package com.sapportals.portal.prt.service.soap.exception;

import com.sapportals.portal.prt.logger.ILogger;
import com.sapportals.portal.prt.runtime.PortalRuntime;
import com.sapportals.portal.prt.service.soap.ISOAPService;
import com.sapportals.portal.prt.service.soap.exception.PRTFault;
import javax.xml.soap.SOAPMessage;

public class SoapFaultHandler {
    private static SoapFaultHandler faultHandler = null;
    private ILogger mm_logger = PortalRuntime.getLogger((String)"SOAPLogger");
    private ISOAPService mm_soapService = null;

    private SoapFaultHandler(ISOAPService soapService) {
        this.mm_soapService = soapService;
    }

    public static SoapFaultHandler getInstance() {
        return faultHandler;
    }

    public static SoapFaultHandler constructInstance(ISOAPService soapService) {
        faultHandler = new SoapFaultHandler(soapService);
        return faultHandler;
    }

    public ILogger getLogger() {
        return this.mm_logger;
    }

    public boolean isDebugMode() {
        try {
            return this.mm_soapService.getConfigurationSOAPService().readPropertieBoolean("debugmode");
        }
        catch (Exception ex) {
            ILogger logger = PortalRuntime.getLogger((String)"SOAPLogger");
            if (logger != null && logger.isActive()) {
                logger.warning((Object)this, (Throwable)ex, "isDebugMode Method failed");
            }
            return false;
        }
    }

    public SOAPMessage consumeSOAPPRTMessageFault(Throwable fault) {
        if (faultHandler != null) {
            try {
                PRTFault prtfault = PRTFault.makePrtFault(this, fault);
                if (this.mm_logger != null && this.mm_logger.isActive()) {
                    this.mm_logger.log(((Throwable)((Object)prtfault)).fillInStackTrace(), prtfault.getFaultString(), prtfault.getLevelError());
                }
                return prtfault.getMsgFault();
            }
            catch (Exception ex) {
                ILogger logger = PortalRuntime.getLogger((String)"SOAPLogger");
                if (logger != null && logger.isActive()) {
                    logger.warning((Object)this, (Throwable)ex, "consumeSOAPPRTMessageFault Method failed");
                }
                return null;
            }
        }
        return null;
    }

    public SOAPMessage constructSOAPMessage() {
        try {
            SOAPMessage msg = this.mm_soapService.getMsgFactory().createMessage();
            return msg;
        }
        catch (Exception ex) {
            ILogger logger = PortalRuntime.getLogger((String)"SOAPLogger");
            if (logger != null && logger.isActive()) {
                logger.warning((Object)this, (Throwable)ex, "consumeSOAPPRTMessageFault Method failed");
            }
            return null;
        }
    }
}

