/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.proxy;

import com.tssap.selena.internal.model.providers.proxy.ProxyPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;

public class ProxyMetaInfo {
    public static final String DOMAIN = "com.tssap.selena.proxy";
    public static final String AUTO_SUBDOMAIN = "auto";
    public static final String HIDDEN = "com.tssap.selena.proxy.hidden";
    private static final int SOURCE_MODEL_POS = 0;
    private static final int SOURCE_POS = 1;
    private static final int PARAMETERS_POS = 2;
    private static final int DATA_OFF = 3;
    private static final int UNFF = 4;

    private ProxyMetaInfo() {
    }

    public static boolean isProxyUniqueName(UniqueName un) {
        return DOMAIN.equals(un.getDomain());
    }

    public static boolean isValidProxyUniqueName(UniqueName proxy) {
        int sourcePos;
        int sourceModelPos;
        int pc = proxy.getParametersCount();
        if (pc < 15) {
            return false;
        }
        try {
            sourceModelPos = Integer.parseInt(proxy.getParameter(0));
            if (sourceModelPos < 7) {
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        try {
            sourcePos = Integer.parseInt(proxy.getParameter(1));
            if (sourcePos < sourceModelPos + 4) {
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        try {
            int parametersPos = Integer.parseInt(proxy.getParameter(2));
            if (parametersPos < sourcePos + 4 || parametersPos > pc) {
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static boolean isAutoProxyUniqueName(UniqueName proxy) {
        if (AUTO_SUBDOMAIN.equals(proxy.getSubDomain())) {
            return true;
        }
        UniqueName parent = ProxyMetaInfo.getParentUniqueName(proxy);
        if (!ProxyMetaInfo.isProxyUniqueName(parent)) {
            return false;
        }
        Element source = ProxyMetaInfo.getSourceElement(proxy);
        if (source == null || source.isDeleted()) {
            return false;
        }
        Entity sourceParent = source.getParent();
        if (sourceParent == null || sourceParent.isDeleted()) {
            return false;
        }
        UniqueName parentSource = ProxyMetaInfo.getSourceUniqueName(parent);
        return sourceParent.getUniqueName().equals(parentSource);
    }

    private static UniqueName getProxyUniqueName(String subdomain, UniqueName parent, UniqueName sourceModel, UniqueName source, String[] parameters) {
        int parentSize = ProxyMetaInfo.getUniqueNameSize(parent);
        int sourceModelSize = ProxyMetaInfo.getUniqueNameSize(sourceModel);
        int sourceSize = ProxyMetaInfo.getUniqueNameSize(source);
        int parametersSize = ProxyMetaInfo.getParametersSize(parameters);
        String[] buffer = new String[3 + parentSize + sourceModelSize + sourceSize + parametersSize];
        int sourceModelPos = 3 + parentSize;
        int sourcePos = sourceModelPos + sourceModelSize;
        int parametersPos = sourcePos + sourceSize;
        buffer[0] = String.valueOf(sourceModelPos);
        buffer[1] = String.valueOf(sourcePos);
        buffer[2] = String.valueOf(parametersPos);
        ProxyMetaInfo.writeUniqueName(buffer, parent, 3);
        ProxyMetaInfo.writeUniqueName(buffer, sourceModel, sourceModelPos);
        ProxyMetaInfo.writeUniqueName(buffer, source, sourcePos);
        ProxyMetaInfo.writeParameters(buffer, parameters, parametersPos);
        return ModelAccess.createUniqueName((String)DOMAIN, (String)subdomain, null, null, (String[])buffer);
    }

    public static UniqueName getAutoProxyUniqueName(UniqueName parent, UniqueName sourceModel, UniqueName source, String[] parameters) {
        return ProxyMetaInfo.getProxyUniqueName(AUTO_SUBDOMAIN, parent, sourceModel, source, parameters);
    }

    public static UniqueName getAutoProxyUniqueName(UniqueName parent, UniqueName sourceModel, UniqueName source) {
        return ProxyMetaInfo.getProxyUniqueName(AUTO_SUBDOMAIN, parent, sourceModel, source, null);
    }

    public static UniqueName getProxyUniqueName(UniqueName parent, UniqueName sourceModel, UniqueName source, String[] parameters) {
        return ProxyMetaInfo.getProxyUniqueName(null, parent, sourceModel, source, parameters);
    }

    public static UniqueName getProxyUniqueName(UniqueName parent, UniqueName sourceModel, UniqueName source) {
        return ProxyMetaInfo.getProxyUniqueName(parent, sourceModel, source, null);
    }

    public static UniqueName getParentUniqueName(UniqueName proxy) {
        try {
            int pc = Integer.parseInt(proxy.getParameter(0)) - 3 - 4;
            return ProxyMetaInfo.readUniqueName(proxy, 3, pc);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static UniqueName getSourceModelUniqueName(UniqueName proxy) {
        try {
            int pos = Integer.parseInt(proxy.getParameter(0));
            int pc = Integer.parseInt(proxy.getParameter(1)) - pos - 4;
            return ProxyMetaInfo.readUniqueName(proxy, pos, pc);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static UniqueName getSourceUniqueName(UniqueName proxy) {
        try {
            int pos = Integer.parseInt(proxy.getParameter(1));
            int pc = Integer.parseInt(proxy.getParameter(2)) - pos - 4;
            return ProxyMetaInfo.readUniqueName(proxy, pos, pc);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static int getParametersCount(UniqueName proxy) {
        try {
            int pos = Integer.parseInt(proxy.getParameter(2));
            return proxy.getParametersCount() - pos;
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public static String getParameter(UniqueName proxy, int index) {
        try {
            int pos = Integer.parseInt(proxy.getParameter(2));
            return proxy.getParameter(pos + index);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static String[] getParameters(UniqueName proxy) {
        String[] parameters = new String[ProxyMetaInfo.getParametersCount(proxy)];
        int i = 0;
        while (i < parameters.length) {
            parameters[i] = ProxyMetaInfo.getParameter(proxy, i);
            ++i;
        }
        return parameters;
    }

    public static Model getSourceModel(UniqueName proxy) {
        return ModelAccess.getModel((UniqueName)ProxyMetaInfo.getSourceModelUniqueName(proxy));
    }

    public static Element getSourceElement(UniqueName proxy) {
        Model sourceModel = ProxyMetaInfo.getSourceModel(proxy);
        return sourceModel == null ? null : sourceModel.findElement(ProxyMetaInfo.getSourceUniqueName(proxy));
    }

    public static Entity getSourceEntity(UniqueName proxy) {
        Model sourceModel = ProxyMetaInfo.getSourceModel(proxy);
        return sourceModel == null ? null : sourceModel.findEntity(ProxyMetaInfo.getSourceUniqueName(proxy));
    }

    public static String toString(UniqueName uniqueName) {
        return ProxyMetaInfo.toString(uniqueName, "");
    }

    public static String toString(UniqueName uniqueName, String offset) {
        if (!ProxyMetaInfo.isProxyUniqueName(uniqueName)) {
            return uniqueName.toString();
        }
        String suboffset = offset + "\t";
        StringBuffer buffer = new StringBuffer("\n");
        buffer.append(offset);
        buffer.append("parent:        ");
        buffer.append(ProxyMetaInfo.toString(ProxyMetaInfo.getParentUniqueName(uniqueName), suboffset));
        buffer.append("\n");
        buffer.append(offset);
        buffer.append("source model:  ");
        buffer.append(ProxyMetaInfo.toString(ProxyMetaInfo.getSourceModelUniqueName(uniqueName), suboffset));
        buffer.append("\n");
        buffer.append(offset);
        buffer.append("source:        ");
        buffer.append(ProxyMetaInfo.toString(ProxyMetaInfo.getSourceUniqueName(uniqueName), suboffset));
        buffer.append("\n");
        buffer.append(offset);
        buffer.append("parameters:    [");
        int i = 0;
        while (i < ProxyMetaInfo.getParametersCount(uniqueName)) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(ProxyMetaInfo.getParameter(uniqueName, i));
            ++i;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static void bind(UniqueName proxy, UniqueName proxyModel) {
        if (!ProxyMetaInfo.isProxyUniqueName(proxy)) {
            throw new IllegalArgumentException();
        }
        ProxyPlugin.bind(proxy, proxyModel);
    }

    /*
     * Unable to fully structure code
     */
    public static void bind(UniqueNameEnumeration proxies, UniqueName proxyModel) {
        if (proxies != null) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            ProxyMetaInfo.bind(proxies.next(), proxyModel);
lbl4:
            // 2 sources

            ** while (proxies.hasMoreElements())
        }
lbl5:
        // 1 sources

    }

    private static int getUniqueNameSize(UniqueName un) {
        return 4 + un.getParametersCount();
    }

    private static int getParametersSize(String[] parameters) {
        return parameters == null ? 0 : parameters.length;
    }

    private static UniqueName readUniqueName(UniqueName proxy, int pos, int pc) {
        String domain = proxy.getParameter(pos++);
        String subdomain = proxy.getParameter(pos++);
        String location = proxy.getParameter(pos++);
        String name = proxy.getParameter(pos++);
        String[] parameters = null;
        if (pc > 0) {
            parameters = new String[pc];
            int i = 0;
            while (i < pc) {
                parameters[i] = proxy.getParameter(pos++);
                ++i;
            }
        }
        return ModelAccess.createUniqueName((String)domain, (String)subdomain, (String)location, (String)name, (String[])parameters);
    }

    private static void writeUniqueName(String[] buffer, UniqueName un, int pos) {
        buffer[pos++] = un.getDomain();
        buffer[pos++] = un.getSubDomain();
        buffer[pos++] = un.getLocation();
        buffer[pos++] = un.getName();
        int pc = un.getParametersCount();
        int i = 0;
        while (i < pc) {
            buffer[pos++] = un.getParameter(i);
            ++i;
        }
    }

    private static void writeParameters(String[] buffer, String[] parameters, int pos) {
        if (parameters == null) {
            return;
        }
        int i = 0;
        while (i < parameters.length) {
            buffer[i + pos] = parameters[i];
            ++i;
        }
    }
}

