/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.proxy;

import com.tssap.selena.internal.model.providers.proxy.ProxyPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractHiddenPropertyProvider
implements PropertyGetProvider {
    private List myHiddenProperties = new ArrayList();
    private static final Map ourHiddenPropertyPool = new HashMap();

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return "com.tssap.selena.proxy.hidden".equals(propertyName);
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        return EnumerationConverter.toPropertyEnumeration(this.myHiddenProperties.iterator());
    }

    public PropertyEnumeration properties(Element element) {
        return this.properties(element, "com.tssap.selena.proxy.hidden");
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public String getPropertyValue(Element element, String propertyName) {
        return null;
    }

    public boolean hasProperty(Element element, String propertyName) {
        return false;
    }

    public Property getProperty(Element element, String propertyName) {
        return null;
    }

    protected void addHiddenPropertyName(String name) {
        Property property = (Property)ourHiddenPropertyPool.get(name);
        if (property == null) {
            property = new HiddenProperty(name, null);
            ourHiddenPropertyPool.put(name, property);
            ProxyPlugin.logInfo("Hidden property pooled [" + name + "]");
        }
        this.myHiddenProperties.add(property);
    }

    protected void addHiddenProperty(Property property) {
        if (!"com.tssap.selena.proxy.hidden".equals(property.getName())) {
            throw new IllegalArgumentException();
        }
        this.myHiddenProperties.add(property);
    }

    public static class HiddenProperty
    implements Property {
        private String myName;
        private Element myElement;

        public HiddenProperty(String name, Element element) {
            if (name == null) {
                throw new NullPointerException();
            }
            this.myName = name;
            this.myElement = element;
        }

        public String getName() {
            return "com.tssap.selena.proxy.hidden";
        }

        public String getValue() {
            return this.myName;
        }

        public boolean isWritable() {
            return false;
        }

        public boolean canSetValue(String newValue) {
            return false;
        }

        public void setValue(String newValue) {
        }

        public PropertyMap getSubproperties() {
            return null;
        }

        public Element getElement() {
            return this.myElement;
        }
    }
}

