/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.providers.proxy.ui;

import com.tssap.selena.internal.model.providers.proxy.ProxyDeltaProvider;
import com.tssap.selena.internal.model.providers.proxy.ProxyModelRegistry;
import com.tssap.selena.internal.model.providers.proxy.ProxyPlugin;
import com.tssap.selena.internal.model.providers.proxy.ui.AbstractProxyView;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public final class RegistryView
extends AbstractProxyView {
    private Tree myRegistryControl;
    private static final Comparator PROVIDER_CMP = new Comparator(){

        public int compare(Object o1, Object o2) {
            ProxyDeltaProvider p1 = (ProxyDeltaProvider)o1;
            ProxyDeltaProvider p2 = (ProxyDeltaProvider)o2;
            Model m1 = p1.getModel();
            if (m1 == null) {
                return -1;
            }
            Model m2 = p2.getModel();
            if (m2 == null) {
                return 1;
            }
            UniqueName uin1 = m1.getUniqueName();
            UniqueName uin2 = m2.getUniqueName();
            return uin1.toString().compareToIgnoreCase(uin2.toString());
        }

        public boolean equals(Object obj) {
            return false;
        }
    };
    private static final Comparator REGISTRY_CMP = new Comparator(){

        public int compare(Object o1, Object o2) {
            ProxyModelRegistry r1 = (ProxyModelRegistry)o1;
            ProxyModelRegistry r2 = (ProxyModelRegistry)o2;
            Model m1 = r1.getSourceModel();
            if (m1 == null) {
                return -1;
            }
            Model m2 = r2.getSourceModel();
            if (m2 == null) {
                return 1;
            }
            UniqueName uin1 = m1.getUniqueName();
            UniqueName uin2 = m2.getUniqueName();
            return uin1.toString().compareToIgnoreCase(uin2.toString());
        }

        public boolean equals(Object obj) {
            return false;
        }
    };
    private static final Comparator UIN_CMP = new Comparator(){

        public int compare(Object o1, Object o2) {
            UniqueName uin1 = (UniqueName)o1;
            UniqueName uin2 = (UniqueName)o2;
            return uin1.toString().compareToIgnoreCase(uin2.toString());
        }

        public boolean equals(Object obj) {
            return false;
        }
    };

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.snapshot();
    }

    public void clear() {
        this.myRegistryControl.removeAll();
        super.clear();
    }

    protected Control createPrimaryControl(Composite parent) {
        this.myRegistryControl = this.createTreeControl(parent);
        return this.myRegistryControl;
    }

    public void snapshot() {
        ProxyDeltaProvider[] providers;
        if (this.myRegistryControl.getItemCount() > 0) {
            TreeItem sepItem = new TreeItem(this.myRegistryControl, 0);
            Image image = ProxyPlugin.getImage("proxy.snapshot");
            if (image != null) {
                sepItem.setImage(image);
            }
        }
        if ((providers = ProxyPlugin.getDeltaProviders()) == null || providers.length == 0) {
            return;
        }
        Arrays.sort(providers, PROVIDER_CMP);
        int i = 0;
        while (i < providers.length) {
            ProxyDeltaProvider provider = providers[i];
            if (provider != null) {
                Map parents;
                TreeItem proxyModelItem = this.addProxyModel(provider.getModel());
                ProxyModelRegistry[] registries = provider.getModelRegistries();
                if (registries != null && registries.length > 0) {
                    Arrays.sort(registries, REGISTRY_CMP);
                    int j = 0;
                    while (j < registries.length) {
                        ProxyModelRegistry registry = registries[j];
                        if (registry != null) {
                            TreeItem sourceModelItem = this.addSourceModel(proxyModelItem, registry.getSourceModel());
                            Map bindings = registry.getBindingsCopy();
                            if (bindings != null && !bindings.isEmpty()) {
                                ArrayList sourceUins = new ArrayList(bindings.keySet());
                                Collections.sort(sourceUins, UIN_CMP);
                                int k = 0;
                                while (k < sourceUins.size()) {
                                    UniqueName sourceUin = (UniqueName)sourceUins.get(k);
                                    if (sourceUin != null) {
                                        TreeItem sourceUinItem = this.addSourceUin(sourceModelItem, sourceUin);
                                        Object proxyUinsObj = bindings.get(sourceUin);
                                        if (proxyUinsObj != null) {
                                            if (proxyUinsObj instanceof UniqueName) {
                                                this.addProxyUin(sourceUinItem, (UniqueName)proxyUinsObj);
                                            } else if (proxyUinsObj instanceof List) {
                                                List proxyUins = (List)proxyUinsObj;
                                                Collections.sort(proxyUins, UIN_CMP);
                                                int m = 0;
                                                while (m < proxyUins.size()) {
                                                    this.addProxyUin(sourceUinItem, (UniqueName)proxyUins.get(m));
                                                    ++m;
                                                }
                                            } else {
                                                TreeItem item = new TreeItem(sourceUinItem, 0);
                                                item.setText(proxyUinsObj.toString());
                                            }
                                        }
                                    }
                                    ++k;
                                }
                            }
                        }
                        ++j;
                    }
                }
                if (!(parents = provider.getParentsCopy()).isEmpty()) {
                    ArrayList parentUins = new ArrayList(parents.keySet());
                    Collections.sort(parentUins, UIN_CMP);
                    int j = 0;
                    while (j < parentUins.size()) {
                        UniqueName parentUin = (UniqueName)parentUins.get(j);
                        TreeItem parentUinItem = this.addUin(proxyModelItem, parentUin);
                        Object children = parents.get(parentUin);
                        if (children != null) {
                            if (children instanceof UniqueName) {
                                this.addUin(parentUinItem, (UniqueName)children);
                            } else if (children instanceof List) {
                                List childUins = (List)children;
                                int m = 0;
                                while (m < childUins.size()) {
                                    this.addUin(parentUinItem, (UniqueName)childUins.get(m));
                                    ++m;
                                }
                            } else {
                                TreeItem item = new TreeItem(parentUinItem, 0);
                                item.setText(children.toString());
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private TreeItem addProxyModel(Model model) {
        TreeItem item = new TreeItem(this.myRegistryControl, 0);
        item.setText(model == null ? "Unknown" : model.getUniqueName().toString());
        Image image = ProxyPlugin.getImage("proxy.proxy.model");
        if (image != null) {
            item.setImage(image);
        }
        return item;
    }

    private TreeItem addProxyUin(TreeItem parent, UniqueName uin) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(uin == null ? "Unknown" : uin.toString());
        Image image = ProxyPlugin.getImage("proxy.proxy.object");
        if (image != null) {
            item.setImage(image);
        }
        return item;
    }

    private TreeItem addSourceModel(TreeItem parent, Model model) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(model == null ? "Unknown" : model.getUniqueName().toString());
        Image image = ProxyPlugin.getImage("proxy.source.model");
        if (image != null) {
            item.setImage(image);
        }
        return item;
    }

    private TreeItem addSourceUin(TreeItem parent, UniqueName uin) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(uin == null ? "Unknown" : uin.toString());
        Image image = ProxyPlugin.getImage("proxy.source.object");
        if (image != null) {
            item.setImage(image);
        }
        return item;
    }

    private TreeItem addUin(TreeItem parent, UniqueName uin) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(uin == null ? "Unknown" : uin.toString());
        Image image = ProxyPlugin.getImage("proxy.uin");
        if (image != null) {
            item.setImage(image);
        }
        return item;
    }
}

