/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.providers.proxy.ui;

import com.tssap.selena.impl.model.elements.UniqueNameImpl;
import com.tssap.selena.internal.model.providers.proxy.ProxyPlugin;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ProxyUniqueNameComponent
extends SashForm {
    private UniqueName myUin;
    private Tree myStructureControl;
    private Table myDetailsControl;
    private TableColumn myNameColumn;
    private TableColumn myValueColumn;
    private static final String DOMAIN = "domain";
    private static final String SUBDOMAIN = "subdomain";
    private static final String LOCATION = "location";
    private static final String NAME = "name";
    private static final String PARAMETER = "parameter";
    private static final int GAP = 10;

    public ProxyUniqueNameComponent(Composite parent, int style) {
        super(parent, style);
        this.setOrientation(512);
        this.myStructureControl = new Tree((Composite)this, 2048);
        this.myStructureControl.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof TreeItem) {
                    ProxyUniqueNameComponent.this.processItemSelection(((TreeItem)e.item).getText());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.item instanceof TreeItem) {
                    TreeItem item;
                    item.setExpanded(!(item = (TreeItem)e.item).getExpanded());
                }
            }
        });
        this.myDetailsControl = new Table((Composite)this, 67584);
        this.myNameColumn = new TableColumn(this.myDetailsControl, 0);
        this.myValueColumn = new TableColumn(this.myDetailsControl, 0);
    }

    public static TreeItem addUniqueName(Tree tree, UniqueName uin) {
        if (uin == null) {
            return null;
        }
        TreeItem uinItem = new TreeItem(tree, 0);
        ProxyUniqueNameComponent.addUniqueName(uinItem, uin);
        uinItem.setExpanded(true);
        return uinItem;
    }

    public static void addUniqueName(TreeItem uinItem, UniqueName uin) {
        uinItem.setText(uin == null ? "Unknown" : uin.toString());
        Image uinImage = ProxyPlugin.getImage("proxy.uin");
        if (uinImage != null) {
            uinItem.setImage(uinImage);
        }
        if (ProxyMetaInfo.isProxyUniqueName(uin)) {
            String[] params;
            Image proxyImage = ProxyPlugin.getImage("proxy.proxy");
            if (proxyImage != null) {
                uinItem.setImage(proxyImage);
            }
            TreeItem parentUinItem = new TreeItem(uinItem, 0);
            ProxyUniqueNameComponent.addUniqueName(parentUinItem, ProxyMetaInfo.getParentUniqueName(uin));
            TreeItem sourceModelUinItem = new TreeItem(uinItem, 0);
            ProxyUniqueNameComponent.addUniqueName(sourceModelUinItem, ProxyMetaInfo.getSourceModelUniqueName(uin));
            Image sourceModelImage = ProxyPlugin.getImage("proxy.source.model");
            if (sourceModelImage != null) {
                sourceModelUinItem.setImage(sourceModelImage);
            }
            TreeItem sourceUinItem = new TreeItem(uinItem, 0);
            ProxyUniqueNameComponent.addUniqueName(sourceUinItem, ProxyMetaInfo.getSourceUniqueName(uin));
            Image sourceImage = ProxyPlugin.getImage("proxy.source.object");
            if (sourceImage != null) {
                sourceUinItem.setImage(sourceImage);
            }
            if ((params = ProxyMetaInfo.getParameters(uin)) != null && params.length > 0) {
                Image paramImage = ProxyPlugin.getImage("proxy.proxy.parameter");
                int i = 0;
                while (i < params.length) {
                    TreeItem paramItem = new TreeItem(uinItem, 0);
                    paramItem.setText(params[i]);
                    if (paramImage != null) {
                        paramItem.setImage(paramImage);
                    }
                    ++i;
                }
            }
        }
    }

    public void setUniqueName(UniqueName uin) {
        boolean bl = this.myUin == null ? uin == null : this.myUin.equals(uin);
        if (bl) {
            return;
        }
        this.myStructureControl.removeAll();
        this.myDetailsControl.removeAll();
        this.myUin = uin;
        ProxyUniqueNameComponent.addUniqueName(this.myStructureControl, this.myUin);
        this.processItemSelection(this.myUin == null ? null : this.myUin.toString());
    }

    public final UniqueName getUniqueName() {
        return this.myUin;
    }

    protected void processItemSelection(String s) {
        this.myDetailsControl.removeAll();
        UniqueNameImpl uin = null;
        try {
            uin = new UniqueNameImpl(s);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (uin != null) {
            this.addDetailsItem(DOMAIN, uin.getDomain());
            this.addDetailsItem(SUBDOMAIN, uin.getSubDomain());
            this.addDetailsItem(LOCATION, uin.getLocation());
            this.addDetailsItem(NAME, uin.getName());
            int i = 0;
            while (i < uin.getParametersCount()) {
                this.addDetailsItem(PARAMETER + i, uin.getParameter(i));
                ++i;
            }
        }
        this.myNameColumn.setWidth(-1);
        this.myValueColumn.setWidth(-1);
    }

    private void addDetailsItem(String name, String value) {
        TableItem item = new TableItem(this.myDetailsControl, 0);
        if (name == null) {
            name = "";
        }
        item.setText(0, name);
        if (value == null) {
            value = "";
        }
        item.setText(1, value);
    }
}

