/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.providers.proxy.ui;

import com.tssap.selena.internal.model.providers.proxy.ProxyDeltaProvider;
import com.tssap.selena.internal.model.providers.proxy.ProxyPlugin;
import com.tssap.selena.internal.model.providers.proxy.ui.AbstractProxyView;
import com.tssap.selena.model.elements.ModelAccessEvent;
import com.tssap.selena.model.elements.ModelAccessListener;
import com.tssap.selena.model.elements.ModelChangeEvent;
import com.tssap.selena.model.elements.ModelChangeListener;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import java.util.Enumeration;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public final class ModelDeltaHistoryView
extends AbstractProxyView
implements ModelAccessListener,
ModelChangeListener {
    private Tree myHistoryControl;

    public void modelCreated(ModelAccessEvent event) {
        event.getModel().addModelDeltaListener((ModelChangeListener)this);
    }

    public void modelRemoved(ModelAccessEvent event) {
        event.getModel().removeModelDeltaListener((ModelChangeListener)this);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProxyDeltaProvider[] providers = ProxyPlugin.getDeltaProviders();
        int i = 0;
        while (i < providers.length) {
            providers[i].getModel().addModelDeltaListener((ModelChangeListener)this);
            ++i;
        }
    }

    public void dispose() {
        ProxyDeltaProvider[] providers = ProxyPlugin.getDeltaProviders();
        int i = 0;
        while (i < providers.length) {
            providers[i].getModel().removeModelDeltaListener((ModelChangeListener)this);
            ++i;
        }
        super.dispose();
    }

    public void clear() {
        this.myHistoryControl.removeAll();
        super.clear();
    }

    protected Control createPrimaryControl(Composite parent) {
        this.myHistoryControl = this.createTreeControl(parent);
        return this.myHistoryControl;
    }

    public void modelChanged(ModelChangeEvent event) {
        this.addDelta(null, event.getRootDelta());
    }

    private void addDelta(TreeItem parentItem, ModelDeltaNode mdn) {
        UniqueName origUin;
        TreeItem item = parentItem == null ? new TreeItem(this.myHistoryControl, 0) : new TreeItem(parentItem, 0);
        UniqueName uin = mdn.getElementUniqueName();
        if (uin == null) {
            this.logInvalidDeltaMsg("mdn element unique name is not specified", mdn);
        }
        item.setText(uin == null ? "Unknown" : uin.toString());
        Image image = this.getModelDeltaNodeImage(mdn);
        if (image != null) {
            item.setImage(image);
        }
        if ((origUin = mdn.getOriginalElementUniqueName()) != null && !origUin.equals(uin)) {
            TreeItem origItem = new TreeItem(item, 0);
            origItem.setExpanded(true);
            origItem.setText(origUin.toString());
            image = ProxyPlugin.getImage("proxy.uin");
            if (image != null) {
                origItem.setImage(image);
            }
        }
        Enumeration children = mdn.changedChildren();
        if (mdn.isEmpty() && children.hasMoreElements()) {
            this.logInvalidDeltaMsg("mdn is empty but has children", mdn);
        }
        while (children.hasMoreElements()) {
            Object child = children.nextElement();
            if (!(child instanceof ModelDeltaNode)) {
                this.logInvalidDeltaMsg("mdn child is not an mdn", child);
                continue;
            }
            this.addDelta(item, (ModelDeltaNode)child);
        }
        item.setExpanded(true);
    }

    private Image getModelDeltaNodeImage(ModelDeltaNode mdn) {
        Image image = null;
        if (mdn.isTotallyChanged()) {
            image = ProxyPlugin.getImage("proxy.mdnk.tchanged");
        }
        if (mdn.isDeleted()) {
            if (image != null) {
                this.logMultiStateMdnMsg(mdn);
                return image;
            }
            image = ProxyPlugin.getImage("proxy.mdnk.deleted");
        }
        if (mdn.isNew()) {
            if (image != null) {
                this.logMultiStateMdnMsg(mdn);
                return image;
            }
            image = ProxyPlugin.getImage("proxy.mdnk.new");
        }
        if (mdn.isChanged()) {
            if (image != null) {
                this.logMultiStateMdnMsg(mdn);
                return image;
            }
            image = ProxyPlugin.getImage("proxy.mdnk.changed");
        }
        return image;
    }

    private void logMultiStateMdnMsg(ModelDeltaNode mdn) {
        this.logInvalidDeltaMsg("mdn has multiple states", mdn);
    }

    private void logInvalidDeltaMsg(String msg, Object value) {
        ProxyPlugin.logWarning("invalid delta : " + msg + " : " + value);
    }
}

