/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.internal.model.providers.proxy;

import com.tssap.selena.internal.model.providers.proxy.ProxyPropertyProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;

public final class ProxyPropertyGetProvider
extends ProxyPropertyProvider
implements PropertyGetProvider {
    public boolean hasProperty(Element element, String propertyName) {
        if ("com.tssap.selena.proxy.hidden".equals(propertyName)) {
            return false;
        }
        if (this.isHidden(propertyName, element)) {
            return false;
        }
        Element source = ProxyMetaInfo.getSourceElement(element.getUniqueName());
        return source.hasProperty(propertyName);
    }

    public Property getProperty(Element element, String propertyName) {
        if ("com.tssap.selena.proxy.hidden".equals(propertyName)) {
            return null;
        }
        if (this.isHidden(propertyName, element)) {
            return null;
        }
        Element source = ProxyMetaInfo.getSourceElement(element.getUniqueName());
        return source.getProperty(propertyName);
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        if ("com.tssap.selena.proxy.hidden".equals(propertyName)) {
            return false;
        }
        if (this.isHidden(propertyName, element)) {
            return false;
        }
        Element source = ProxyMetaInfo.getSourceElement(element.getUniqueName());
        return source.hasPropertyValue(propertyName, propertyValue);
    }

    public String getPropertyValue(Element element, String propertyName) {
        if ("com.tssap.selena.proxy.hidden".equals(propertyName)) {
            return null;
        }
        if (this.isHidden(propertyName, element)) {
            return null;
        }
        Element source = ProxyMetaInfo.getSourceElement(element.getUniqueName());
        return source.getPropertyValue(propertyName);
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        if ("com.tssap.selena.proxy.hidden".equals(propertyName)) {
            return EmptyEnumeration.getPropertyEnumeration();
        }
        if (this.isHidden(propertyName, element)) {
            return EmptyEnumeration.getPropertyEnumeration();
        }
        Element source = ProxyMetaInfo.getSourceElement(element.getUniqueName());
        return source.properties(propertyName);
    }

    public PropertyEnumeration properties(Element element) {
        Element source = ProxyMetaInfo.getSourceElement(element.getUniqueName());
        PropertyEnumeration properties = source.properties();
        if (properties == null || !properties.hasMoreElements()) {
            return properties;
        }
        ArrayList<Property> filtered = new ArrayList<Property>();
        while (properties.hasMoreElements()) {
            Property next = properties.next();
            if ("com.tssap.selena.proxy.hidden".equals(next.getName()) || this.isHidden(next.getName(), element)) continue;
            filtered.add(next);
        }
        return EnumerationConverter.toPropertyEnumeration(filtered.iterator());
    }
}

